/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.io.pagecache.context.CursorContext;

public class CountsDelta
implements CountsAccessor,
CountsAccessor.Updater {
    private static final long DEFAULT_COUNT = 0L;
    protected final LongLongHashMap nodeCounts = new LongLongHashMap();
    protected final MutableMap<RelationshipKey, MutableLong> relationshipCounts = UnifiedMap.newMap();

    @Override
    public long nodeCount(int labelId, CursorContext cursorContext) {
        return this.nodeCounts.getIfAbsent((long)labelId, 0L);
    }

    @Override
    public void incrementNodeCount(long labelId, long delta) {
        if (delta != 0L) {
            this.nodeCounts.updateValue(labelId, 0L, (LongToLongFunction & Serializable)l -> l + delta);
        }
    }

    @Override
    public long relationshipCount(int startLabelId, int typeId, int endLabelId, CursorContext cursorContext) {
        RelationshipKey relationshipKey = new RelationshipKey(startLabelId, typeId, endLabelId);
        MutableLong counts = (MutableLong)this.relationshipCounts.get((Object)relationshipKey);
        return counts == null ? 0L : counts.longValue();
    }

    @Override
    public void incrementRelationshipCount(long startLabelId, int typeId, long endLabelId, long delta) {
        if (delta != 0L) {
            RelationshipKey relationshipKey = new RelationshipKey(Math.toIntExact(startLabelId), typeId, Math.toIntExact(endLabelId));
            ((MutableLong)this.relationshipCounts.getIfAbsentPutWithKey((Object)relationshipKey, (Function & Serializable)k -> new MutableLong(0L))).add(delta);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void accept(CountsVisitor visitor, CursorContext cursorContext) {
        this.nodeCounts.forEachKeyValue((LongLongProcedure & Serializable)(id, count) -> visitor.visitNodeCount(Math.toIntExact(id), count));
        this.relationshipCounts.forEachKeyValue((Procedure2 & Serializable)(k, count) -> visitor.visitRelationshipCount(k.startLabelId, k.typeId, k.endLabelId, count.longValue()));
    }

    public boolean hasChanges() {
        return !this.nodeCounts.isEmpty() || !this.relationshipCounts.isEmpty();
    }

    public static class RelationshipKey {
        public final int startLabelId;
        public final int typeId;
        public final int endLabelId;

        RelationshipKey(int startLabelId, int typeId, int endLabelId) {
            this.startLabelId = startLabelId;
            this.typeId = typeId;
            this.endLabelId = endLabelId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationshipKey that = (RelationshipKey)o;
            return this.startLabelId == that.startLabelId && this.typeId == that.typeId && this.endLabelId == that.endLabelId;
        }

        public int hashCode() {
            return Objects.hash(this.startLabelId, this.typeId, this.endLabelId);
        }
    }
}

