/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.util.Timer;
import java.util.TimerTask;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.DefaultUdcInformationCollector;
import org.neo4j.ext.udc.impl.UdcTimerTask;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class UdcKernelExtension
implements Lifecycle {
    private Timer timer;
    private Config config;
    private XaDataSourceManager xadsm;
    private KernelData kernelData;

    public UdcKernelExtension(Config config, XaDataSourceManager xadsm, KernelData kernelData, Timer timer) {
        this.config = config;
        this.xadsm = xadsm;
        this.kernelData = kernelData;
        this.timer = timer;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        if (!((Boolean)this.config.get(UdcSettings.udc_enabled)).booleanValue()) {
            return;
        }
        int firstDelay = (Integer)this.config.get(UdcSettings.first_delay);
        int interval = (Integer)this.config.get(UdcSettings.interval);
        String hostAddress = (String)this.config.get(UdcSettings.udc_host);
        DefaultUdcInformationCollector collector = new DefaultUdcInformationCollector(this.config, this.xadsm, this.kernelData);
        UdcTimerTask task = new UdcTimerTask(hostAddress, collector);
        this.timer.scheduleAtFixedRate((TimerTask)task, firstDelay, (long)interval);
    }

    public void stop() throws Throwable {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void shutdown() throws Throwable {
    }
}

