/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Properties;

public final class DumpUtils {
    private DumpUtils() {
    }

    public static String threadDump() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        Properties systemProperties = System.getProperties();
        return DumpUtils.threadDump(threadMxBean, systemProperties);
    }

    public static String threadDump(ThreadMXBean threadMxBean, Properties systemProperties) {
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        String vmName = systemProperties.getProperty("java.vm.name");
        String vmVersion = systemProperties.getProperty("java.vm.version");
        String vmInfoString = systemProperties.getProperty("java.vm.info");
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Full thread dump %s (%s %s):\n\n", vmName, vmVersion, vmInfoString));
        for (ThreadInfo threadInfo : threadInfos) {
            sb.append(String.format("\"%s\" #%d\n", threadInfo.getThreadName(), threadInfo.getThreadId()));
            sb.append("   java.lang.Thread.State: ").append((Object)threadInfo.getThreadState()).append("\n");
            StackTraceElement[] stackTrace = threadInfo.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement e = stackTrace[i];
                sb.append("\tat ").append(e).append('\n');
                if (i == 0 && threadInfo.getLockInfo() != null) {
                    Thread.State ts = threadInfo.getThreadState();
                    switch (ts) {
                        case BLOCKED: {
                            sb.append("\t-  blocked on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                        case WAITING: {
                            sb.append("\t-  waiting on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                        case TIMED_WAITING: {
                            sb.append("\t-  waiting on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                    }
                }
                for (MonitorInfo mi : threadInfo.getLockedMonitors()) {
                    if (mi.getLockedStackDepth() != i) continue;
                    sb.append("\t-  locked ").append(mi).append('\n');
                }
            }
        }
        return sb.toString();
    }
}

