/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryDetachedCheckpoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetVersion;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;

public class CheckpointParserSetV4_2
extends LogEntryParserSet {
    public static final int MAX_DESCRIPTION_LENGTH = 120;
    public static final LogEntryParserSet V4_2 = new CheckpointParserSetV4_2();

    private CheckpointParserSetV4_2() {
        super(LogEntryParserSetVersion.CheckpointEntryV4_2);
        this.register(new LogEntryParser(8){

            @Override
            LogEntry parse(byte version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
                long logVersion = channel.getLong();
                long byteOffset = channel.getLong();
                long checkpointTimeMillis = channel.getLong();
                StoreId storeId = new StoreId(channel.getLong(), channel.getLong(), channel.getLong(), channel.getLong(), channel.getLong());
                short reasonBytesLength = channel.getShort();
                byte[] bytes = new byte[120];
                channel.get(bytes, 120);
                String reason = new String(bytes, 0, (int)reasonBytesLength, StandardCharsets.UTF_8);
                channel.endChecksumAndValidate();
                return new LogEntryDetachedCheckpoint(version, new LogPosition(logVersion, byteOffset), checkpointTimeMillis, storeId, reason);
            }
        });
    }
}

