/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryInlinedCheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

public class LogEntryParserSetV2_3
extends LogEntryParserSet {
    public static final LogEntryParserSet V2_3 = new LogEntryParserSetV2_3();

    private LogEntryParserSetV2_3() {
        super(LogEntryParserSetVersion.LogEntryV2_3);
        this.register(new LogEntryParser(1){

            @Override
            public LogEntry parse(byte version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
                LogPosition position = marker.newPosition();
                channel.getInt();
                channel.getInt();
                long timeWritten = channel.getLong();
                long latestCommittedTxWhenStarted = channel.getLong();
                int additionalHeaderLength = channel.getInt();
                byte[] additionalHeader = new byte[additionalHeaderLength];
                channel.get(additionalHeader, additionalHeaderLength);
                return new LogEntryStart(version, timeWritten, latestCommittedTxWhenStarted, 0, additionalHeader, position);
            }
        });
        this.register(new LogEntryParser(3){

            @Override
            public LogEntry parse(byte version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
                StorageCommand command = commandReaderFactory.get((int)version).read((ReadableChannel)channel);
                return command == null ? null : new LogEntryCommand(version, command);
            }
        });
        this.register(new LogEntryParser(5){

            @Override
            public LogEntry parse(byte version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
                long txId = channel.getLong();
                long timeWritten = channel.getLong();
                return new LogEntryCommit(version, txId, timeWritten, 0);
            }
        });
        this.register(new LogEntryParser(7){

            @Override
            public LogEntry parse(byte version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
                long logVersion = channel.getLong();
                long byteOffset = channel.getLong();
                return new LogEntryInlinedCheckPoint(version, new LogPosition(logVersion, byteOffset));
            }
        });
    }
}

