/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v520;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.string.Mask;

public class LogEntryStartV5_20
extends LogEntryStart {
    private final long appendIndex;
    private final int previousChecksum;

    public LogEntryStartV5_20(KernelVersion kernelVersion, long timeWritten, long lastCommittedTxWhenTransactionStarted, long appendIndex, int previousChecksum, byte[] additionalHeader, LogPosition startPosition) {
        super(kernelVersion, timeWritten, lastCommittedTxWhenTransactionStarted, additionalHeader, startPosition);
        this.previousChecksum = previousChecksum;
        this.appendIndex = appendIndex;
    }

    @Override
    public int getPreviousChecksum() {
        return this.previousChecksum;
    }

    @Override
    public long getAppendIndex() {
        return this.appendIndex;
    }

    @Override
    public String toString(Mask mask) {
        return "LogEntryStartV5_20[kernelVersion=" + this.kernelVersion() + ",time=" + this.timestamp(this.timeWritten) + ",lastCommittedTxWhenTransactionStarted=" + this.lastCommittedTxWhenTransactionStarted + ",additionalHeaderLength=" + (this.additionalHeader == null ? -1 : this.additionalHeader.length) + "," + (this.additionalHeader == null ? "" : Arrays.toString(this.additionalHeader)) + ", appendIndex=" + this.appendIndex + ", previousChecksum=" + this.previousChecksum + ", position=" + this.startPosition + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogEntryStartV5_20 that = (LogEntryStartV5_20)o;
        return this.appendIndex == that.appendIndex && this.previousChecksum == that.previousChecksum;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.appendIndex, this.previousChecksum);
    }
}

