/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;

public class TransactionLogFilesHelper {
    public static final String DEFAULT_NAME = "neostore.transaction.db";
    public static final String CHECKPOINT_FILE_PREFIX = "checkpoint";
    public static final DirectoryStream.Filter<Path> DEFAULT_FILENAME_FILTER = new LogicalLogFilenameFilter(Pattern.quote("neostore.transaction.db"), Pattern.quote("checkpoint"));
    public static final Predicate<String> DEFAULT_FILENAME_PREDICATE = file -> file.startsWith(DEFAULT_NAME) || file.startsWith(CHECKPOINT_FILE_PREFIX);
    private static final String VERSION_SUFFIX = ".";
    private static final String REGEX_VERSION_SUFFIX = "\\.";
    private static final Path[] EMPTY_FILES_ARRAY = new Path[0];
    private final Path logBaseName;
    private final FileSystemAbstraction fileSystem;
    private final Path logDirectory;
    private final DirectoryStream.Filter<Path> filenameFilter;

    public static TransactionLogFilesHelper forTransactions(FileSystemAbstraction fs, Path dir) {
        return new TransactionLogFilesHelper(fs, dir, DEFAULT_NAME);
    }

    public static TransactionLogFilesHelper forCheckpoints(FileSystemAbstraction fs, Path dir) {
        return new TransactionLogFilesHelper(fs, dir, CHECKPOINT_FILE_PREFIX);
    }

    private TransactionLogFilesHelper(FileSystemAbstraction fileSystem, Path directory, String name) {
        this.fileSystem = fileSystem;
        this.logDirectory = directory;
        this.logBaseName = directory.resolve(name);
        this.filenameFilter = new LogicalLogFilenameFilter(Pattern.quote(name));
    }

    public Path getLogFileForVersion(long version) {
        return Path.of(this.logBaseName.toAbsolutePath() + VERSION_SUFFIX + version, new String[0]);
    }

    public static long getLogVersion(Path historyLogFile) {
        String historyLogFilename = historyLogFile.getFileName().toString();
        int index = historyLogFilename.lastIndexOf(VERSION_SUFFIX);
        if (index == -1) {
            throw new RuntimeException("Invalid log file '" + historyLogFilename + "'");
        }
        return Long.parseLong(historyLogFilename.substring(index + VERSION_SUFFIX.length()));
    }

    DirectoryStream.Filter<Path> getLogFilenameFilter() {
        return this.filenameFilter;
    }

    public Path[] getMatchedFiles() throws IOException {
        Path[] files = this.fileSystem.listFiles(this.logDirectory, this.getLogFilenameFilter());
        if (files.length == 0) {
            return EMPTY_FILES_ARRAY;
        }
        Arrays.sort(files, Comparator.comparingLong(TransactionLogFilesHelper::getLogVersion));
        return files;
    }

    public boolean isLogFile(Path path) {
        try {
            return this.filenameFilter.accept(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void accept(LogVersionVisitor visitor) throws IOException {
        for (Path file : this.getMatchedFiles()) {
            visitor.visit(file, TransactionLogFilesHelper.getLogVersion(file));
        }
    }

    private static final class LogicalLogFilenameFilter
    implements DirectoryStream.Filter<Path> {
        private final Pattern[] patterns;

        LogicalLogFilenameFilter(String ... logFileNameBase) {
            Objects.requireNonNull(logFileNameBase);
            this.patterns = (Pattern[])Arrays.stream(logFileNameBase).map(name -> Pattern.compile(name + "\\..*")).toArray(Pattern[]::new);
        }

        @Override
        public boolean accept(Path entry) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(entry.getFileName().toString()).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

