/*
 * Decompiled with CFR 0.152.
 */
package apoc.bolt;

import apoc.Extended;
import apoc.bolt.ClosedAwareDelegatingIterator;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.MapUtil;
import apoc.util.UriResolver;
import apoc.util.Util;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Bolt {
    @Procedure
    @Description(value="apoc.bolt.load(url-or-key, kernelTransaction, params, config) - access to other databases via bolt for read")
    public Stream<RowResult> load(@Name(value="url") String url, @Name(value="kernelTransaction") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        if (config == null) {
            config = Collections.emptyMap();
        }
        boolean virtual = (Boolean)config.getOrDefault("virtual", false);
        boolean addStatistics = (Boolean)config.getOrDefault("statistics", false);
        boolean readOnly = (Boolean)config.getOrDefault("readOnly", true);
        Config driverConfig = this.toDriverConfig(config.getOrDefault("driverConfig", MapUtil.map(new Object[0])));
        UriResolver uri = new UriResolver(url, "bolt");
        uri.initialize();
        SessionConfig sessionConfig = SessionConfig.builder().withDefaultAccessMode(readOnly ? AccessMode.READ : AccessMode.WRITE).build();
        return this.withDriver(uri.getConfiguredUri(), uri.getToken(), driverConfig, driver -> this.withSession((Driver)driver, sessionConfig, session -> {
            if (addStatistics) {
                Result statementResult = session.run(statement, params);
                SummaryCounters counters = statementResult.consume().counters();
                return Stream.of(new RowResult(this.toMap(counters)));
            }
            return this.getRowResultStream(virtual, (Session)session, params, statement);
        }));
    }

    private <T> Stream<T> withDriver(URI uri, AuthToken token, Config config, Function<Driver, Stream<T>> function) {
        Driver driver = GraphDatabase.driver((URI)uri, (AuthToken)token, (Config)config);
        return (Stream)function.apply(driver).onClose(() -> driver.close());
    }

    private <T> Stream<T> withSession(Driver driver, SessionConfig sessionConfig, Function<Session, Stream<T>> function) {
        Session session = driver.session(sessionConfig);
        return (Stream)function.apply(session).onClose(() -> session.close());
    }

    private <T> Stream<T> withSession(Driver driver, Function<Session, Stream<T>> function) {
        Session session = driver.session();
        return (Stream)function.apply(session).onClose(() -> session.close());
    }

    private <T> Stream<T> withTransaction(Session session, Function<Transaction, Stream<T>> function) {
        Transaction transaction = session.beginTransaction();
        return (Stream)((Stream)function.apply(transaction).onClose(() -> transaction.commit())).onClose(() -> transaction.close());
    }

    @Procedure
    @Description(value="apoc.bolt.execute(url-or-key, kernelTransaction, params, config) - access to other databases via bolt for read")
    public Stream<RowResult> execute(@Name(value="url") String url, @Name(value="kernelTransaction") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        HashMap<String, Object> configuration = new HashMap<String, Object>(config);
        configuration.put("readOnly", false);
        return this.load(url, statement, params, configuration);
    }

    private RowResult buildRowResult(Record record, Map<Long, Object> nodesCache, boolean virtual) {
        return new RowResult(record.asMap(value -> {
            Object entity = value.asObject();
            if (entity instanceof Node) {
                return this.toNode(entity, virtual, nodesCache);
            }
            if (entity instanceof Relationship) {
                return this.toRelationship(entity, virtual, nodesCache);
            }
            if (entity instanceof Path) {
                return this.toPath(entity, virtual, nodesCache);
            }
            return entity;
        }));
    }

    private Stream<RowResult> getRowResultStream(boolean virtual, Session session, Map<String, Object> params, String statement) {
        HashMap nodesCache = new HashMap();
        return this.withTransaction(session, tx -> {
            ClosedAwareDelegatingIterator iterator = new ClosedAwareDelegatingIterator(tx.run(statement, params));
            return Iterators.stream(iterator).map(record -> this.buildRowResult((Record)record, nodesCache, virtual));
        });
    }

    private Object toNode(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        Value internalValue = ((InternalEntity)value).asValue();
        Node node = internalValue.asNode();
        if (virtual) {
            ArrayList labels2 = new ArrayList();
            node.labels().forEach(l -> labels2.add(Label.label((String)l)));
            VirtualNode virtualNode = new VirtualNode(node.id(), labels2.toArray(new Label[0]), node.asMap());
            nodesCache.put(node.id(), virtualNode);
            return virtualNode;
        }
        return Util.map("entityType", internalValue.type().name(), "labels", node.labels(), "id", node.id(), "properties", node.asMap());
    }

    private Object toRelationship(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        Value internalValue = ((InternalEntity)value).asValue();
        Relationship relationship = internalValue.asRelationship();
        if (virtual) {
            VirtualNode start = (VirtualNode)nodesCache.getOrDefault(relationship.startNodeId(), new VirtualNode(relationship.startNodeId()));
            VirtualNode end = (VirtualNode)nodesCache.getOrDefault(relationship.endNodeId(), new VirtualNode(relationship.endNodeId()));
            VirtualRelationship virtualRelationship = new VirtualRelationship(relationship.id(), start, end, RelationshipType.withName((String)relationship.type()), relationship.asMap());
            return virtualRelationship;
        }
        return Util.map("entityType", internalValue.type().name(), "type", relationship.type(), "id", relationship.id(), "start", relationship.startNodeId(), "end", relationship.endNodeId(), "properties", relationship.asMap());
    }

    private Object toPath(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        LinkedList entityList = new LinkedList();
        Value internalValue = ((InternalPath)value).asValue();
        internalValue.asPath().forEach(p -> {
            entityList.add(this.toNode(p.start(), virtual, nodesCache));
            entityList.add(this.toRelationship(p.relationship(), virtual, nodesCache));
            entityList.add(this.toNode(p.end(), virtual, nodesCache));
        });
        return entityList;
    }

    private Map<String, Object> toMap(SummaryCounters resultSummary) {
        return MapUtil.map("nodesCreated", resultSummary.nodesCreated(), "nodesDeleted", resultSummary.nodesDeleted(), "labelsAdded", resultSummary.labelsAdded(), "labelsRemoved", resultSummary.labelsRemoved(), "relationshipsCreated", resultSummary.relationshipsCreated(), "relationshipsDeleted", resultSummary.relationshipsDeleted(), "propertiesSet", resultSummary.propertiesSet(), "constraintsAdded", resultSummary.constraintsAdded(), "constraintsRemoved", resultSummary.constraintsRemoved(), "indexesAdded", resultSummary.indexesAdded(), "indexesRemoved", resultSummary.indexesRemoved());
    }

    private Config toDriverConfig(Object driverConfig) {
        Map driverConfMap = (Map)driverConfig;
        String logging = driverConfMap.getOrDefault("logging", "INFO");
        boolean encryption = driverConfMap.getOrDefault("encryption", false);
        boolean logLeakedSessions = driverConfMap.getOrDefault("logLeakedSessions", true);
        Long idleTimeBeforeConnectionTest = driverConfMap.getOrDefault("idleTimeBeforeConnectionTest", -1L);
        String trustStrategy = driverConfMap.getOrDefault("trustStrategy", "TRUST_ALL_CERTIFICATES");
        Long connectionTimeoutMillis = (Long)driverConfMap.get("connectionTimeoutMillis");
        Long maxRetryTimeMs = (Long)driverConfMap.get("maxRetryTimeMs");
        Long maxConnectionLifeTime = (Long)driverConfMap.get("maxConnectionLifeTime");
        Long maxConnectionPoolSize = (Long)driverConfMap.get("maxConnectionPoolSize");
        Long routingTablePurgeDelay = (Long)driverConfMap.get("routingTablePurgeDelay");
        Long connectionAcquisitionTimeout = (Long)driverConfMap.get("connectionAcquisitionTimeout");
        Config.ConfigBuilder config = Config.builder();
        config.withLogging((Logging)new JULogging(Level.parse(logging)));
        if (encryption) {
            config.withEncryption();
        }
        config.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
        if (!logLeakedSessions) {
            config.withoutEncryption();
        }
        if (connectionAcquisitionTimeout != null) {
            config.withConnectionAcquisitionTimeout(connectionAcquisitionTimeout.longValue(), TimeUnit.MILLISECONDS);
        }
        if (maxConnectionLifeTime != null) {
            config.withMaxConnectionLifetime(maxConnectionLifeTime.longValue(), TimeUnit.MILLISECONDS);
        }
        if (maxConnectionPoolSize != null) {
            config.withMaxConnectionPoolSize(maxConnectionPoolSize.intValue());
        }
        if (routingTablePurgeDelay != null) {
            config.withRoutingTablePurgeDelay(routingTablePurgeDelay.longValue(), TimeUnit.MILLISECONDS);
        }
        if (idleTimeBeforeConnectionTest != null) {
            config.withConnectionLivenessCheckTimeout(idleTimeBeforeConnectionTest.longValue(), TimeUnit.MILLISECONDS);
        }
        if (connectionTimeoutMillis != null) {
            config.withConnectionTimeout(connectionTimeoutMillis.longValue(), TimeUnit.MILLISECONDS);
        }
        if (maxRetryTimeMs != null) {
            config.withMaxTransactionRetryTime(maxRetryTimeMs.longValue(), TimeUnit.MILLISECONDS);
        }
        if (trustStrategy.equals("TRUST_ALL_CERTIFICATES")) {
            config.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
        } else if (trustStrategy.equals("TRUST_SYSTEM_CA_SIGNED_CERTIFICATES")) {
            config.withTrustStrategy(Config.TrustStrategy.trustSystemCertificates());
        } else {
            File file = new File(trustStrategy);
            config.withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File)file));
        }
        return config.build();
    }
}

