/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.auth.Authenticator;
import com.couchbase.client.java.auth.PasswordAuthenticator;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.ParameterizedN1qlQuery;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.parboiled.common.StringUtils;

public class CouchbaseConnection
implements AutoCloseable {
    private Cluster cluster;
    private Bucket bucket;
    private PasswordAuthenticator passwordAuthenticator;
    private CouchbaseEnvironment env;

    protected CouchbaseConnection(List<String> nodes, PasswordAuthenticator authenticator, String bucketName, String bucketPassword, CouchbaseEnvironment env) {
        this.env = env;
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)env, nodes);
        this.passwordAuthenticator = authenticator;
        int couchbaseServerVersion = this.getMajorVersion();
        if (couchbaseServerVersion == 4) {
            this.cluster.disconnect();
            this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)env, nodes);
            this.bucket = StringUtils.isEmpty((String)bucketPassword) ? this.cluster.openBucket(bucketName) : this.cluster.openBucket(bucketName, bucketPassword);
        }
        if (couchbaseServerVersion == 5 || couchbaseServerVersion == 6) {
            this.bucket = this.cluster.openBucket(bucketName);
        }
        if (couchbaseServerVersion < 4) {
            throw new RuntimeException("Couchbase (major) server version " + couchbaseServerVersion + " is not supported");
        }
    }

    protected int getMajorVersion() {
        return this.cluster.authenticate((Authenticator)this.passwordAuthenticator).clusterManager().info(5L, TimeUnit.SECONDS).getMinVersion().major();
    }

    @Override
    public void close() {
        this.cluster.disconnect();
        this.env.shutdown();
    }

    public JsonDocument get(String documentId) {
        return this.bucket.get(documentId);
    }

    public boolean exists(String documentId) {
        return this.bucket.exists(documentId);
    }

    public JsonDocument insert(String documentId, String json) {
        return (JsonDocument)this.bucket.insert((Document)JsonDocument.create((String)documentId, (JsonObject)JsonObject.fromJson((String)json)));
    }

    public JsonDocument upsert(String documentId, String json) {
        return (JsonDocument)this.bucket.upsert((Document)JsonDocument.create((String)documentId, (JsonObject)JsonObject.fromJson((String)json)));
    }

    public JsonDocument append(String documentId, String json) {
        this.bucket.append((Document)JsonDocument.create((String)documentId, (JsonObject)JsonObject.fromJson((String)json)));
        return this.get(documentId);
    }

    public JsonDocument prepend(String documentId, String json) {
        this.bucket.prepend((Document)JsonDocument.create((String)documentId, (JsonObject)JsonObject.fromJson((String)json)));
        return this.get(documentId);
    }

    public JsonDocument remove(String documentId) {
        return this.bucket.remove(documentId);
    }

    public JsonDocument replace(String documentId, String json) {
        return (JsonDocument)this.bucket.replace((Document)JsonDocument.create((String)documentId, (JsonObject)JsonObject.fromJson((String)json)));
    }

    public List<JsonObject> executeStatement(String statement) {
        SimpleN1qlQuery query = N1qlQuery.simple((String)statement);
        return this.executeQuery((N1qlQuery)query);
    }

    public List<JsonObject> executeParametrizedStatement(String statement, List<Object> parameters) {
        JsonArray positionalParams = JsonArray.from(parameters);
        ParameterizedN1qlQuery query = N1qlQuery.parameterized((String)statement, (JsonArray)positionalParams);
        return this.executeQuery((N1qlQuery)query);
    }

    public List<JsonObject> executeParametrizedStatement(String statement, List<String> parameterNames, List<Object> parameterValues) {
        JsonObject namedParams = JsonObject.create();
        for (int param = 0; param < parameterNames.size(); ++param) {
            namedParams.put(parameterNames.get(param), parameterValues.get(param));
        }
        ParameterizedN1qlQuery query = N1qlQuery.parameterized((String)statement, (JsonObject)namedParams);
        return this.executeQuery((N1qlQuery)query);
    }

    private List<JsonObject> executeQuery(N1qlQuery query) {
        if (this.bucket.isClosed()) {
            throw new RuntimeException("bucket has been closed before performing the query");
        }
        N1qlQueryResult queryResult = this.bucket.query(query);
        ArrayList<JsonObject> result = null;
        if (queryResult != null && queryResult.info().errorCount() == 0 && queryResult.info().resultCount() > 0) {
            result = new ArrayList<JsonObject>();
            for (N1qlQueryRow queryRow : queryResult) {
                result.add(queryRow.value());
            }
        }
        return result;
    }
}

