/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.Extended;
import apoc.custom.CypherProceduresHandler;
import apoc.custom.Signatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class CypherProcedures {
    @Context
    public GraphDatabaseAPI api;
    @Context
    public KernelTransaction ktx;
    @Context
    public Log log;
    @Context
    public CypherProceduresHandler cypherProceduresHandler;

    @Procedure(value="apoc.custom.asProcedure", mode=Mode.WRITE)
    @Description(value="apoc.custom.asProcedure(name, statement, mode, outputs, inputs, description) - register a custom cypher procedure")
    public void asProcedure(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, @Name(value="outputs", defaultValue="null") List<List<String>> outputs, @Name(value="inputs", defaultValue="null") List<List<String>> inputs, @Name(value="description", defaultValue="") String description) throws ProcedureException {
        ProcedureSignature signature = this.cypherProceduresHandler.procedureSignature(name, mode, outputs, inputs, description);
        this.cypherProceduresHandler.storeProcedure(signature, statement);
    }

    @Procedure(value="apoc.custom.declareProcedure", mode=Mode.WRITE)
    @Description(value="apoc.custom.declareProcedure(signature, statement, mode, description) - register a custom cypher procedure")
    public void declareProcedure(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, @Name(value="description", defaultValue="") String description) {
        ProcedureSignature procedureSignature = new Signatures("custom").asProcedureSignature(signature, description, this.cypherProceduresHandler.mode(mode));
        if (!this.cypherProceduresHandler.registerProcedure(procedureSignature, statement)) {
            throw new IllegalStateException("Error registering procedure " + procedureSignature.name() + ", see log.");
        }
        this.cypherProceduresHandler.storeProcedure(procedureSignature, statement);
    }

    @Procedure(value="apoc.custom.asFunction", mode=Mode.WRITE)
    @Description(value="apoc.custom.asFunction(name, statement, outputs, inputs, forceSingle, description) - register a custom cypher function")
    public void asFunction(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="outputs", defaultValue="") String output, @Name(value="inputs", defaultValue="null") List<List<String>> inputs, @Name(value="forceSingle", defaultValue="false") boolean forceSingle, @Name(value="description", defaultValue="") String description) throws ProcedureException {
        UserFunctionSignature signature = this.cypherProceduresHandler.functionSignature(name, output, inputs, description);
        this.cypherProceduresHandler.storeFunction(signature, statement, forceSingle);
    }

    @Procedure(value="apoc.custom.declareFunction", mode=Mode.WRITE)
    @Description(value="apoc.custom.declareFunction(signature, statement, forceSingle, description) - register a custom cypher function")
    public void asFunction(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="forceSingle", defaultValue="false") boolean forceSingle, @Name(value="description", defaultValue="") String description) throws ProcedureException {
        UserFunctionSignature userFunctionSignature = new Signatures("custom").asFunctionSignature(signature, description);
        if (!this.cypherProceduresHandler.registerFunction(userFunctionSignature, statement, forceSingle)) {
            throw new IllegalStateException("Error registering function " + signature + ", see log.");
        }
        this.cypherProceduresHandler.storeFunction(userFunctionSignature, statement, forceSingle);
    }

    @Procedure(value="apoc.custom.list", mode=Mode.READ)
    @Description(value="apoc.custom.list() - provide a list of custom procedures/function registered")
    public Stream<CustomProcedureInfo> list() {
        return this.cypherProceduresHandler.readSignatures().map(descriptor -> {
            if (descriptor instanceof CypherProceduresHandler.ProcedureDescriptor) {
                CypherProceduresHandler.ProcedureDescriptor procedureDescriptor = (CypherProceduresHandler.ProcedureDescriptor)descriptor;
                ProcedureSignature signature = procedureDescriptor.getSignature();
                return new CustomProcedureInfo("procedure", signature.name().name(), signature.description().orElse(null), signature.mode().toString().toLowerCase(), procedureDescriptor.getStatement(), this.convertInputSignature(signature.inputSignature()), Iterables.asList((Iterable)Iterables.map(f -> Arrays.asList(f.name(), this.prettyPrintType(f.neo4jType())), (Iterable)signature.outputSignature())), null);
            }
            CypherProceduresHandler.UserFunctionDescriptor userFunctionDescriptor = (CypherProceduresHandler.UserFunctionDescriptor)descriptor;
            UserFunctionSignature signature = userFunctionDescriptor.getSignature();
            return new CustomProcedureInfo("function", signature.name().name(), signature.description().orElse(null), null, userFunctionDescriptor.getStatement(), this.convertInputSignature(signature.inputSignature()), this.prettyPrintType(signature.outputType()), userFunctionDescriptor.isForceSingle());
        });
    }

    @Procedure(value="apoc.custom.removeProcedure", mode=Mode.WRITE)
    @Description(value="apoc.custom.removeProcedure(name) - remove the targeted custom procedure")
    public void removeProcedure(@Name(value="name") String name) {
        Objects.requireNonNull(name, "name");
        this.cypherProceduresHandler.removeProcedure(name);
    }

    @Procedure(value="apoc.custom.removeFunction", mode=Mode.WRITE)
    @Description(value="apoc.custom.removeFunction(name, type) - remove the targeted custom function")
    public void removeFunction(@Name(value="name") String name) {
        Objects.requireNonNull(name, "name");
        this.cypherProceduresHandler.removeFunction(name);
    }

    private List<List<String>> convertInputSignature(List<FieldSignature> signatures) {
        return Iterables.asList((Iterable)Iterables.map(f -> {
            ArrayList<String> list = new ArrayList<String>(3);
            list.add(f.name());
            list.add(this.prettyPrintType(f.neo4jType()));
            f.defaultValue().ifPresent(v -> list.add(v.value().toString()));
            return list;
        }, signatures));
    }

    private String prettyPrintType(Neo4jTypes.AnyType type) {
        String s = type.toString().toLowerCase();
        if (s.endsWith("?")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static class CustomProcedureInfo {
        public String type;
        public String name;
        public String description;
        public String mode;
        public String statement;
        public List<List<String>> inputs;
        public Object outputs;
        public Boolean forceSingle;

        public CustomProcedureInfo(String type, String name, String description, String mode, String statement, List<List<String>> inputs, Object outputs, Boolean forceSingle) {
            this.type = type;
            this.name = name;
            this.description = description;
            this.statement = statement;
            this.outputs = outputs;
            this.inputs = inputs;
            this.forceSingle = forceSingle;
            this.mode = mode;
        }
    }
}

