/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.Pools;
import apoc.result.MapResult;
import apoc.util.MapUtil;
import apoc.util.QueueBasedSpliterator;
import apoc.util.Util;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class Cypher {
    public static final String COMPILED_PREFIX = "CYPHER runtime=interpreted";
    public static final int PARTITIONS = 100 * Runtime.getRuntime().availableProcessors();
    public static final int MAX_BATCH = 10000;
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public Pools pools;
    private static final Pattern shellControl = Pattern.compile("^:?\\b(begin|commit|rollback)\\b", 2);

    @Procedure
    @Description(value="apoc.cypher.run(fragment, params) yield value - executes reading fragment with the given parameters - currently no schema operations")
    public Stream<MapResult> run(@Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params) {
        return Cypher.runCypherQuery(this.tx, statement, params);
    }

    public static Stream<MapResult> runCypherQuery(Transaction tx, @Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        return tx.execute(Cypher.withParamMapping(statement, params.keySet()), params).stream().map(MapResult::new);
    }

    private Stream<RowResult> runManyStatements(Reader reader, Map<String, Object> params, boolean schemaOperation, boolean addStatistics, int timeout, int queueCapacity) {
        BlockingQueue<RowResult> queue = this.runInSeparateThreadAndSendTombstone(queueCapacity, internalQueue -> {
            if (schemaOperation) {
                this.runSchemaStatementsInTx(reader, (BlockingQueue<RowResult>)internalQueue, params, addStatistics, timeout);
            } else {
                this.runDataStatementsInTx(reader, (BlockingQueue<RowResult>)internalQueue, params, addStatistics, timeout);
            }
        }, RowResult.TOMBSTONE);
        return StreamSupport.stream(new QueueBasedSpliterator<RowResult>(queue, RowResult.TOMBSTONE, this.terminationGuard, Integer.MAX_VALUE), false);
    }

    private <T> BlockingQueue<T> runInSeparateThreadAndSendTombstone(int queueCapacity, Consumer<BlockingQueue<T>> action, T tombstone) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(queueCapacity);
        new Thread(() -> {
            try {
                action.accept(queue);
            }
            finally {
                while (true) {
                    try {
                        queue.put(tombstone);
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        }).start();
        return queue;
    }

    private void runDataStatementsInTx(Reader reader, BlockingQueue<RowResult> queue, Map<String, Object> params, boolean addStatistics, long timeout) {
        Scanner scanner = new Scanner(reader);
        scanner.useDelimiter(";\r?\n");
        while (scanner.hasNext()) {
            String stmt = this.removeShellControlCommands(scanner.next());
            if (stmt.trim().isEmpty() || this.isSchemaOperation(stmt)) continue;
            if (this.isPeriodicOperation(stmt)) {
                Util.inThread(this.pools, () -> this.db.executeTransactionally(stmt, params, result -> this.consumeResult((Result)result, queue, addStatistics, timeout)));
                continue;
            }
            Util.inTx(this.db, this.pools, threadTx -> {
                try (Result result = threadTx.execute(stmt, params);){
                    Object object = this.consumeResult(result, queue, addStatistics, timeout);
                    return object;
                }
            });
        }
    }

    private void runSchemaStatementsInTx(Reader reader, BlockingQueue<RowResult> queue, Map<String, Object> params, boolean addStatistics, long timeout) {
        Scanner scanner = new Scanner(reader);
        scanner.useDelimiter(";\r?\n");
        while (scanner.hasNext()) {
            String stmt = this.removeShellControlCommands(scanner.next());
            if (stmt.trim().isEmpty() || !this.isSchemaOperation(stmt)) continue;
            Util.inTx(this.db, this.pools, txInThread -> {
                try (Result result = txInThread.execute(stmt, params);){
                    Object object = this.consumeResult(result, queue, addStatistics, timeout);
                    return object;
                }
            });
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.cypher.runMany('cypher;\\nstatements;',{params},[{statistics:true,timeout:10}]) - runs each semicolon separated statement and returns summary - currently no schema operations")
    public Stream<RowResult> runMany(@Name(value="cypher") String cypher, @Name(value="params") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean addStatistics = Util.toBoolean(config.getOrDefault("statistics", true));
        int timeout = Util.toInteger(config.getOrDefault("timeout", 1));
        int queueCapacity = Util.toInteger(config.getOrDefault("queueCapacity", 100));
        StringReader stringReader = new StringReader(cypher);
        return this.runManyStatements(stringReader, params, false, addStatistics, timeout, queueCapacity);
    }

    private Object consumeResult(Result result, BlockingQueue<RowResult> queue, boolean addStatistics, long timeout) {
        try {
            long time = System.currentTimeMillis();
            int row = 0;
            while (result.hasNext()) {
                this.terminationGuard.check();
                queue.put(new RowResult(row++, result.next()));
            }
            if (addStatistics) {
                queue.put(new RowResult(-1L, this.toMap(result.getQueryStatistics(), System.currentTimeMillis() - time, row)));
            }
            return row;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String removeShellControlCommands(String stmt) {
        Matcher matcher = shellControl.matcher(stmt.trim());
        if (matcher.find()) {
            return this.removeShellControlCommands(matcher.replaceAll(""));
        }
        return stmt;
    }

    private boolean isSchemaOperation(String stmt) {
        return stmt.matches("(?is).*(create|drop)\\s+(index|constraint).*");
    }

    private boolean isPeriodicOperation(String stmt) {
        return stmt.matches("(?is).*using\\s+periodic.*");
    }

    private Map<String, Object> toMap(QueryStatistics stats, long time, long rows) {
        return MapUtil.map("rows", rows, "time", time, "nodesCreated", stats.getNodesCreated(), "nodesDeleted", stats.getNodesDeleted(), "labelsAdded", stats.getLabelsAdded(), "labelsRemoved", stats.getLabelsRemoved(), "relationshipsCreated", stats.getRelationshipsCreated(), "relationshipsDeleted", stats.getRelationshipsDeleted(), "propertiesSet", stats.getPropertiesSet(), "constraintsAdded", stats.getConstraintsAdded(), "constraintsRemoved", stats.getConstraintsRemoved(), "indexesAdded", stats.getIndexesAdded(), "indexesRemoved", stats.getIndexesRemoved());
    }

    public static String withParamMapping(String fragment, Collection<String> keys) {
        if (keys.isEmpty()) {
            return fragment;
        }
        String declaration = " WITH " + String.join((CharSequence)", ", keys.stream().map(s -> String.format(" $`%s` as `%s` ", s, s)).collect(Collectors.toList()));
        return declaration + fragment;
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.cypher.doIt(fragment, params) yield value - executes writing fragment with the given parameters")
    public Stream<MapResult> doIt(@Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params) {
        return Cypher.runCypherQuery(this.tx, statement, params);
    }

    @Procedure(value="apoc.when")
    @Description(value="apoc.when(condition, ifQuery, elseQuery:'', params:{}) yield value - based on the conditional, executes read-only ifQuery or elseQuery with the given parameters")
    public Stream<MapResult> when(@Name(value="condition") boolean condition, @Name(value="ifQuery") String ifQuery, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        String targetQuery;
        if (params == null) {
            params = Collections.emptyMap();
        }
        String string = targetQuery = condition ? ifQuery : elseQuery;
        if (targetQuery.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        return this.tx.execute(Cypher.withParamMapping(targetQuery, params.keySet()), params).stream().map(MapResult::new);
    }

    @Procedure(value="apoc.do.when", mode=Mode.WRITE)
    @Description(value="apoc.do.when(condition, ifQuery, elseQuery:'', params:{}) yield value - based on the conditional, executes writing ifQuery or elseQuery with the given parameters")
    public Stream<MapResult> doWhen(@Name(value="condition") boolean condition, @Name(value="ifQuery") String ifQuery, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        return this.when(condition, ifQuery, elseQuery, params);
    }

    @Procedure(value="apoc.case")
    @Description(value="apoc.case([condition, query, condition, query, ...], elseQuery:'', params:{}) yield value - given a list of conditional / read-only query pairs, executes the query associated with the first conditional evaluating to true (or the else query if none are true) with the given parameters")
    public Stream<MapResult> whenCase(@Name(value="conditionals") List<Object> conditionals, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (conditionals.size() % 2 != 0) {
            throw new IllegalArgumentException("Conditionals must be an even-sized collection of boolean, query entries");
        }
        Iterator<Object> caseItr = conditionals.iterator();
        while (caseItr.hasNext()) {
            boolean condition = (Boolean)caseItr.next();
            String ifQuery = (String)caseItr.next();
            if (!condition) continue;
            return this.tx.execute(Cypher.withParamMapping(ifQuery, params.keySet()), params).stream().map(MapResult::new);
        }
        if (elseQuery.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        return this.tx.execute(Cypher.withParamMapping(elseQuery, params.keySet()), params).stream().map(MapResult::new);
    }

    @Procedure(value="apoc.do.case", mode=Mode.WRITE)
    @Description(value="apoc.do.case([condition, query, condition, query, ...], elseQuery:'', params:{}) yield value - given a list of conditional / writing query pairs, executes the query associated with the first conditional evaluating to true (or the else query if none are true) with the given parameters")
    public Stream<MapResult> doWhenCase(@Name(value="conditionals") List<Object> conditionals, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        return this.whenCase(conditionals, elseQuery, params);
    }

    public static class RowResult {
        public static final RowResult TOMBSTONE = new RowResult(-1L, null);
        public long row;
        public Map<String, Object> result;

        public RowResult(long row, Map<String, Object> result) {
            this.row = row;
            this.result = result;
        }
    }
}

