/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.cypher.Cypher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class CypherFunctions {
    @Context
    public Transaction tx;

    @UserFunction
    @Deprecated
    @Description(value="use either apoc.cypher.runFirstColumnMany for a list return or apoc.cypher.runFirstColumnSingle for returning the first row of the first column")
    public Object runFirstColumn(@Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params, @Name(value="expectMultipleValues", defaultValue="true") boolean expectMultipleValues) {
        Object resolvedStatement;
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (!((String)(resolvedStatement = Cypher.withParamMapping(statement, params.keySet()))).contains(" runtime")) {
            resolvedStatement = "cypher runtime=slotted " + (String)resolvedStatement;
        }
        try (Result result = this.tx.execute((String)resolvedStatement, params);){
            Object object;
            block18: {
                ResourceIterator iter;
                block16: {
                    List list;
                    block17: {
                        String firstColumn = (String)result.columns().get(0);
                        iter = result.columnAs(firstColumn);
                        try {
                            if (!expectMultipleValues) break block16;
                            list = iter.stream().collect(Collectors.toList());
                            if (iter == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (iter != null) {
                                try {
                                    iter.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        iter.close();
                    }
                    return list;
                }
                Object object2 = object = iter.hasNext() ? iter.next() : null;
                if (iter == null) break block18;
                iter.close();
            }
            return object;
        }
    }

    @UserFunction
    @Description(value="apoc.cypher.runFirstColumnMany(statement, params) - executes statement with given parameters, returns first column only collected into a list, params are available as identifiers")
    public List<Object> runFirstColumnMany(@Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params) {
        return (List)this.runFirstColumn(statement, params, true);
    }

    @UserFunction
    @Description(value="apoc.cypher.runFirstColumnSingle(statement, params) - executes statement with given parameters, returns first element of the first column only, params are available as identifiers")
    public Object runFirstColumnSingle(@Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params) {
        return this.runFirstColumn(statement, params, false);
    }
}

