/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.ApocConfig;
import apoc.util.Util;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.configuration2.Configuration;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public class CypherInitializer
implements AvailabilityListener {
    private final GraphDatabaseAPI db;
    private final Log userLog;
    private final GlobalProcedures procs;
    private final DependencyResolver dependencyResolver;
    private boolean finished = false;

    public CypherInitializer(GraphDatabaseAPI db, Log userLog) {
        this.db = db;
        this.userLog = userLog;
        this.dependencyResolver = db.getDependencyResolver();
        this.procs = (GlobalProcedures)this.dependencyResolver.resolveDependency(GlobalProcedures.class);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public GraphDatabaseAPI getDb() {
        return this.db;
    }

    public void available() {
        Util.newDaemonThread(() -> {
            try {
                boolean isSystemDatabase = this.db.databaseName().equals("system");
                if (!isSystemDatabase) {
                    this.awaitApocProceduresRegistered();
                }
                Configuration config = ((ApocConfig)((Object)((Object)this.dependencyResolver.resolveDependency(ApocConfig.class)))).getConfig();
                for (String query : this.collectInitializers(isSystemDatabase, config)) {
                    try {
                        Util.retryInTx(this.userLog, (GraphDatabaseService)this.db, tx -> Iterators.count((Iterator)tx.execute(query)), 0L, 5L, retries -> {});
                        this.userLog.info("successfully initialized: " + query);
                    }
                    catch (Exception e) {
                        this.userLog.error("error upon initialization, running: " + query, (Throwable)e);
                    }
                }
            }
            finally {
                this.finished = true;
            }
        }).start();
    }

    private Collection<String> collectInitializers(boolean isSystemDatabase, Configuration config) {
        TreeMap initializers = new TreeMap();
        config.getKeys("apoc.initializer." + this.db.databaseName()).forEachRemaining(key -> this.putIfNotBlank(initializers, (String)key, config.getString(key)));
        if (!isSystemDatabase) {
            config.getKeys("apoc.initializer.cypher").forEachRemaining(key -> initializers.put(key, config.getString(key)));
        }
        return initializers.values();
    }

    private void putIfNotBlank(Map<String, String> map, String key, String value) {
        if (value != null && !value.isBlank()) {
            map.put(key, value);
        }
    }

    private void awaitApocProceduresRegistered() {
        while (!this.areApocProceduresRegistered()) {
            Util.sleep(100);
        }
    }

    private boolean areApocProceduresRegistered() {
        try {
            return this.procs.getAllProcedures().stream().anyMatch(signature -> signature.name().toString().startsWith("apoc"));
        }
        catch (ConcurrentModificationException e) {
            return false;
        }
    }

    public void unavailable() {
    }
}

