/*
 * Decompiled with CFR 0.152.
 */
package apoc.diff;

import apoc.Description;
import apoc.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Diff {
    @Context
    public Transaction tx;

    @UserFunction
    @Description(value="apoc.diff.nodes([leftNode],[rightNode]) returns a detailed diff of both nodes")
    public Map<String, Object> nodes(@Name(value="leftNode") Node leftNode, @Name(value="rightNode") Node rightNode) {
        leftNode = Util.rebind(this.tx, leftNode);
        rightNode = Util.rebind(this.tx, rightNode);
        Map allLeftProperties = leftNode.getAllProperties();
        Map allRightProperties = rightNode.getAllProperties();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("leftOnly", this.getPropertiesOnlyLeft(allLeftProperties, allRightProperties));
        result.put("rightOnly", this.getPropertiesOnlyLeft(allRightProperties, allLeftProperties));
        result.put("inCommon", this.getPropertiesInCommon(allLeftProperties, allRightProperties));
        result.put("different", this.getPropertiesDiffering(allLeftProperties, allRightProperties));
        return result;
    }

    private Map<String, Object> getPropertiesOnlyLeft(Map<String, Object> left, Map<String, Object> right) {
        HashMap<String, Object> leftOnly = new HashMap<String, Object>();
        leftOnly.putAll(left);
        leftOnly.keySet().removeAll(right.keySet());
        return leftOnly;
    }

    private Map<String, Object> getPropertiesInCommon(Map<String, Object> left, Map<String, Object> right) {
        HashMap<String, Object> inCommon = new HashMap<String, Object>(left);
        inCommon.entrySet().retainAll(right.entrySet());
        return inCommon;
    }

    private Map<String, Map<String, Object>> getPropertiesDiffering(Map<String, Object> left, Map<String, Object> right) {
        HashMap<String, Map<String, Object>> different = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> keyPairs = new HashMap<String, Object>();
        keyPairs.putAll(left);
        keyPairs.keySet().retainAll(right.keySet());
        for (Map.Entry entry : keyPairs.entrySet()) {
            if (left.get(entry.getKey()).equals(right.get(entry.getKey()))) continue;
            HashMap<String, Object> pairs = new HashMap<String, Object>();
            pairs.put("left", left.get(entry.getKey()));
            pairs.put("right", right.get(entry.getKey()));
            different.put((String)entry.getKey(), pairs);
        }
        return different;
    }
}

