/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.csv.CsvLoaderConstants;
import apoc.meta.Meta;
import java.util.regex.Matcher;

public class CsvHeaderField {
    private final int index;
    private final String name;
    private final String type;
    private final boolean array;
    private final String idSpace;

    private CsvHeaderField(int index, String name, String type, boolean array, String idSpace) {
        this.index = index;
        this.name = name;
        this.type = type;
        this.array = array;
        this.idSpace = idSpace;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isArray() {
        return this.array;
    }

    public String getIdSpace() {
        return this.idSpace;
    }

    public boolean isId() {
        return "ID".equals(this.type) || "START_ID".equals(this.type) || "END_ID".equals(this.type);
    }

    public boolean isMeta() {
        return "LABEL".equals(this.type) || "TYPE".equals(this.type);
    }

    public boolean isIgnore() {
        return "IGNORE".equals(this.type);
    }

    public static CsvHeaderField parse(int index, String attribute, char quotationCharacter) {
        String attributeCleaned = attribute.replaceAll(String.valueOf(quotationCharacter), "");
        Matcher matcher = CsvLoaderConstants.FIELD_PATTERN.matcher(attributeCleaned);
        matcher.find();
        String rawName = CsvHeaderField.extractGroup(matcher, "name");
        String typeExtracted = CsvHeaderField.extractGroup(matcher, "type");
        String type = typeExtracted != null ? typeExtracted : Meta.Types.STRING.name();
        String name = CsvHeaderField.nameAndTypeToAttribute(rawName, type);
        String idSpaceExtracted = CsvHeaderField.extractGroup(matcher, "idspace");
        String idSpace = idSpaceExtracted != null ? idSpaceExtracted : "__CSV_DEFAULT_IDSPACE";
        boolean array = "[]".equals(CsvHeaderField.extractGroup(matcher, "array")) || "LABEL".equals(type);
        return new CsvHeaderField(index, name, type, array, idSpace);
    }

    private static String nameAndTypeToAttribute(String name, String type) {
        switch (type) {
            case "ID": {
                if (name.isEmpty()) {
                    return CsvLoaderConstants.ID_ATTR;
                }
                return name;
            }
            case "START_ID": {
                return CsvLoaderConstants.START_ID_ATTR;
            }
            case "END_ID": {
                return CsvLoaderConstants.END_ID_ATTR;
            }
            case "LABEL": {
                return CsvLoaderConstants.LABEL_ATTR;
            }
            case "TYPE": {
                return CsvLoaderConstants.TYPE_ATTR;
            }
        }
        return name;
    }

    private static String extractGroup(Matcher matcher, String groupName) {
        try {
            return matcher.group(groupName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

