/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.graphml;

import apoc.export.util.BatchTransaction;
import apoc.export.util.Reporter;
import apoc.util.JsonUtil;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

public class XmlGraphMLReader {
    public static final String LABEL_SPLIT = " *: *";
    private final GraphDatabaseService db;
    private final Transaction tx;
    private boolean storeNodeIds;
    private RelationshipType defaultRelType = RelationshipType.withName((String)"UNKNOWN");
    private int batchSize = 40000;
    private Reporter reporter;
    private boolean labels;
    public static final QName ID = QName.valueOf("id");
    public static final QName LABELS = QName.valueOf("labels");
    public static final QName SOURCE = QName.valueOf("source");
    public static final QName TARGET = QName.valueOf("target");
    public static final QName LABEL = QName.valueOf("label");
    public static final QName FOR = QName.valueOf("for");
    public static final QName NAME = QName.valueOf("attr.name");
    public static final QName TYPE = QName.valueOf("attr.type");
    public static final QName LIST = QName.valueOf("attr.list");
    public static final QName KEY = QName.valueOf("key");

    public XmlGraphMLReader storeNodeIds() {
        this.storeNodeIds = true;
        return this;
    }

    public XmlGraphMLReader relType(String name) {
        this.defaultRelType = RelationshipType.withName((String)name);
        return this;
    }

    public XmlGraphMLReader batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public XmlGraphMLReader nodeLabels(boolean readLabels) {
        this.labels = readLabels;
        return this;
    }

    public XmlGraphMLReader reporter(Reporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public XmlGraphMLReader(GraphDatabaseService db, Transaction tx) {
        this.db = db;
        this.tx = tx;
    }

    public long parseXML(Reader input) throws XMLStreamException {
        HashMap<String, Long> cache = new HashMap<String, Long>(32768);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        XMLEventReader reader = inputFactory.createXMLEventReader(input);
        Node last = null;
        HashMap<String, Key> nodeKeys = new HashMap<String, Key>();
        HashMap<String, Key> relKeys = new HashMap<String, Key>();
        int count = 0;
        try (BatchTransaction tx = new BatchTransaction(this.db, this.batchSize * 10, this.reporter);){
            while (reader.hasNext()) {
                String id;
                StartElement element;
                String name;
                XMLEvent event = (XMLEvent)reader.next();
                if (!event.isStartElement() || (name = (element = event.asStartElement()).getName().getLocalPart()).equals("graphml") || name.equals("graph")) continue;
                if (name.equals("key")) {
                    id = this.getAttribute(element, ID);
                    Key key = new Key(id, this.getAttribute(element, NAME), this.getAttribute(element, TYPE), this.getAttribute(element, LIST), this.getAttribute(element, FOR));
                    XMLEvent next = this.peek(reader);
                    if (next.isStartElement() && next.asStartElement().getName().getLocalPart().equals("default")) {
                        reader.nextEvent().asStartElement();
                        key.setDefault(reader.nextEvent().asCharacters().getData());
                    }
                    if (key.forNode) {
                        nodeKeys.put(id, key);
                        continue;
                    }
                    relKeys.put(id, key);
                    continue;
                }
                if (name.equals("data")) {
                    Key key;
                    if (last == null) continue;
                    id = this.getAttribute(element, KEY);
                    boolean isNode = last instanceof Node;
                    Key key2 = key = isNode ? (Key)nodeKeys.get(id) : (Key)relKeys.get(id);
                    if (key == null) {
                        key = Key.defaultKey(id, isNode);
                    }
                    Object value = key.defaultValue;
                    XMLEvent next = this.peek(reader);
                    if (next.isCharacters()) {
                        value = key.parseValue(reader.nextEvent().asCharacters().getData());
                    }
                    if (value != null) {
                        if (this.labels && isNode && id.equals("labels")) {
                            this.addLabels(last, value.toString());
                            continue;
                        }
                        if (this.labels && !isNode && id.equals("label")) continue;
                        last.setProperty(key.name, value);
                        if (this.reporter == null) continue;
                        this.reporter.update(0L, 0L, 1L);
                        continue;
                    }
                    if (next.getEventType() != 2) continue;
                    last.setProperty(key.name, (Object)"");
                    this.reporter.update(0L, 0L, 1L);
                    continue;
                }
                if (name.equals("node")) {
                    tx.increment();
                    id = this.getAttribute(element, ID);
                    Node node = this.tx.createNode();
                    if (this.labels) {
                        String labels2 = this.getAttribute(element, LABELS);
                        this.addLabels(node, labels2);
                    }
                    if (this.storeNodeIds) {
                        node.setProperty("id", (Object)id);
                    }
                    this.setDefaults(nodeKeys, (Entity)node);
                    last = node;
                    cache.put(id, node.getId());
                    if (this.reporter != null) {
                        this.reporter.update(1L, 0L, 0L);
                    }
                    ++count;
                    continue;
                }
                if (!name.equals("edge")) continue;
                tx.increment();
                String source = this.getAttribute(element, SOURCE);
                String target = this.getAttribute(element, TARGET);
                String label = this.getAttribute(element, LABEL);
                Node from = this.tx.getNodeById(((Long)cache.get(source)).longValue());
                Node to = this.tx.getNodeById(((Long)cache.get(target)).longValue());
                RelationshipType relationshipType = label == null ? this.getRelationshipType(reader) : RelationshipType.withName((String)label);
                Relationship relationship = from.createRelationshipTo(to, relationshipType);
                this.setDefaults(relKeys, (Entity)relationship);
                last = relationship;
                if (this.reporter != null) {
                    this.reporter.update(0L, 1L, 0L);
                }
                ++count;
            }
        }
        return count;
    }

    private RelationshipType getRelationshipType(XMLEventReader reader) throws XMLStreamException {
        if (this.labels) {
            boolean notStartElementOrContainsKeyLabel;
            XMLEvent peek = reader.peek();
            boolean isChar = peek.isCharacters();
            if (isChar && !peek.asCharacters().isWhiteSpace()) {
                String el;
                String value = peek.asCharacters().getData();
                String typeRel = value.contains(el = ":") ? value.replace(el, "") : value;
                return RelationshipType.withName((String)typeRel.trim());
            }
            boolean bl = notStartElementOrContainsKeyLabel = isChar || !peek.isStartElement() || this.containsLabelKey(peek);
            if (!peek.isEndDocument() && notStartElementOrContainsKeyLabel) {
                reader.nextEvent();
                return this.getRelationshipType(reader);
            }
        }
        reader.nextEvent();
        return this.defaultRelType;
    }

    private boolean containsLabelKey(XMLEvent peek) {
        Attribute keyAttribute = peek.asStartElement().getAttributeByName(new QName("key"));
        return keyAttribute != null && keyAttribute.getValue().equals("label");
    }

    private void addLabels(Node node, String labels2) {
        String[] parts;
        if (labels2 == null) {
            return;
        }
        if ((labels2 = labels2.trim()).isEmpty()) {
            return;
        }
        for (String part : parts = labels2.split(LABEL_SPLIT)) {
            if (part.trim().isEmpty()) continue;
            node.addLabel(Label.label((String)part.trim()));
        }
    }

    private XMLEvent peek(XMLEventReader reader) throws XMLStreamException {
        XMLEvent peek = reader.peek();
        if (peek.isCharacters() && peek.asCharacters().isWhiteSpace()) {
            reader.nextEvent();
            return this.peek(reader);
        }
        return peek;
    }

    private void setDefaults(Map<String, Key> keys, Entity pc) {
        if (keys.isEmpty()) {
            return;
        }
        for (Key key : keys.values()) {
            if (key.defaultValue == null) continue;
            pc.setProperty(key.name, key.defaultValue);
        }
    }

    private String getAttribute(StartElement element, QName qname) {
        Attribute attribute = element.getAttributeByName(qname);
        return attribute != null ? attribute.getValue() : null;
    }

    static class Key {
        String id;
        String name;
        boolean forNode;
        Type listType;
        Type type;
        Object defaultValue;

        public Key(String id, String name, String type, String listType, String forNode) {
            this.id = id;
            this.name = name;
            this.type = Type.forType(type);
            if (listType != null) {
                this.listType = Type.forType(listType);
            }
            this.forNode = forNode == null || forNode.equalsIgnoreCase("node");
        }

        private static Key defaultKey(String id, boolean forNode) {
            return new Key(id, id, "string", null, forNode ? "node" : "edge");
        }

        public void setDefault(String data) {
            this.defaultValue = this.type.parse(data);
        }

        public Object parseValue(String input) {
            if (input == null || input.trim().isEmpty()) {
                return this.defaultValue;
            }
            if (this.listType != null) {
                return this.listType.parseList(input);
            }
            return this.type.parse(input);
        }
    }

    static enum Type {
        BOOLEAN{

            @Override
            Object parse(String value) {
                return Boolean.valueOf(value);
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Boolean.class, i -> (Boolean)i);
            }
        }
        ,
        INT{

            @Override
            Object parse(String value) {
                return Integer.parseInt(value);
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Integer.class, n -> ((Number)n).intValue());
            }
        }
        ,
        LONG{

            @Override
            Object parse(String value) {
                return Long.parseLong(value);
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Long.class, i -> ((Number)i).longValue());
            }
        }
        ,
        FLOAT{

            @Override
            Object parse(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Float.class, i -> Float.valueOf(((Number)i).floatValue()));
            }
        }
        ,
        DOUBLE{

            @Override
            Object parse(String value) {
                return Double.parseDouble(value);
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, Double.class, i -> ((Number)i).doubleValue());
            }
        }
        ,
        STRING{

            @Override
            Object parse(String value) {
                return value;
            }

            @Override
            Object parseList(String value) {
                return Type.parseList(value, String.class, i -> (String)i);
            }
        };


        abstract Object parse(String var1);

        abstract Object parseList(String var1);

        public static <T> T[] parseList(String value, Class<T> asClass, Function<Object, T> convert) {
            List parsed = JsonUtil.parse(value, null, List.class);
            Object[] converted = (Object[])Array.newInstance(asClass, parsed.size());
            for (int i = 0; i < parsed.size(); ++i) {
                converted[i] = convert.apply(parsed.get(i));
            }
            return converted;
        }

        public static Type forType(String type) {
            if (type == null) {
                return STRING;
            }
            return Type.valueOf(type.trim().toUpperCase());
        }
    }
}

