/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.json;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.FileManagerFactory;
import apoc.export.json.JsonFormat;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportUtils;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportJson {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public ApocConfig apocConfig;
    @Context
    public Pools pools;
    @Context
    public TerminationGuard terminationGuard;

    public ExportJson(GraphDatabaseService db) {
        this.db = db;
    }

    public ExportJson() {
    }

    @Procedure
    @Description(value="apoc.export.json.all(file,config) - exports whole database as json to the provided file")
    public Stream<ProgressInfo> all(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportJson(fileName, source, new DatabaseSubGraph(this.tx), config);
    }

    @Procedure
    @Description(value="apoc.export.json.data(nodes,rels,file,config) - exports given nodes and relationships as json to the provided file")
    public Stream<ProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportJson(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.json.graph(graph,file,config) - exports given graph object as json to the provided file")
    public Stream<ProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportJson(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.json.query(query,file,{config,...,params:{params}}) - exports results from the cypher statement as json to the provided file")
    public Stream<ProgressInfo> query(@Name(value="query") String query, @Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        String source = String.format("statement: cols(%d)", result.columns().size());
        return this.exportJson(fileName, source, result, config);
    }

    private Stream<ProgressInfo> exportJson(String fileName, String source, Object data, Map<String, Object> config) throws Exception {
        ExportConfig exportConfig = new ExportConfig(config);
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            this.apocConfig.checkWriteAllowed(exportConfig);
        }
        String format = "json";
        ProgressReporter reporter = new ProgressReporter(null, null, new ProgressInfo(fileName, source, "json"));
        JsonFormat exporter = new JsonFormat(this.db, this.getJsonFormat(config));
        ExportFileManager cypherFileManager = FileManagerFactory.createFileManager(fileName, false);
        if (exportConfig.streamStatements()) {
            return ExportUtils.getProgressInfoStream(this.db, this.pools.getDefaultExecutorService(), this.terminationGuard, "json", exportConfig, reporter, cypherFileManager, reporterWithConsumer -> this.dump(data, exportConfig, (ProgressReporter)reporterWithConsumer, exporter, cypherFileManager));
        }
        this.dump(data, exportConfig, reporter, exporter, cypherFileManager);
        return reporter.stream();
    }

    private JsonFormat.Format getJsonFormat(Map<String, Object> config) {
        if (config == null) {
            return JsonFormat.Format.JSON_LINES;
        }
        String jsonFormat = config.getOrDefault("jsonFormat", JsonFormat.Format.JSON_LINES.toString()).toString().toUpperCase();
        return JsonFormat.Format.valueOf(jsonFormat);
    }

    private void dump(Object data, ExportConfig c, ProgressReporter reporter, JsonFormat exporter, ExportFileManager cypherFileManager) {
        try {
            if (data instanceof SubGraph) {
                exporter.dump((SubGraph)data, cypherFileManager, (Reporter)reporter, c);
            }
            if (data instanceof Result) {
                exporter.dump((Result)data, cypherFileManager, (Reporter)reporter, c);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

