/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.ExportConfig;
import apoc.export.util.FormatUtils;
import apoc.gephi.GephiFormatUtils;
import apoc.meta.Meta;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class MetaInformation {
    public static final Set<String> GRAPHML_ALLOWED = new HashSet<String>(Arrays.asList("boolean", "int", "long", "float", "double", "string"));

    public static Map<String, Class> collectPropTypesForNodes(SubGraph graph) {
        LinkedHashMap<String, Class> propTypes = new LinkedHashMap<String, Class>();
        for (Node node : graph.getNodes()) {
            MetaInformation.updateKeyTypes(propTypes, (Entity)node);
        }
        return propTypes;
    }

    public static Map<String, Class> collectPropTypesForRelationships(SubGraph graph) {
        LinkedHashMap<String, Class> propTypes = new LinkedHashMap<String, Class>();
        for (Relationship node : graph.getRelationships()) {
            MetaInformation.updateKeyTypes(propTypes, (Entity)node);
        }
        return propTypes;
    }

    public static void updateKeyTypes(Map<String, Class> keyTypes, Entity pc) {
        for (String prop : pc.getPropertyKeys()) {
            Object value = pc.getProperty(prop);
            Class storedClass = keyTypes.get(prop);
            if (storedClass == null) {
                keyTypes.put(prop, value.getClass());
                continue;
            }
            if (storedClass == Void.TYPE || storedClass.equals(value.getClass())) continue;
            keyTypes.put(prop, Void.TYPE);
        }
    }

    public static String typeFor(Class value, Set<String> allowed) {
        if (value == Void.TYPE) {
            return null;
        }
        Meta.Types type = Meta.Types.of(value);
        String name = (value.isArray() ? value.getComponentType() : value).getSimpleName().toLowerCase();
        boolean isAllowed = allowed != null && allowed.contains(name);
        switch (type) {
            case NULL: {
                return null;
            }
            case INTEGER: 
            case FLOAT: {
                return "integer".equals(name) || !isAllowed ? "int" : name;
            }
        }
        return isAllowed ? name : "string";
    }

    public static String getLabelsString(Node node) {
        if (!node.getLabels().iterator().hasNext()) {
            return "";
        }
        String delimiter = ":";
        return delimiter + FormatUtils.joinLabels(node, delimiter);
    }

    public static String getLabelsStringGephi(ExportConfig config, Node node) {
        return GephiFormatUtils.getCaption(node, config.getCaption());
    }
}

