/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;

public class NodesAndRelsSubGraph
implements SubGraph {
    private final Collection<Node> nodes;
    private final Collection<Relationship> rels;
    private final Transaction tx;
    private final HashSet<String> labels = new HashSet(20);

    public NodesAndRelsSubGraph(Transaction tx, Collection<Node> nodes, Collection<Relationship> rels) {
        this.tx = tx;
        this.nodes = new ArrayList<Node>(nodes.size());
        for (Node node : nodes) {
            for (Label label : node.getLabels()) {
                this.labels.add(label.name());
            }
            this.nodes.add(node);
        }
        this.rels = new HashSet<Relationship>(rels);
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.rels;
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.rels.contains(relationship);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        Schema schema = this.tx.schema();
        ArrayList<IndexDefinition> indexes = new ArrayList<IndexDefinition>(this.labels.size() * 2);
        for (String label : this.labels) {
            Iterables.addAll(indexes, (Iterable)schema.getIndexes(Label.label((String)label)));
        }
        return indexes;
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        Schema schema = this.tx.schema();
        ArrayList<ConstraintDefinition> constraints = new ArrayList<ConstraintDefinition>(this.labels.size() * 2);
        for (String label : this.labels) {
            Iterables.addAll(constraints, (Iterable)schema.getConstraints(Label.label((String)label)));
        }
        return constraints;
    }
}

