/*
 * Decompiled with CFR 0.152.
 */
package apoc.hashing;

import apoc.hashing.FingerprintingConfig;
import apoc.util.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Fingerprinting {
    @Context
    public Transaction tx;
    @Context
    public Log log;

    @UserFunction
    @Description(value="calculate a checksum (md5) over a node or a relationship. This deals gracefully with array properties. Two identical entities do share the same hash.")
    public String fingerprint(@Name(value="some object") Object thing, @Name(value="propertyExcludes", defaultValue="[]") List<String> excludedPropertyKeys) {
        FingerprintingConfig config = new FingerprintingConfig(Util.map("allNodesDisallowList", excludedPropertyKeys, "allRelsDisallowList", excludedPropertyKeys, "mapDisallowList", excludedPropertyKeys, "strategy", FingerprintingConfig.FingerprintStrategy.EAGER.toString()));
        return this.fingerprint(thing, config);
    }

    @UserFunction
    @Description(value="calculate a checksum (md5) over a node or a relationship. This deals gracefully with array properties. Two identical entities do share the same hash.")
    public String fingerprinting(@Name(value="some object") Object thing, @Name(value="conf", defaultValue="{}") Map<String, Object> conf) {
        FingerprintingConfig config = new FingerprintingConfig(conf);
        return this.fingerprint(thing, config);
    }

    private String fingerprint(Object thing, FingerprintingConfig config) {
        return this.withMessageDigest(config, md -> this.fingerprint((DiagnosingMessageDigestDecorator)md, thing, config));
    }

    private void fingerprint(DiagnosingMessageDigestDecorator md, Object thing, FingerprintingConfig conf) {
        if (thing instanceof Node) {
            this.fingerprintNode(md, (Node)thing, conf);
        } else if (thing instanceof Relationship) {
            this.fingerprintRelationship(md, (Relationship)thing, conf);
        } else if (thing instanceof Path) {
            this.fingerprintPath(md, (Path)thing, conf);
        } else if (thing instanceof Map) {
            this.fingerprintMap(md, conf, (Map)thing);
        } else if (thing instanceof List) {
            this.fingerprintList(md, conf, (List)thing);
        } else {
            md.update(this.convertValueToString(thing).getBytes());
        }
    }

    private void fingerprintList(DiagnosingMessageDigestDecorator md, FingerprintingConfig conf, List list) {
        list.stream().forEach(o -> this.fingerprint(md, o, conf));
    }

    private void fingerprintPath(DiagnosingMessageDigestDecorator md, Path thing, FingerprintingConfig conf) {
        StreamSupport.stream(thing.nodes().spliterator(), false).forEach(o -> this.fingerprint(md, o, conf));
        StreamSupport.stream(thing.relationships().spliterator(), false).forEach(o -> this.fingerprint(md, o, conf));
    }

    private void fingerprintMap(DiagnosingMessageDigestDecorator md, FingerprintingConfig conf, Map<String, Object> map) {
        map.entrySet().stream().filter(e -> {
            if (!conf.getMapAllowList().isEmpty()) {
                return conf.getMapAllowList().contains(e.getKey());
            }
            return !conf.getMapDisallowList().contains(e.getKey());
        }).sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            md.update(((String)entry.getKey()).getBytes());
            md.update(this.fingerprint(entry.getValue(), conf).getBytes());
        });
    }

    @UserFunction
    @Description(value="calculate a checksum (md5) over a the full graph. Be aware that this function does use in-memomry datastructures depending on the size of your graph.")
    public String fingerprintGraph(@Name(value="propertyExcludes", defaultValue="[]") List<String> excludedPropertyKeys) {
        FingerprintingConfig config = new FingerprintingConfig(Util.map("allNodesDisallowList", excludedPropertyKeys, "allRelsDisallowList", excludedPropertyKeys, "mapDisallowList", excludedPropertyKeys, "strategy", FingerprintingConfig.FingerprintStrategy.EAGER.toString()));
        return this.withMessageDigest(config, messageDigest -> {
            Map idToNodeHash = this.tx.getAllNodes().stream().collect(Collectors.toMap(Entity::getId, node -> this.fingerprint(node, config), (aLong, aLong2) -> {
                throw new RuntimeException();
            }, () -> new TreeMap()));
            Map nodeHashToId = idToNodeHash.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (o, o2) -> {
                throw new RuntimeException();
            }, () -> new TreeMap()));
            nodeHashToId.entrySet().stream().forEach(entry -> {
                messageDigest.update(((String)entry.getKey()).getBytes());
                Node node = this.tx.getNodeById(((Long)entry.getValue()).longValue());
                List endNodeRelationshipHashTuples = StreamSupport.stream(node.getRelationships(Direction.OUTGOING).spliterator(), false).map(relationship -> {
                    String endNodeHash = (String)idToNodeHash.get(relationship.getEndNodeId());
                    String relationshipHash = this.fingerprint(relationship, excludedPropertyKeys);
                    return new EndNodeRelationshipHashTuple(endNodeHash, relationshipHash);
                }).collect(Collectors.toList());
                endNodeRelationshipHashTuples.stream().sorted().forEach(endNodeRelationshipHashTuple -> {
                    messageDigest.update(endNodeRelationshipHashTuple.getEndNodeHash().getBytes());
                    messageDigest.update(endNodeRelationshipHashTuple.getRelationshipHash().getBytes());
                });
            });
        });
    }

    private void fingerprintNode(DiagnosingMessageDigestDecorator md, Node node, FingerprintingConfig config) {
        switch (config.getStrategy()) {
            case EAGER: {
                StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).sorted().map(String::getBytes).forEach(md::update);
                break;
            }
            case LAZY: {
                StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).filter(name -> config.getAllLabels().contains(name)).sorted().map(String::getBytes).forEach(md::update);
            }
        }
        ArrayList<String> keysToRetain = new ArrayList<String>(config.getAllNodesAllowList());
        keysToRetain.addAll(StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).flatMap(label -> config.getNodeAllowMap().getOrDefault(label, Collections.emptyList()).stream()).collect(Collectors.toSet()));
        ArrayList<String> keysToRemove = new ArrayList<String>(config.getAllNodesDisallowList());
        keysToRemove.addAll(StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).flatMap(label -> config.getNodeDisallowMap().getOrDefault(label, Collections.emptyList()).stream()).collect(Collectors.toSet()));
        keysToRemove.addAll(config.getMapDisallowList());
        Map<String, Object> allProperties = this.getEntityProperties((Entity)node, config, keysToRetain, keysToRemove);
        this.fingerprint(md, allProperties, config);
    }

    private void fingerprintRelationship(DiagnosingMessageDigestDecorator md, Relationship rel, FingerprintingConfig config) {
        switch (config.getStrategy()) {
            case EAGER: {
                md.update(rel.getType().name().getBytes());
                md.update(this.fingerprint((Object)rel.getStartNode(), config).getBytes());
                md.update(this.fingerprint((Object)rel.getEndNode(), config).getBytes());
                break;
            }
            case LAZY: {
                if (!config.getAllTypes().contains(rel.getType().name())) break;
                md.update(rel.getType().name().getBytes());
                md.update(this.fingerprint((Object)rel.getStartNode(), config).getBytes());
                md.update(this.fingerprint((Object)rel.getEndNode(), config).getBytes());
            }
        }
        ArrayList<String> keysToRetain = new ArrayList<String>(config.getAllRelsAllowList());
        keysToRetain.addAll(config.getRelAllowMap().getOrDefault(rel.getType().name(), Collections.emptyList()));
        ArrayList<String> keysToRemove = new ArrayList<String>(config.getAllRelsDisallowList());
        keysToRemove.addAll(config.getRelDisallowMap().getOrDefault(rel.getType().name(), Collections.emptyList()));
        keysToRemove.addAll(config.getMapDisallowList());
        Map<String, Object> allProperties = this.getEntityProperties((Entity)rel, config, keysToRetain, keysToRemove);
        this.fingerprint(md, allProperties, config);
    }

    private Map<String, Object> getEntityProperties(Entity entity, FingerprintingConfig config, List<String> keysToRetain, List<String> keysToRemove) {
        Map allProperties;
        if (keysToRetain.isEmpty() && keysToRemove.isEmpty()) {
            switch (config.getStrategy()) {
                case LAZY: {
                    allProperties = Collections.emptyMap();
                    break;
                }
                default: {
                    allProperties = entity.getAllProperties();
                    break;
                }
            }
        } else {
            allProperties = entity.getAllProperties();
            if (!keysToRetain.isEmpty()) {
                allProperties.keySet().retainAll(keysToRetain);
            }
            if (!keysToRemove.isEmpty()) {
                allProperties.keySet().removeAll(keysToRemove);
            }
        }
        return allProperties;
    }

    private String withMessageDigest(FingerprintingConfig conf, Consumer<DiagnosingMessageDigestDecorator> consumer) {
        try {
            MessageDigest md = MessageDigest.getInstance(conf.getDigestAlgorithm());
            DiagnosingMessageDigestDecorator dmd = new DiagnosingMessageDigestDecorator(md);
            consumer.accept(dmd);
            return Fingerprinting.renderAsHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String renderAsHex(byte[] content) {
        Formatter formatter = new Formatter();
        for (byte b : content) {
            formatter.format("%02X", b);
        }
        return formatter.toString();
    }

    private String convertValueToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            return this.nativeArrayToString(value);
        }
        return value.toString();
    }

    private String nativeArrayToString(Object value) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof String[]) {
            for (String s : (String[])value) {
                sb.append(s);
            }
        } else if (value instanceof double[]) {
            for (double d : (double[])value) {
                sb.append(d);
            }
        } else if (value instanceof long[]) {
            long[] lArray = (long[])value;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                double l = lArray[i];
                sb.append(l);
            }
        } else {
            throw new UnsupportedOperationException("cannot yet deal with " + value.getClass().getName());
        }
        return sb.toString();
    }

    private class DiagnosingMessageDigestDecorator {
        private final MessageDigest delegate;

        public DiagnosingMessageDigestDecorator(MessageDigest delegate) {
            this.delegate = delegate;
        }

        public void update(byte[] value) {
            if (Fingerprinting.this.log.isDebugEnabled()) {
                Fingerprinting.this.log.debug("adding to message digest {}", new Object[]{new String(value)});
            }
            this.delegate.update(value);
        }
    }

    private static class EndNodeRelationshipHashTuple
    implements Comparable {
        private final String endNodeHash;
        private final String relationshipHash;

        public EndNodeRelationshipHashTuple(String endNodeHash, String relationshipHash) {
            this.endNodeHash = endNodeHash;
            this.relationshipHash = relationshipHash;
        }

        public int compareTo(Object o) {
            EndNodeRelationshipHashTuple other = (EndNodeRelationshipHashTuple)o;
            int res = this.endNodeHash.compareTo(other.endNodeHash);
            if (res == 0) {
                res = this.relationshipHash.compareTo(other.relationshipHash);
            }
            return res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndNodeRelationshipHashTuple that = (EndNodeRelationshipHashTuple)o;
            if (this.endNodeHash != null ? !this.endNodeHash.equals(that.endNodeHash) : that.endNodeHash != null) {
                return false;
            }
            return this.relationshipHash != null ? this.relationshipHash.equals(that.relationshipHash) : that.relationshipHash == null;
        }

        public int hashCode() {
            int result = this.endNodeHash != null ? this.endNodeHash.hashCode() : 0;
            result = 31 * result + (this.relationshipHash != null ? this.relationshipHash.hashCode() : 0);
            return result;
        }

        public String getEndNodeHash() {
            return this.endNodeHash;
        }

        public String getRelationshipHash() {
            return this.relationshipHash;
        }
    }
}

