/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Extended;
import apoc.export.util.CountingInputStream;
import apoc.meta.Meta;
import apoc.util.DateParseUtil;
import apoc.util.FileUtils;
import apoc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.LocalDateTimeValue;

@Extended
public class LoadXls {
    public static final char DEFAULT_ARRAY_SEP = ';';
    @Context
    public GraphDatabaseService db;

    @Procedure(value="apoc.load.xls")
    @Description(value="apoc.load.xls('url','selector',{config}) YIELD lineNo, list, map - load XLS fom URL as stream of row values,\n config contains any of: {skip:1,limit:5,header:false,ignore:['tmp'],arraySep:';',mapping:{years:{type:'int',arraySep:'-',array:false,name:'age',ignore:false, dateFormat:'iso_date', dateParse:['dd-MM-yyyy']}}")
    public Stream<XLSResult> xls(@Name(value="url") String url, @Name(value="selector") String selector, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Stream<XLSResult> stream;
        block10: {
            boolean failOnError = this.booleanValue(config, "failOnError", true);
            CountingInputStream stream2 = FileUtils.inputStreamFor(url);
            try {
                Selection selection = new Selection(selector);
                char arraySep = this.separator(config, "arraySep", ';');
                long skip = this.longValue(config, "skip", 0L);
                boolean hasHeader = this.booleanValue(config, "header", true);
                long limit = this.longValue(config, "limit", Long.MAX_VALUE);
                List<String> ignore = this.value(config, "ignore", Collections.emptyList());
                List<Object> nullValues = this.value(config, "nullValues", Collections.emptyList());
                Map<String, Map<String, Object>> mapping = this.value(config, "mapping", Collections.emptyMap());
                Map<String, Mapping> mappings = this.createMapping(mapping, arraySep, ignore);
                Workbook workbook = WorkbookFactory.create((InputStream)stream2);
                Sheet sheet = workbook.getSheet(selection.sheet);
                if (sheet == null) {
                    throw new IllegalStateException("Sheet " + selection.sheet + " not found");
                }
                selection.updateVertical(sheet.getFirstRowNum(), sheet.getLastRowNum());
                Row firstRow = sheet.getRow(selection.top);
                selection.updateHorizontal(firstRow.getFirstCellNum(), firstRow.getLastCellNum());
                String[] header = this.getHeader(hasHeader, firstRow, selection, ignore, mappings);
                boolean checkIgnore = !ignore.isEmpty() || mappings.values().stream().anyMatch(m -> m.ignore);
                stream = StreamSupport.stream(new XLSSpliterator(sheet, selection, header, url, skip, limit, checkIgnore, mappings, nullValues), false);
                if (stream2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (!failOnError) {
                        return Stream.of(new XLSResult(new String[0], new Object[0], 0L, true, Collections.emptyMap(), Collections.emptyList()));
                    }
                    throw new RuntimeException("Can't read XLS from URL " + Util.cleanUrl(url), e);
                }
            }
            stream2.close();
        }
        return stream;
    }

    private Map<String, Mapping> createMapping(Map<String, Map<String, Object>> mapping, char arraySep, List<String> ignore) {
        if (mapping.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Mapping> result = new HashMap<String, Mapping>(mapping.size());
        for (Map.Entry<String, Map<String, Object>> entry : mapping.entrySet()) {
            String name = entry.getKey();
            result.put(name, new Mapping(name, entry.getValue(), arraySep, ignore.contains(name)));
        }
        return result;
    }

    private static String[] convertFormat(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            throw new RuntimeException("Only array of Strings are allowed!");
        }
        List strings = (List)value;
        return strings.toArray(new String[strings.size()]);
    }

    private String[] getHeader(boolean hasHeader, Row header, Selection selection, List<String> ignore, Map<String, Mapping> mapping) throws IOException {
        if (!hasHeader) {
            return null;
        }
        String[] result = new String[selection.right - selection.left];
        for (int i = selection.left; i < selection.right; ++i) {
            Cell cell = header.getCell(i);
            if (cell == null) {
                throw new IllegalStateException("Header at position " + i + " doesn't have a value");
            }
            String value = cell.getStringCellValue();
            result[i - selection.left] = ignore.contains(value) || mapping.getOrDefault((Object)value, (Mapping)Mapping.EMPTY).ignore ? null : value;
        }
        return result;
    }

    private boolean booleanValue(Map<String, Object> config, String key, boolean defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private long longValue(Map<String, Object> config, String key, long defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    private <T> T value(Map<String, Object> config, String key, T defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        return (T)config.get(key);
    }

    private char separator(Map<String, Object> config, String key, char defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value == null) {
            return defaultValue;
        }
        return LoadXls.separator(value.toString(), defaultValue);
    }

    private static char separator(String separator, char defaultSep) {
        if (separator == null) {
            return defaultSep;
        }
        if ("TAB".equalsIgnoreCase(separator)) {
            return '\t';
        }
        return separator.charAt(0);
    }

    private static Object[] extract(Row row, Selection selection) {
        Object[] result = new Object[selection.right - selection.left];
        for (int i = selection.left; i < selection.right; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            result[i - selection.left] = LoadXls.getValue(cell, cell.getCellTypeEnum());
        }
        return result;
    }

    private static Object getValue(Cell cell, CellType type) {
        switch (type) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(cell.getDateCellValue());
                    LocalDateTime localDateTime = LocalDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
                    return LocalDateTimeValue.localDateTime((LocalDateTime)localDateTime);
                }
                double value = cell.getNumericCellValue();
                if (value == Math.floor(value)) {
                    return (long)value;
                }
                return value;
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case FORMULA: {
                return LoadXls.getValue(cell, cell.getCachedFormulaResultTypeEnum());
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case _NONE: {
                return null;
            }
            case BLANK: {
                return null;
            }
            case ERROR: {
                return null;
            }
        }
        return null;
    }

    private static class XLSSpliterator
    extends Spliterators.AbstractSpliterator<XLSResult> {
        private final Sheet sheet;
        private final Selection selection;
        private final String[] header;
        private final String url;
        private final long limit;
        private final boolean ignore;
        private final Map<String, Mapping> mapping;
        private final List<Object> nullValues;
        private final long skip;
        long lineNo;

        public XLSSpliterator(Sheet sheet, Selection selection, String[] header, String url, long skip, long limit, boolean ignore, Map<String, Mapping> mapping, List<Object> nullValues) throws IOException {
            super(Long.MAX_VALUE, 16);
            this.sheet = sheet;
            this.selection = selection;
            this.header = header;
            this.url = url;
            this.ignore = ignore;
            this.mapping = mapping;
            this.nullValues = nullValues;
            int headerOffset = header != null ? 1 : 0;
            this.skip = skip + (long)selection.getOrDefault(selection.top, sheet.getFirstRowNum()) + (long)headerOffset;
            this.limit = limit == Long.MAX_VALUE ? (long)selection.getOrDefault(selection.bottom, sheet.getLastRowNum()) : skip + limit;
            this.lineNo = this.skip;
        }

        @Override
        public boolean tryAdvance(Consumer<? super XLSResult> action) {
            try {
                Row row = this.sheet.getRow((int)this.lineNo);
                if (row != null && this.lineNo <= this.limit) {
                    Object[] list = LoadXls.extract(row, this.selection);
                    action.accept(new XLSResult(this.header, list, this.lineNo - this.skip, this.ignore, this.mapping, this.nullValues));
                    ++this.lineNo;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading XLS from URL " + Util.cleanUrl(this.url) + " at " + this.lineNo, e);
            }
        }
    }

    public static class XLSResult {
        public long lineNo;
        public List<Object> list;
        public Map<String, Object> map;

        public XLSResult(String[] header, Object[] list, long lineNo, boolean ignore, Map<String, Mapping> mapping, List<Object> nullValues) {
            this.lineNo = lineNo;
            this.removeNullValues(list, nullValues);
            this.map = this.createMap(header, list, ignore, mapping);
            this.list = this.createList(header, list, ignore, mapping);
        }

        public void removeNullValues(Object[] list, List<Object> nullValues) {
            if (nullValues.isEmpty()) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null || !nullValues.contains(list[i])) continue;
                list[i] = null;
            }
        }

        private List<Object> createList(String[] header, Object[] list, boolean ignore, Map<String, Mapping> mappings) {
            if (!ignore && mappings.isEmpty()) {
                return Arrays.asList(list);
            }
            ArrayList<Object> result = new ArrayList<Object>(list.length);
            for (int i = 0; i < header.length; ++i) {
                String name = header[i];
                if (name == null) continue;
                Mapping mapping = mappings.get(name);
                if (mapping != null) {
                    if (mapping.ignore) continue;
                    result.add(mapping.convert(list[i]));
                    continue;
                }
                result.add(list[i]);
            }
            return result;
        }

        private Map<String, Object> createMap(String[] header, Object[] list, boolean ignore, Map<String, Mapping> mappings) {
            if (header == null) {
                return null;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(header.length, 1.0f);
            for (int i = 0; i < header.length; ++i) {
                String name = header[i];
                if (ignore && name == null) continue;
                Mapping mapping = mappings.get(name);
                if (mapping == null) {
                    map.put(name, list[i]);
                    continue;
                }
                if (mapping.ignore) continue;
                map.put(mapping.name, mapping.convert(list[i]));
            }
            return map;
        }
    }

    static class Mapping {
        public static final Mapping EMPTY = new Mapping("", Collections.emptyMap(), ';', false);
        final String name;
        final Collection<Object> nullValues;
        final Meta.Types type;
        final boolean array;
        final boolean ignore;
        final char arraySep;
        final String dateFormat;
        private final String[] dateParse;
        private final Pattern arrayPattern;

        public Mapping(String name, Map<String, Object> mapping, char arraySep, boolean ignore) {
            this.name = mapping.getOrDefault("name", name).toString();
            this.array = (Boolean)mapping.getOrDefault("array", false);
            this.ignore = (Boolean)mapping.getOrDefault("ignore", ignore);
            this.nullValues = mapping.getOrDefault("nullValues", Collections.emptyList());
            this.arraySep = LoadXls.separator(mapping.getOrDefault("arraySep", Character.valueOf(arraySep)).toString(), ';');
            this.type = Meta.Types.from(mapping.getOrDefault("type", "STRING").toString());
            this.arrayPattern = Pattern.compile(String.valueOf(this.arraySep), 16);
            this.dateFormat = mapping.getOrDefault("dateFormat", "").toString();
            this.dateParse = LoadXls.convertFormat(mapping.getOrDefault("dateParse", null));
        }

        public Object convert(Object value) {
            return this.array ? this.convertArray(value) : this.convertType(value);
        }

        private Object convertArray(Object value) {
            if (value == null) {
                return Collections.emptyList();
            }
            String[] values = this.arrayPattern.split(value.toString());
            ArrayList<Object> result = new ArrayList<Object>(values.length);
            for (String v : values) {
                result.add(this.convertType(v));
            }
            return result;
        }

        private Object convertType(Object value) {
            if (this.nullValues.contains(value) || value == null) {
                return null;
            }
            switch (this.type) {
                case STRING: {
                    if (value instanceof TemporalAccessor && !this.dateFormat.isEmpty()) {
                        return Util.dateFormat((TemporalAccessor)value, this.dateFormat);
                    }
                    return value.toString();
                }
                case INTEGER: {
                    return Util.toLong(value);
                }
                case FLOAT: {
                    return Util.toDouble(value);
                }
                case BOOLEAN: {
                    return Util.toBoolean(value);
                }
                case NULL: {
                    return null;
                }
                case LIST: {
                    return Arrays.stream(this.arrayPattern.split(value.toString())).map(this::convertType).collect(Collectors.toList());
                }
                case DATE: {
                    return DateParseUtil.dateParse(value.toString(), LocalDate.class, this.dateParse);
                }
                case DATE_TIME: {
                    return DateParseUtil.dateParse(value.toString(), ZonedDateTime.class, this.dateParse);
                }
                case LOCAL_DATE_TIME: {
                    return DateParseUtil.dateParse(value.toString(), LocalDateTime.class, this.dateParse);
                }
                case LOCAL_TIME: {
                    return DateParseUtil.dateParse(value.toString(), LocalTime.class, this.dateParse);
                }
                case TIME: {
                    return DateParseUtil.dateParse(value.toString(), OffsetTime.class, this.dateParse);
                }
                case DURATION: {
                    return Util.durationParse(value.toString());
                }
            }
            return value;
        }
    }

    static class Selection {
        private static final Pattern PATTERN = Pattern.compile("([a-z]+)(\\d+)?(?::([a-z]+)(\\d+)?)?", 2);
        private static final int DEFAULT = -1;
        String sheet;
        int top = -1;
        int left = -1;
        int bottom = -1;
        int right = -1;

        public Selection(String selector) {
            String range;
            Matcher matcher;
            String[] parts = selector.split("!");
            this.sheet = parts[0];
            if (parts.length > 1 && !parts[1].trim().isEmpty() && (matcher = PATTERN.matcher(range = parts[1].trim().replace("$", ""))).matches()) {
                this.left = this.toCol(matcher.group(1), -1);
                this.top = this.toRow(matcher.group(2), -1);
                this.right = this.toCol(matcher.group(3), this.left);
                if (this.right != -1) {
                    ++this.right;
                }
                this.bottom = this.toRow(matcher.group(4), -1);
            }
        }

        int getOrDefault(int value, int given) {
            return value == -1 ? given : value;
        }

        private int toCol(String col, int defaultValue) {
            if (col == null || col.trim().isEmpty()) {
                return defaultValue;
            }
            AtomicInteger index = new AtomicInteger(0);
            return Stream.of(col.trim().toUpperCase().split("")).map(str -> new AbstractMap.SimpleEntry<Integer, Integer>(index.getAndIncrement(), str.charAt(0) - 65)).map(e -> 26 * (Integer)e.getKey() + (Integer)e.getValue()).reduce(0, Math::addExact);
        }

        private int toRow(String row, int defaultValue) {
            if (row == null || row.trim().isEmpty()) {
                return defaultValue;
            }
            row = row.trim();
            try {
                return Integer.parseInt(row) - 1;
            }
            catch (NumberFormatException nfe) {
                return (short)defaultValue;
            }
        }

        public void updateVertical(int firstRowNum, int lastRowNum) {
            if (this.top == -1) {
                this.top = firstRowNum;
            }
            if (this.bottom == -1) {
                this.bottom = lastRowNum;
            }
        }

        public void updateHorizontal(short firstCellNum, short lastCellNum) {
            if (this.left == -1) {
                this.left = firstCellNum;
            }
            if (this.right == -1) {
                this.right = lastCellNum;
            }
        }
    }

    static enum Results {
        map,
        list,
        strings,
        stringMap;

    }
}

