/*
 * Decompiled with CFR 0.152.
 */
package apoc.lock;

import java.util.List;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Lock {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.lock.all([nodes],[relationships]) acquires a write lock on the given nodes and relationships")
    public void all(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels) {
        for (Node node : nodes) {
            this.tx.acquireWriteLock((Entity)node);
        }
        for (Relationship rel : rels) {
            this.tx.acquireWriteLock((Entity)rel);
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.lock.nodes([nodes]) acquires a write lock on the given nodes")
    public void nodes(@Name(value="nodes") List<Node> nodes) {
        for (Node node : nodes) {
            this.tx.acquireWriteLock((Entity)node);
        }
    }

    @Procedure(mode=Mode.READ, name="apoc.lock.read.nodes")
    @Description(value="apoc.lock.read.nodes([nodes]) acquires a read lock on the given nodes")
    public void readLockOnNodes(@Name(value="nodes") List<Node> nodes) {
        for (Node node : nodes) {
            this.tx.acquireReadLock((Entity)node);
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.lock.rels([relationships]) acquires a write lock on the given relationship")
    public void rels(@Name(value="rels") List<Relationship> rels) {
        for (Relationship rel : rels) {
            this.tx.acquireWriteLock((Entity)rel);
        }
    }

    @Procedure(mode=Mode.READ, name="apoc.lock.read.rels")
    @Description(value="apoc.lock.read.rels([relationships]) acquires a read lock on the given relationship")
    public void readLocksOnRels(@Name(value="rels") List<Relationship> rels) {
        for (Relationship rel : rels) {
            this.tx.acquireReadLock((Entity)rel);
        }
    }
}

