/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import apoc.meta.MetaConfig;
import apoc.meta.Tables4LabelsProfile;
import apoc.result.GraphResult;
import apoc.result.MapResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.MapUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.storable.DurationValue;

public class Meta {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public KernelTransaction kernelTx;
    @Context
    public Transaction transaction;
    @Context
    public Log log;
    static final int SAMPLE = 100;

    @Deprecated
    @UserFunction
    @Description(value="apoc.meta.type(value) - type name of a value (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,UNKNOWN,MAP,LIST)")
    public String type(@Name(value="value") Object value) {
        return this.typeName(value);
    }

    @Deprecated
    @UserFunction
    @Description(value="apoc.meta.typeName(value) - type name of a value (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,UNKNOWN,MAP,LIST)")
    public String typeName(@Name(value="value") Object value) {
        Object typeName;
        Types type = Types.of(value);
        switch (type) {
            case POINT: 
            case DATE: 
            case DATE_TIME: 
            case LOCAL_TIME: 
            case LOCAL_DATE_TIME: 
            case TIME: 
            case DURATION: 
            case ANY: {
                typeName = value.getClass().getSimpleName();
                break;
            }
            case LIST: {
                Class<?> clazz = value.getClass();
                if (value != null && clazz.isArray()) {
                    typeName = clazz.getComponentType().getSimpleName() + "[]";
                    break;
                }
            }
            default: {
                typeName = type.name();
            }
        }
        return typeName;
    }

    @Deprecated
    @UserFunction
    @Description(value="apoc.meta.types(node-relationship-map)  - returns a map of keys to types")
    public Map<String, Object> types(@Name(value="properties") Object target) {
        Map properties = Collections.emptyMap();
        if (target instanceof Node) {
            properties = ((Node)target).getAllProperties();
        }
        if (target instanceof Relationship) {
            properties = ((Relationship)target).getAllProperties();
        }
        if (target instanceof Map) {
            properties = (Map)target;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(properties.size());
        properties.forEach((key, value) -> result.put((String)key, this.typeName(value)));
        return result;
    }

    @Deprecated
    @UserFunction
    @Description(value="apoc.meta.isType(value,type) - returns a row if type name matches none if not (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,UNKNOWN,MAP,LIST)")
    public boolean isType(@Name(value="value") Object value, @Name(value="type") String type) {
        return type.equalsIgnoreCase(this.typeName(value));
    }

    @UserFunction(value="apoc.meta.cypher.isType")
    @Description(value="apoc.meta.cypher.isType(value,type) - returns a row if type name matches none if not (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,MAP,LIST OF <TYPE>,POINT,DATE,DATE_TIME,LOCAL_TIME,LOCAL_DATE_TIME,TIME,DURATION)")
    public boolean isTypeCypher(@Name(value="value") Object value, @Name(value="type") String type) {
        return type.equalsIgnoreCase(this.typeCypher(value));
    }

    @UserFunction(value="apoc.meta.cypher.type")
    @Description(value="apoc.meta.cypher.type(value) - type name of a value (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,MAP,LIST OF <TYPE>,POINT,DATE,DATE_TIME,LOCAL_TIME,LOCAL_DATE_TIME,TIME,DURATION)")
    public String typeCypher(@Name(value="value") Object value) {
        Types type = Types.of(value);
        switch (type) {
            case ANY: {
                return value.getClass().getSimpleName();
            }
        }
        return type.toString();
    }

    @UserFunction(value="apoc.meta.cypher.types")
    @Description(value="apoc.meta.cypher.types(node-relationship-map)  - returns a map of keys to types")
    public Map<String, Object> typesCypher(@Name(value="properties") Object target) {
        Map properties = Collections.emptyMap();
        if (target instanceof Node) {
            properties = ((Node)target).getAllProperties();
        }
        if (target instanceof Relationship) {
            properties = ((Relationship)target).getAllProperties();
        }
        if (target instanceof Map) {
            properties = (Map)target;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(properties.size());
        properties.forEach((key, value) -> result.put((String)key, this.typeCypher(value)));
        return result;
    }

    @Procedure
    @Description(value="apoc.meta.stats  yield labelCount, relTypeCount, propertyKeyCount, nodeCount, relCount, labels, relTypes, stats | returns the information stored in the transactional database statistics")
    public Stream<MetaStats> stats() {
        return Stream.of(this.collectStats());
    }

    private MetaStats collectStats() {
        final LinkedHashMap<String, Long> relStatsCount = new LinkedHashMap<String, Long>();
        TokenRead tokenRead = this.kernelTx.tokenRead();
        Read read = this.kernelTx.dataRead();
        int labelCount = tokenRead.labelCount();
        int relTypeCount = tokenRead.relationshipTypeCount();
        final LinkedHashMap<String, Long> labelStats = new LinkedHashMap<String, Long>(labelCount);
        final LinkedHashMap<String, Long> relStats = new LinkedHashMap<String, Long>(2 * relTypeCount);
        this.collectStats(null, null, new StatsCallback(){

            @Override
            public void label(int labelId, String labelName, long count) {
                if (count > 0L) {
                    labelStats.put(labelName, count);
                }
            }

            @Override
            public void rel(int typeId, String typeName, long count) {
                if (count > 0L) {
                    relStats.put("()-[:" + typeName + "]->()", count);
                }
            }

            @Override
            public void rel(int typeId, String typeName, int labelId, String labelName, long out, long in) {
                if (out > 0L) {
                    relStatsCount.put(typeName, relStatsCount.getOrDefault(typeName, 0L) + out);
                    relStats.put("(:" + labelName + ")-[:" + typeName + "]->()", out);
                }
                if (in > 0L) {
                    relStats.put("()-[:" + typeName + "]->(:" + labelName + ")", in);
                }
            }
        });
        return new MetaStats(labelCount, relTypeCount, tokenRead.propertyKeyCount(), read.countsForNodeWithoutTxState(-1), read.countsForRelationshipWithoutTxState(-1, -1, -1), labelStats, relStats, relStatsCount);
    }

    private void collectStats(Collection<String> labelNames, Collection<String> relTypeNames, StatsCallback cb) {
        Read read = this.kernelTx.dataRead();
        TokenRead tokenRead = this.kernelTx.tokenRead();
        Map<String, Integer> labels2 = this.labelsInUse(tokenRead, labelNames);
        Map<String, Integer> relTypes = this.relTypesInUse(tokenRead, relTypeNames);
        labels2.forEach((name, id) -> {
            long count = read.countsForNodeWithoutTxState(id.intValue());
            if (count > 0L) {
                cb.label((int)id, (String)name, count);
                relTypes.forEach((typeName, typeId) -> {
                    long relCountOut = read.countsForRelationship(id.intValue(), typeId.intValue(), -1);
                    long relCountIn = read.countsForRelationship(-1, typeId.intValue(), id.intValue());
                    cb.rel((int)typeId, (String)typeName, (int)id, (String)name, relCountOut, relCountIn);
                });
            }
        });
        relTypes.forEach((typeName, typeId) -> cb.rel((int)typeId, (String)typeName, read.countsForRelationship(-1, typeId.intValue(), -1)));
    }

    private Map<String, Integer> relTypesInUse(TokenRead ops, Collection<String> relTypeNames) {
        Stream<String> types = relTypeNames == null || relTypeNames.isEmpty() ? Iterables.stream((Iterable)this.tx.getAllRelationshipTypesInUse()).map(RelationshipType::name) : relTypeNames.stream();
        return types.collect(Collectors.toMap(t -> t, arg_0 -> ((TokenRead)ops).relationshipType(arg_0)));
    }

    private Map<String, Integer> labelsInUse(TokenRead ops, Collection<String> labelNames) {
        Stream<String> labels2 = labelNames == null || labelNames.isEmpty() ? Iterables.stream((Iterable)this.tx.getAllLabelsInUse()).map(Label::name) : labelNames.stream();
        return labels2.collect(Collectors.toMap(t -> t, arg_0 -> ((TokenRead)ops).nodeLabel(arg_0)));
    }

    @Procedure
    @Description(value="apoc.meta.data({config})  - examines a subset of the graph to provide a tabular meta information")
    public Stream<MetaResult> data(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config);
        return this.collectMetaData(metaConfig).values().stream().flatMap(x -> x.values().stream());
    }

    @Procedure
    @Description(value="apoc.meta.schema({config})  - examines a subset of the graph to provide a map-like meta information")
    public Stream<MapResult> schema(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaStats metaStats = this.collectStats();
        MetaConfig metaConfig = new MetaConfig(config);
        Map<String, Map<String, MetaResult>> metaData = this.collectMetaData(metaConfig);
        Map<String, Object> relationships = this.collectRelationshipsMetaData(metaStats, metaData);
        Map<String, Object> nodes = this.collectNodesMetaData(metaStats, metaData, relationships);
        nodes.putAll(relationships);
        return Stream.of(new MapResult(nodes));
    }

    @Procedure
    @Description(value="apoc.meta.nodeTypeProperties()")
    public Stream<Tables4LabelsProfile.NodeTypePropertiesEntry> nodeTypeProperties(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config);
        try {
            return this.collectTables4LabelsProfile(metaConfig).asNodeStream();
        }
        catch (Exception e) {
            this.log.debug("meta.nodeTypeProperties(): Failed to return stream", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Procedure
    @Description(value="apoc.meta.relTypeProperties()")
    public Stream<Tables4LabelsProfile.RelTypePropertiesEntry> relTypeProperties(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config);
        try {
            return this.collectTables4LabelsProfile(metaConfig).asRelStream();
        }
        catch (Exception e) {
            this.log.debug("meta.relTypeProperties(): Failed to return stream", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Tables4LabelsProfile collectTables4LabelsProfile(MetaConfig config) {
        Tables4LabelsProfile profile = new Tables4LabelsProfile();
        Schema schema = this.tx.schema();
        for (ConstraintDefinition cd : schema.getConstraints()) {
            if (cd.isConstraintType(ConstraintType.NODE_PROPERTY_EXISTENCE)) {
                List<Object> props = new ArrayList(10);
                if (ConstraintTracker.nodeConstraints.containsKey(cd.getLabel().name())) {
                    props = ConstraintTracker.nodeConstraints.get(cd.getLabel().name());
                }
                cd.getPropertyKeys().forEach(props::add);
                ConstraintTracker.nodeConstraints.put(cd.getLabel().name(), props);
                continue;
            }
            if (!cd.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE)) continue;
            ArrayList tcd = new ArrayList(10);
            List<Object> props = new ArrayList(10);
            if (ConstraintTracker.relConstraints.containsKey(cd.getRelationshipType().name())) {
                props = ConstraintTracker.relConstraints.get(cd.getRelationshipType().name());
            }
            cd.getPropertyKeys().forEach(props::add);
            ConstraintTracker.relConstraints.put(cd.getRelationshipType().name(), props);
        }
        Map<String, Long> countStore = this.getLabelCountStore();
        Set<String> includeLabels = config.getIncludesLabels();
        Set<String> excludes = config.getExcludes();
        Set<String> includeRels = config.getIncludesRels();
        Set<String> excludeRels = config.getExcludeRels();
        for (Label label : this.tx.getAllLabelsInUse()) {
            String labelName = label.name();
            if (excludes.contains(labelName) || !includeLabels.isEmpty() && !includeLabels.contains(labelName)) continue;
            for (ConstraintDefinition cd : schema.getConstraints(label)) {
                profile.noteConstraint(label, cd);
            }
            for (IndexDefinition index : schema.getIndexes(label)) {
                profile.noteIndex(label, index);
            }
            long labelCount = countStore.get(labelName);
            long sample = this.getSampleForLabelCount(labelCount, config.getSample());
            ResourceIterator nodes = this.tx.findNodes(label);
            try {
                int count = 1;
                while (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    if ((long)count++ % sample != 0L) continue;
                    boolean skipNode = false;
                    for (RelationshipType rel : node.getRelationshipTypes()) {
                        String relName = rel.name();
                        if (excludeRels.contains(relName)) {
                            skipNode = true;
                            continue;
                        }
                        if (includeRels.isEmpty() || includeRels.contains(relName)) continue;
                        skipNode = true;
                    }
                    if (skipNode) continue;
                    profile.observe(node, config);
                }
            }
            finally {
                if (nodes == null) continue;
                nodes.close();
            }
        }
        return profile.finished();
    }

    private Map<String, Map<String, MetaResult>> collectMetaData(MetaConfig config) {
        LinkedHashMap<String, Map<String, MetaResult>> metaData = new LinkedHashMap<String, Map<String, MetaResult>>(100);
        Schema schema = this.transaction.schema();
        HashMap<String, Iterable<ConstraintDefinition>> relConstraints = new HashMap<String, Iterable<ConstraintDefinition>>(20);
        for (RelationshipType type : this.tx.getAllRelationshipTypesInUse()) {
            metaData.put(type.name(), new LinkedHashMap(10));
            relConstraints.put(type.name(), schema.getConstraints(type));
        }
        Map<String, Long> countStore = this.getLabelCountStore();
        for (Label label : this.tx.getAllLabelsInUse()) {
            LinkedHashMap<String, MetaResult> nodeMeta = new LinkedHashMap<String, MetaResult>(50);
            String labelName = label.name();
            metaData.put(labelName, nodeMeta);
            Iterable constraints = schema.getConstraints(label);
            LinkedHashSet<String> indexed = new LinkedHashSet<String>();
            for (IndexDefinition index : schema.getIndexes(label)) {
                for (String prop : index.getPropertyKeys()) {
                    indexed.add(prop);
                }
            }
            long labelCount = countStore.get(labelName);
            long sample = this.getSampleForLabelCount(labelCount, config.getSample());
            ResourceIterator nodes = this.tx.findNodes(label);
            try {
                int count = 1;
                while (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    if ((long)count++ % sample != 0L) continue;
                    this.addRelationships(metaData, nodeMeta, labelName, node, relConstraints);
                    this.addProperties(nodeMeta, labelName, constraints, indexed, (Entity)node, node);
                }
            }
            finally {
                if (nodes == null) continue;
                nodes.close();
            }
        }
        return metaData;
    }

    private Map<String, Long> getLabelCountStore() {
        List labels2 = Iterables.stream((Iterable)this.tx.getAllLabelsInUse()).map(label -> label.name()).collect(Collectors.toList());
        TokenRead tokenRead = this.kernelTx.tokenRead();
        return labels2.stream().collect(Collectors.toMap(e -> e, e -> this.kernelTx.dataRead().countsForNodeWithoutTxState(tokenRead.nodeLabel(e))));
    }

    public long getSampleForLabelCount(long labelCount, long sample) {
        if (sample != -1L) {
            long max;
            long skipCount = labelCount / sample;
            long min = (long)Math.floor((double)skipCount - (double)skipCount * 0.1);
            if (min >= (max = (long)Math.ceil((double)skipCount + (double)skipCount * 0.1))) {
                return -1L;
            }
            long randomValue = ThreadLocalRandom.current().nextLong(min, max);
            return randomValue == 0L ? -1L : randomValue;
        }
        return sample;
    }

    private Map<String, Object> collectNodesMetaData(MetaStats metaStats, Map<String, Map<String, MetaResult>> metaData, Map<String, Object> relationships) {
        LinkedHashMap<String, Object> nodes = new LinkedHashMap<String, Object>();
        HashMap<String, List<Map<String, Object>>> startNodeNameToRelationshipsMap = new HashMap<String, List<Map<String, Object>>>();
        for (String entityName : metaData.keySet()) {
            Map<String, MetaResult> entityData = metaData.get(entityName);
            LinkedHashMap<String, Map<String, Object>> entityProperties = new LinkedHashMap<String, Map<String, Object>>();
            LinkedHashMap<String, Map<String, Object>> entityRelationships = new LinkedHashMap<String, Map<String, Object>>();
            List<Object> labels2 = new LinkedList();
            boolean isNode = true;
            for (String entityDataKey : entityData.keySet()) {
                MetaResult metaResult = entityData.get(entityDataKey);
                if (metaResult.elementType.equals("relationship")) {
                    isNode = false;
                    break;
                }
                if (metaResult.unique) {
                    labels2 = metaResult.otherLabels;
                }
                if (!metaResult.type.equals("RELATIONSHIP")) {
                    entityProperties.put(entityDataKey, MapUtil.map("type", metaResult.type, "indexed", metaResult.index, "unique", metaResult.unique, "existence", metaResult.existence));
                    continue;
                }
                entityRelationships.put(metaResult.property, MapUtil.map("direction", "out", "count", metaResult.rightCount, "labels", metaResult.other, "properties", ((Map)relationships.get(metaResult.property)).get("properties")));
                metaResult.other.forEach(o -> {
                    LinkedHashMap<String, Map<String, Object>> mirroredRelationship = new LinkedHashMap<String, Map<String, Object>>();
                    mirroredRelationship.put(metaResult.property, MapUtil.map("direction", "in", "count", metaResult.leftCount, "labels", new LinkedList<String>(Arrays.asList(metaResult.label)), "properties", ((Map)relationships.get(metaResult.property)).get("properties")));
                    if (startNodeNameToRelationshipsMap.containsKey(o)) {
                        ((List)startNodeNameToRelationshipsMap.get(o)).add(mirroredRelationship);
                    } else {
                        LinkedList<LinkedHashMap<String, Map<String, Object>>> relList = new LinkedList<LinkedHashMap<String, Map<String, Object>>>();
                        relList.add(mirroredRelationship);
                        startNodeNameToRelationshipsMap.put((String)o, (List<Map<String, Object>>)relList);
                    }
                });
            }
            if (!isNode) continue;
            nodes.put(entityName, MapUtil.map("type", "node", "count", metaStats.labels.get(entityName), "labels", labels2, "properties", entityProperties, "relationships", entityRelationships));
        }
        this.setIncomingRelationships(nodes, startNodeNameToRelationshipsMap);
        return nodes;
    }

    private void setIncomingRelationships(Map<String, Object> nodes, Map<String, List<Map<String, Object>>> nodeNameToRelationshipsMap) {
        nodes.keySet().forEach(k -> {
            if (nodeNameToRelationshipsMap.containsKey(k)) {
                Map node = (Map)nodes.get(k);
                List relationshipsToAddList = (List)nodeNameToRelationshipsMap.get(k);
                relationshipsToAddList.forEach(relationshipNameToRelationshipMap -> {
                    Map actualRelationshipsList = (Map)node.get("relationships");
                    relationshipNameToRelationshipMap.keySet().forEach(relationshipName -> {
                        if (actualRelationshipsList.containsKey(relationshipName)) {
                            Map relToAdd = (Map)relationshipNameToRelationshipMap.get(relationshipName);
                            Map existingRel = (Map)actualRelationshipsList.get(relationshipName);
                            List labels2 = (List)existingRel.get("labels");
                            labels2.addAll((List)relToAdd.get("labels"));
                        } else {
                            actualRelationshipsList.put(relationshipName, relationshipNameToRelationshipMap.get(relationshipName));
                        }
                    });
                });
            }
        });
    }

    private Map<String, Object> collectRelationshipsMetaData(MetaStats metaStats, Map<String, Map<String, MetaResult>> metaData) {
        LinkedHashMap<String, Object> relationships = new LinkedHashMap<String, Object>();
        for (String entityName : metaData.keySet()) {
            Map<String, MetaResult> entityData = metaData.get(entityName);
            LinkedHashMap<String, Map<String, Object>> entityProperties = new LinkedHashMap<String, Map<String, Object>>();
            boolean isRelationship = true;
            for (String entityDataKey : entityData.keySet()) {
                MetaResult metaResult = entityData.get(entityDataKey);
                if (!metaResult.elementType.equals("relationship")) {
                    isRelationship = false;
                    break;
                }
                if (metaResult.type.equals("RELATIONSHIP")) continue;
                entityProperties.put(entityDataKey, MapUtil.map("type", metaResult.type, "array", metaResult.array, "existence", metaResult.existence));
            }
            if (!isRelationship) continue;
            relationships.put(entityName, MapUtil.map("type", "relationship", "count", metaStats.relTypesCount.get(entityName), "properties", entityProperties));
        }
        return relationships;
    }

    private void addProperties(Map<String, MetaResult> properties, String labelName, Iterable<ConstraintDefinition> constraints, Set<String> indexed, Entity pc, Node node) {
        for (String prop : pc.getPropertyKeys()) {
            if (properties.containsKey(prop)) continue;
            MetaResult res = this.metaResultForProp(pc, labelName, prop);
            res.elementType(Types.of(pc).name());
            this.addSchemaInfo(res, prop, constraints, indexed, node);
            properties.put(prop, res);
        }
    }

    private void addRelationships(Map<String, Map<String, MetaResult>> metaData, Map<String, MetaResult> nodeMeta, String labelName, Node node, Map<String, Iterable<ConstraintDefinition>> relConstraints) {
        for (RelationshipType type : node.getRelationshipTypes()) {
            Map<String, MetaResult> typeMeta;
            int out = node.getDegree(type, Direction.OUTGOING);
            if (out == 0) continue;
            String typeName = type.name();
            Iterable<ConstraintDefinition> constraints = relConstraints.get(typeName);
            if (!nodeMeta.containsKey(typeName)) {
                nodeMeta.put(typeName, new MetaResult(labelName, typeName));
            }
            if (!(typeMeta = metaData.get(typeName)).containsKey(labelName)) {
                typeMeta.put(labelName, new MetaResult(typeName, labelName));
            }
            MetaResult relMeta = nodeMeta.get(typeName);
            this.addOtherNodeInfo(node, labelName, out, type, relMeta, typeMeta, constraints);
        }
    }

    private void addOtherNodeInfo(Node node, String labelName, int out, RelationshipType type, MetaResult relMeta, Map<String, MetaResult> typeMeta, Iterable<ConstraintDefinition> relConstraints) {
        MetaResult relNodeMeta = typeMeta.get(labelName);
        relMeta.elementType(Types.of(node).name());
        for (Relationship rel : node.getRelationships(Direction.OUTGOING, new RelationshipType[]{type})) {
            Node endNode = rel.getEndNode();
            List<String> labels2 = this.toStrings(endNode.getLabels());
            int in = endNode.getDegree(type, Direction.INCOMING);
            relMeta.inc().other(labels2).rel(out, in);
            relNodeMeta.inc().other(labels2).rel(out, in);
            this.addProperties(typeMeta, type.name(), relConstraints, Collections.emptySet(), (Entity)rel, node);
            relNodeMeta.elementType(Types.RELATIONSHIP.name());
        }
    }

    private void addSchemaInfo(MetaResult res, String prop, Iterable<ConstraintDefinition> constraints, Set<String> indexed, Node node) {
        if (indexed.contains(prop)) {
            res.index = true;
        }
        if (constraints == null) {
            return;
        }
        for (ConstraintDefinition constraint : constraints) {
            for (String key : constraint.getPropertyKeys()) {
                if (!key.equals(prop)) continue;
                switch (constraint.getConstraintType()) {
                    case UNIQUENESS: {
                        res.unique = true;
                        node.getLabels().forEach(l -> {
                            if (res.label != l.name()) {
                                res.addLabel(l.name());
                            }
                        });
                        break;
                    }
                    case NODE_PROPERTY_EXISTENCE: {
                        res.existence = true;
                        break;
                    }
                    case RELATIONSHIP_PROPERTY_EXISTENCE: {
                        res.existence = true;
                    }
                }
            }
        }
    }

    private MetaResult metaResultForProp(Entity pc, String labelName, String prop) {
        MetaResult res = new MetaResult(labelName, prop);
        Object value = pc.getProperty(prop);
        res.type(Types.of(value).name());
        res.elementType(Types.of(pc).name());
        if (value.getClass().isArray()) {
            res.array = true;
        }
        return res;
    }

    private List<String> toStrings(Iterable<Label> labels2) {
        ArrayList<String> res = new ArrayList<String>(10);
        for (Label label : labels2) {
            String name = label.name();
            res.add(name);
        }
        return res;
    }

    public void sample(GraphDatabaseService db, Sampler sampler, int sampleSize) {
        for (Label label : this.tx.getAllLabelsInUse()) {
            ResourceIterator nodes = this.tx.findNodes(label);
            int count = 0;
            while (nodes.hasNext() && count++ < sampleSize) {
                Node node = (Node)nodes.next();
                sampler.sample(label, count, node);
                for (RelationshipType type : node.getRelationshipTypes()) {
                    this.sampleRels(sampleSize, sampler, label, count, node, type);
                }
            }
            nodes.close();
        }
    }

    private void sampleRels(int sampleSize, Sampler sampler, Label label, int count, Node node, RelationshipType type) {
        Direction direction = Direction.OUTGOING;
        int degree = node.getDegree(type, direction);
        sampler.sample(label, count, node, type, direction, degree, null);
        if (degree == 0) {
            return;
        }
        ResourceIterator relIt = ((ResourceIterable)node.getRelationships(direction, new RelationshipType[]{type})).iterator();
        int relCount = 0;
        while (relIt.hasNext() && relCount++ < sampleSize) {
            sampler.sample(label, count, node, type, direction, degree, (Relationship)relIt.next());
        }
        relIt.close();
    }

    @Procedure
    @Description(value="apoc.meta.graph - examines the full graph to create the meta-graph")
    public Stream<GraphResult> graph(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config);
        return this.metaGraph(null, null, true, metaConfig);
    }

    private Stream<GraphResult> metaGraph(Collection<String> labelNames, Collection<String> relTypeNames, boolean removeMissing, MetaConfig metaConfig) {
        Read read = this.kernelTx.dataRead();
        TokenRead tokenRead = this.kernelTx.tokenRead();
        Map<String, Integer> labels2 = this.labelsInUse(tokenRead, labelNames);
        Map<String, Integer> relTypes = this.relTypesInUse(tokenRead, relTypeNames);
        TreeMap vNodes = new TreeMap();
        HashMap<Pattern, Relationship> vRels = new HashMap<Pattern, Relationship>(relTypes.size() * 2);
        labels2.forEach((labelName, id) -> {
            long count = read.countsForNodeWithoutTxState(id.intValue());
            if (count > 0L) {
                this.mergeMetaNode(Label.label((String)labelName), vNodes, count);
            }
        });
        relTypes.forEach((typeName, typeId) -> {
            long global = read.countsForRelationshipWithoutTxState(-1, typeId.intValue(), -1);
            labels2.forEach((labelNameA, labelIdA) -> {
                long relCountOut = read.countsForRelationshipWithoutTxState(labelIdA.intValue(), typeId.intValue(), -1);
                if (relCountOut > 0L) {
                    labels2.forEach((labelNameB, labelIdB) -> {
                        long relCountIn = read.countsForRelationshipWithoutTxState(-1, typeId.intValue(), labelIdB.intValue());
                        if (relCountIn > 0L) {
                            Node nodeA = (Node)vNodes.get(labelNameA);
                            Node nodeB = (Node)vNodes.get(labelNameB);
                            Relationship vRel = new VirtualRelationship(nodeA, nodeB, RelationshipType.withName((String)typeName)).withProperties(MapUtil.map("type", typeName, "out", relCountOut, "in", relCountIn, "count", global));
                            vRels.put(Pattern.of(labelNameA, typeName, labelNameB), vRel);
                        }
                    });
                }
            });
        });
        if (removeMissing) {
            this.filterNonExistingRelationships(vRels, metaConfig);
        }
        GraphResult graphResult = new GraphResult(new ArrayList<Node>(vNodes.values()), new ArrayList<Relationship>(vRels.values()));
        return Stream.of(graphResult);
    }

    private void filterNonExistingRelationships(Map<Pattern, Relationship> vRels, MetaConfig metaConfig) {
        Set<Pattern> rels = vRels.keySet();
        HashMap<Pair<String, String>, Set<Pattern>> aggregated = new HashMap<Pair<String, String>, Set<Pattern>>();
        for (Pattern rel : rels) {
            this.combine(aggregated, (Pair<String, String>)Pair.of((Object)rel.from, (Object)rel.type), rel);
            this.combine(aggregated, (Pair<String, String>)Pair.of((Object)rel.type, (Object)rel.to), rel);
        }
        aggregated.values().stream().filter(c -> c.size() > 1).flatMap(Collection::stream).filter(p -> !this.relationshipExists((Pattern)p, (Relationship)vRels.get(p), metaConfig)).forEach(vRels::remove);
    }

    private boolean relationshipExists(Pattern p, Relationship relationship, MetaConfig metaConfig) {
        double degreeTo;
        if (relationship == null) {
            return false;
        }
        double degreeFrom = (double)((Long)relationship.getProperty("out")).longValue() / (double)((Long)relationship.getStartNode().getProperty("count")).longValue();
        return degreeFrom < (degreeTo = (double)((Long)relationship.getProperty("in")).longValue() / (double)((Long)relationship.getEndNode().getProperty("count")).longValue()) ? this.relationshipExists(p.labelFrom(), p.labelTo(), p.relationshipType(), Direction.OUTGOING, metaConfig) : this.relationshipExists(p.labelTo(), p.labelFrom(), p.relationshipType(), Direction.INCOMING, metaConfig);
    }

    private boolean relationshipExists(Label labelFromLabel, Label labelToLabel, RelationshipType relationshipType, Direction direction, MetaConfig metaConfig) {
        Map<String, Long> countStore = this.getLabelCountStore();
        try (ResourceIterator nodes = this.tx.findNodes(labelFromLabel);){
            long count = 1L;
            String labelName = labelFromLabel.name();
            long labelCount = countStore.get(labelName);
            long sample = this.getSampleForLabelCount(labelCount, metaConfig.getSample());
            block6: while (nodes.hasNext()) {
                if (++count % sample != 0L) continue;
                Node node = (Node)nodes.next();
                long maxRels = metaConfig.getMaxRels();
                for (Relationship rel : node.getRelationships(direction, new RelationshipType[]{relationshipType})) {
                    Node otherNode;
                    Node node2 = otherNode = direction == Direction.OUTGOING ? rel.getEndNode() : rel.getStartNode();
                    if (otherNode.hasLabel(labelToLabel)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (maxRels == -1L || maxRels-- != 0L) continue;
                    continue block6;
                }
            }
        }
        return false;
    }

    private void combine(Map<Pair<String, String>, Set<Pattern>> aggregated, Pair<String, String> p, Pattern rel) {
        if (!aggregated.containsKey(p)) {
            aggregated.put(p, new HashSet());
        }
        aggregated.get(p).add(rel);
    }

    @Procedure
    @Description(value="apoc.meta.graphSample() - examines the database statistics to build the meta graph, very fast, might report extra relationships")
    public Stream<GraphResult> graphSample(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config);
        return this.metaGraph(null, null, false, metaConfig);
    }

    @Procedure
    @Description(value="apoc.meta.subGraph({labels:[labels],rels:[rel-types], excludes:[labels,rel-types]}) - examines a sample sub graph to create the meta-graph")
    public Stream<GraphResult> subGraph(@Name(value="config") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config);
        return this.filterResultStream(metaConfig.getExcludes(), this.metaGraph(metaConfig.getIncludesLabels(), metaConfig.getIncludesRels(), true, metaConfig));
    }

    private Stream<GraphResult> filterResultStream(Set<String> excludes, Stream<GraphResult> graphResultStream) {
        if (excludes == null || excludes.isEmpty()) {
            return graphResultStream;
        }
        return graphResultStream.map(gr -> {
            Iterator<Node> it = gr.nodes.iterator();
            while (it.hasNext()) {
                Node node = it.next();
                if (!this.containsLabelName(excludes, node)) continue;
                it.remove();
            }
            Iterator<Relationship> it2 = gr.relationships.iterator();
            while (it2.hasNext()) {
                Relationship relationship = it2.next();
                if (!excludes.contains(relationship.getType().name()) && !this.containsLabelName(excludes, relationship.getStartNode()) && !this.containsLabelName(excludes, relationship.getEndNode())) continue;
                it2.remove();
            }
            return gr;
        });
    }

    private boolean containsLabelName(Set<String> excludes, Node node) {
        for (Label label : node.getLabels()) {
            if (!excludes.contains(label.name())) continue;
            return true;
        }
        return false;
    }

    private Node mergeMetaNode(Label label, Map<String, Node> labels2, long increment) {
        String name = label.name();
        Node vNode = labels2.get(name);
        if (vNode == null) {
            vNode = new VirtualNode(new Label[]{label}, Collections.singletonMap("name", name));
            labels2.put(name, vNode);
        }
        if (increment > 0L) {
            vNode.setProperty("count", (Object)(((Number)vNode.getProperty("count", (Object)0L)).longValue() + increment));
        }
        return vNode;
    }

    private void addRel(Map<List<String>, Relationship> rels, Map<String, Node> labels2, Relationship rel, boolean strict) {
        String typeName = rel.getType().name();
        Node startNode = rel.getStartNode();
        Node endNode = rel.getEndNode();
        for (Label labelA : startNode.getLabels()) {
            Node nodeA;
            Node node = nodeA = strict ? labels2.get(labelA.name()) : this.mergeMetaNode(labelA, labels2, 0L);
            if (nodeA == null) continue;
            for (Label labelB : endNode.getLabels()) {
                List<String> key = Arrays.asList(labelA.name(), labelB.name(), typeName);
                Relationship vRel = rels.get(key);
                if (vRel == null) {
                    Node nodeB;
                    Node node2 = nodeB = strict ? labels2.get(labelB.name()) : this.mergeMetaNode(labelB, labels2, 0L);
                    if (nodeB == null) continue;
                    vRel = new VirtualRelationship(nodeA, nodeB, rel.getType()).withProperties(Collections.singletonMap("type", typeName));
                    rels.put(key, vRel);
                }
                vRel.setProperty("count", (Object)((Long)vRel.getProperty("count", (Object)0L) + 1L));
            }
        }
    }

    static class NodeInfo {
        final Set<String> labels = new HashSet<String>();
        final Set<String> properties = new HashSet<String>();
        long count;
        long minDegree;
        long maxDegree;
        long sumDegree;

        NodeInfo() {
        }

        private void add(Node node) {
            ++this.count;
            int degree = node.getDegree();
            this.sumDegree += (long)degree;
            if ((long)degree > this.maxDegree) {
                this.maxDegree = degree;
            }
            if ((long)degree < this.minDegree) {
                this.minDegree = degree;
            }
            for (Label label : node.getLabels()) {
                this.labels.add(label.name());
            }
            for (String key : node.getPropertyKeys()) {
                this.properties.add(key);
            }
        }

        Map<String, Object> toMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("labels", this.labels.toArray());
            map.put("properties", this.properties.toArray());
            map.put("count", this.count);
            map.put("minDegree", this.minDegree);
            map.put("maxDegree", this.maxDegree);
            map.put("avgDegree", this.sumDegree / this.count);
            return map;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof NodeInfo && this.labels.equals(((NodeInfo)o).labels);
        }

        public int hashCode() {
            return this.labels.hashCode();
        }
    }

    static class RelInfo {
        final Set<String> properties = new HashSet<String>();
        final NodeInfo from;
        final NodeInfo to;
        final String type;
        int count;

        public RelInfo(NodeInfo from, NodeInfo to, String type) {
            this.from = from;
            this.to = to;
            this.type = type;
        }

        public void add(Relationship relationship) {
            for (String key : relationship.getPropertyKeys()) {
                this.properties.add(key);
            }
            ++this.count;
        }
    }

    static class Pattern {
        private final String from;
        private final String type;
        private final String to;

        private Pattern(String from, String type, String to) {
            this.from = from;
            this.type = type;
            this.to = to;
        }

        public static Pattern of(String labelFrom, String type, String labelTo) {
            return new Pattern(labelFrom, type, labelTo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Pattern) {
                Pattern pattern = (Pattern)o;
                return this.from.equals(pattern.from) && this.type.equals(pattern.type) && this.to.equals(pattern.to);
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 * this.from.hashCode() + this.type.hashCode()) + this.to.hashCode();
        }

        public Label labelTo() {
            return Label.label((String)this.to);
        }

        public Label labelFrom() {
            return Label.label((String)this.from);
        }

        public RelationshipType relationshipType() {
            return RelationshipType.withName((String)this.type);
        }
    }

    static interface Sampler {
        public void sample(Label var1, int var2, Node var3);

        public void sample(Label var1, int var2, Node var3, RelationshipType var4, Direction var5, int var6, Relationship var7);
    }

    static interface StatsCallback {
        public void label(int var1, String var2, long var3);

        public void rel(int var1, String var2, long var3);

        public void rel(int var1, String var2, int var3, String var4, long var5, long var7);
    }

    public static class MetaStats {
        public final long labelCount;
        public final long relTypeCount;
        public final long propertyKeyCount;
        public final long nodeCount;
        public final long relCount;
        public final Map<String, Long> labels;
        public final Map<String, Long> relTypes;
        public final Map<String, Long> relTypesCount;
        public final Map<String, Object> stats;

        public MetaStats(long labelCount, long relTypeCount, long propertyKeyCount, long nodeCount, long relCount, Map<String, Long> labels2, Map<String, Long> relTypes, Map<String, Long> relTypesCount) {
            this.labelCount = labelCount;
            this.relTypeCount = relTypeCount;
            this.propertyKeyCount = propertyKeyCount;
            this.nodeCount = nodeCount;
            this.relCount = relCount;
            this.labels = labels2;
            this.relTypes = relTypes;
            this.relTypesCount = relTypesCount;
            this.stats = MapUtil.map("labelCount", labelCount, "relTypeCount", relTypeCount, "propertyKeyCount", propertyKeyCount, "nodeCount", nodeCount, "relCount", relCount, "labels", labels2, "relTypes", relTypes);
        }
    }

    public static class MetaResult {
        public String label;
        public String property;
        public long count;
        public boolean unique;
        public boolean index;
        public boolean existence;
        public String type;
        public boolean array;
        public List<Object> sample;
        public long leftCount;
        public long rightCount;
        public long left;
        public long right;
        public List<String> other = new ArrayList<String>();
        public List<String> otherLabels = new ArrayList<String>();
        public String elementType;

        public MetaResult addLabel(String label) {
            this.otherLabels.add(label);
            return this;
        }

        public MetaResult(String label, String name) {
            this.label = label;
            this.property = name;
        }

        public MetaResult inc() {
            ++this.count;
            return this;
        }

        public MetaResult rel(long out, long in) {
            this.type = Types.RELATIONSHIP.name();
            if (out > 1L) {
                this.array = true;
            }
            this.leftCount += out;
            this.rightCount += in;
            this.left = this.leftCount / this.count;
            this.right = this.rightCount / this.count;
            return this;
        }

        public MetaResult other(List<String> labels2) {
            for (String l : labels2) {
                if (this.other.contains(l)) continue;
                this.other.add(l);
            }
            return this;
        }

        public MetaResult type(String type) {
            this.type = type;
            return this;
        }

        public MetaResult array(boolean array) {
            this.array = array;
            return this;
        }

        public MetaResult elementType(String elementType) {
            switch (elementType) {
                case "NODE": {
                    this.elementType = "node";
                    break;
                }
                case "RELATIONSHIP": {
                    this.elementType = "relationship";
                }
            }
            return this;
        }
    }

    public static enum Types {
        INTEGER,
        FLOAT,
        STRING,
        BOOLEAN,
        RELATIONSHIP,
        NODE,
        PATH,
        NULL,
        ANY,
        MAP,
        LIST,
        POINT,
        DATE,
        DATE_TIME,
        LOCAL_TIME,
        LOCAL_DATE_TIME,
        TIME,
        DURATION;

        private String typeOfList = "ANY";
        private static Map<Class<?>, Class<?>> primitivesMapping;

        public String toString() {
            switch (this) {
                case LIST: {
                    return "LIST OF " + this.typeOfList;
                }
            }
            return super.toString();
        }

        public static Types of(Object value) {
            Types type = Types.of(value == null ? null : value.getClass());
            if (type == LIST && !value.getClass().isArray()) {
                type.typeOfList = Types.inferType((List)value);
            }
            return type;
        }

        public static Types of(Class<?> type) {
            if (type == null) {
                return NULL;
            }
            if (type.isArray()) {
                Types innerType = Types.of(type.getComponentType());
                Types returnType = LIST;
                returnType.typeOfList = innerType.toString();
                return returnType;
            }
            if (type.isPrimitive()) {
                type = primitivesMapping.getOrDefault(type, type);
            }
            if (Number.class.isAssignableFrom(type)) {
                return Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) ? FLOAT : INTEGER;
            }
            if (Boolean.class.isAssignableFrom(type)) {
                return BOOLEAN;
            }
            if (String.class.isAssignableFrom(type)) {
                return STRING;
            }
            if (Map.class.isAssignableFrom(type)) {
                return MAP;
            }
            if (Node.class.isAssignableFrom(type)) {
                return NODE;
            }
            if (Relationship.class.isAssignableFrom(type)) {
                return RELATIONSHIP;
            }
            if (Path.class.isAssignableFrom(type)) {
                return PATH;
            }
            if (Point.class.isAssignableFrom(type)) {
                return POINT;
            }
            if (List.class.isAssignableFrom(type)) {
                return LIST;
            }
            if (LocalDate.class.isAssignableFrom(type)) {
                return DATE;
            }
            if (LocalTime.class.isAssignableFrom(type)) {
                return LOCAL_TIME;
            }
            if (LocalDateTime.class.isAssignableFrom(type)) {
                return LOCAL_DATE_TIME;
            }
            if (DurationValue.class.isAssignableFrom(type)) {
                return DURATION;
            }
            if (OffsetTime.class.isAssignableFrom(type)) {
                return TIME;
            }
            if (ZonedDateTime.class.isAssignableFrom(type)) {
                return DATE_TIME;
            }
            return ANY;
        }

        public static Types from(String typeName) {
            if (typeName == null) {
                return STRING;
            }
            typeName = typeName.toUpperCase();
            for (Types type : Types.values()) {
                if (!type.name().startsWith(typeName)) continue;
                return type;
            }
            return STRING;
        }

        public static String inferType(List<?> list) {
            Set set = list.stream().limit(10L).map(e -> Types.of(e).name()).collect(Collectors.toSet());
            return set.size() != 1 ? "ANY" : (String)set.iterator().next();
        }

        static {
            primitivesMapping = new HashMap(){
                {
                    this.put(Double.TYPE, Double.class);
                    this.put(Float.TYPE, Float.class);
                    this.put(Integer.TYPE, Integer.class);
                    this.put(Long.TYPE, Long.class);
                    this.put(Short.TYPE, Short.class);
                    this.put(Boolean.TYPE, Boolean.class);
                }
            };
        }
    }

    public static class ConstraintTracker {
        public static final Map<String, List<String>> relConstraints = new HashMap<String, List<String>>(20);
        public static final Map<String, List<String>> nodeConstraints = new HashMap<String, List<String>>(20);
    }
}

