/*
 * Decompiled with CFR 0.152.
 */
package apoc.neighbors;

import apoc.path.RelationshipTypeAndDirections;
import apoc.result.ListResult;
import apoc.result.LongResult;
import apoc.result.NodeListResult;
import apoc.result.NodeResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class Neighbors {
    @Context
    public Transaction tx;

    private Iterable<Relationship> getRelationshipsByTypeAndDirection(Node node, Pair<RelationshipType, Direction> typesAndDirection) {
        if (typesAndDirection.first() == null) {
            return typesAndDirection.other() == null ? Iterables.empty() : node.getRelationships((Direction)typesAndDirection.other());
        }
        if (typesAndDirection.other() == null) {
            return typesAndDirection.first() == null ? Iterables.empty() : node.getRelationships(new RelationshipType[]{(RelationshipType)typesAndDirection.first()});
        }
        return node.getRelationships((Direction)typesAndDirection.other(), new RelationshipType[]{(RelationshipType)typesAndDirection.first()});
    }

    @Procedure(value="apoc.neighbors.tohop")
    @Description(value="apoc.neighbors.tohop(node, rel-direction-pattern, distance) - returns distinct nodes of the given relationships in the pattern up to a certain distance, can use '>' or '<' for all outgoing or incoming relationships")
    public Stream<NodeResult> neighbors(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        long startNodeId = node.getId();
        Roaring64NavigableMap seen = new Roaring64NavigableMap();
        Roaring64NavigableMap nextA = new Roaring64NavigableMap();
        Roaring64NavigableMap nextB = new Roaring64NavigableMap();
        long nodeId = node.getId();
        seen.addLong(nodeId);
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                nextB.addLong(r.getOtherNodeId(nodeId));
            }
        }
        int i = 1;
        while ((long)i < distance) {
            nextB.andNot(seen);
            seen.or(nextB);
            nextA.clear();
            Iterator iterator = nextB.iterator();
            while (iterator.hasNext()) {
                nodeId = (Long)iterator.next();
                node = this.tx.getNodeById(nodeId);
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        nextA.add(new long[]{r.getOtherNodeId(nodeId)});
                    }
                }
            }
            if ((long)(++i) < distance) {
                nextA.andNot(seen);
                seen.or(nextA);
                nextB.clear();
                iterator = nextA.iterator();
                while (iterator.hasNext()) {
                    nodeId = (Long)iterator.next();
                    node = this.tx.getNodeById(nodeId);
                    for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                        for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                            nextB.add(new long[]{r.getOtherNodeId(nodeId)});
                        }
                    }
                }
            }
            ++i;
        }
        if (distance % 2L == 0L) {
            seen.or(nextA);
        } else {
            seen.or(nextB);
        }
        seen.removeLong(startNodeId);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(seen.iterator(), 4), false).map(x -> new NodeResult(this.tx.getNodeById(x.longValue())));
    }

    @Procedure(value="apoc.neighbors.tohop.count")
    @Description(value="apoc.neighbors.tohop.count(node, rel-direction-pattern, distance) - returns distinct count of nodes of the given relationships in the pattern up to a certain distance, can use '>' or '<' for all outgoing or incoming relationships")
    public Stream<LongResult> neighborsCount(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        long startNodeId = node.getId();
        Roaring64NavigableMap seen = new Roaring64NavigableMap();
        Roaring64NavigableMap nextA = new Roaring64NavigableMap();
        Roaring64NavigableMap nextB = new Roaring64NavigableMap();
        long nodeId = node.getId();
        seen.add(new long[]{nodeId});
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                nextB.add(new long[]{r.getOtherNodeId(nodeId)});
            }
        }
        int i = 1;
        while ((long)i < distance) {
            nextB.andNot(seen);
            seen.or(nextB);
            nextA.clear();
            Iterator iterator = nextB.iterator();
            while (iterator.hasNext()) {
                nodeId = (Long)iterator.next();
                node = this.tx.getNodeById(nodeId);
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        nextA.add(new long[]{r.getOtherNodeId(nodeId)});
                    }
                }
            }
            if ((long)(++i) < distance) {
                nextA.andNot(seen);
                seen.or(nextA);
                nextB.clear();
                iterator = nextA.iterator();
                while (iterator.hasNext()) {
                    nodeId = (Long)iterator.next();
                    node = this.tx.getNodeById(nodeId);
                    for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                        for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                            nextB.add(new long[]{r.getOtherNodeId(nodeId)});
                        }
                    }
                }
            }
            ++i;
        }
        if (distance % 2L == 0L) {
            seen.or(nextA);
        } else {
            seen.or(nextB);
        }
        seen.removeLong(startNodeId);
        return Stream.of(new LongResult(seen.getLongCardinality()));
    }

    @Procedure(value="apoc.neighbors.byhop")
    @Description(value="apoc.neighbors.byhop(node, rel-direction-pattern, distance) - returns distinct nodes of the given relationships in the pattern at each distance, can use '>' or '<' for all outgoing or incoming relationships")
    public Stream<NodeListResult> neighborsByHop(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        Roaring64NavigableMap[] seen = new Roaring64NavigableMap[distance.intValue()];
        int i = 0;
        while ((long)i < distance) {
            seen[i] = new Roaring64NavigableMap();
            ++i;
        }
        long nodeId = node.getId();
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                seen[0].add(new long[]{r.getOtherNodeId(nodeId)});
            }
        }
        int i2 = 1;
        while ((long)i2 < distance) {
            Iterator iterator = seen[i2 - 1].iterator();
            while (iterator.hasNext()) {
                node = this.tx.getNodeById(((Long)iterator.next()).longValue());
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        seen[i2].add(new long[]{r.getOtherNodeId(node.getId())});
                    }
                }
            }
            for (int j = 0; j < i2; ++j) {
                seen[i2].andNot(seen[j]);
                seen[i2].removeLong(nodeId);
            }
            ++i2;
        }
        return Arrays.stream(seen).map(x -> new NodeListResult(StreamSupport.stream(Spliterators.spliteratorUnknownSize(x.iterator(), 4), false).map(y -> this.tx.getNodeById(y.longValue())).collect(Collectors.toList())));
    }

    @Procedure(value="apoc.neighbors.byhop.count")
    @Description(value="apoc.neighbors.byhop.count(node, rel-direction-pattern, distance) - returns distinct nodes of the given relationships in the pattern at each distance, can use '>' or '<' for all outgoing or incoming relationships")
    public Stream<ListResult> neighborsByHopCount(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        Roaring64NavigableMap[] seen = new Roaring64NavigableMap[distance.intValue()];
        int i = 0;
        while ((long)i < distance) {
            seen[i] = new Roaring64NavigableMap();
            ++i;
        }
        long nodeId = node.getId();
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                seen[0].add(new long[]{r.getOtherNodeId(nodeId)});
            }
        }
        int i2 = 1;
        while ((long)i2 < distance) {
            Iterator iterator = seen[i2 - 1].iterator();
            while (iterator.hasNext()) {
                node = this.tx.getNodeById(((Long)iterator.next()).longValue());
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        seen[i2].add(new long[]{r.getOtherNodeId(node.getId())});
                    }
                }
            }
            for (int j = 0; j < i2; ++j) {
                seen[i2].andNot(seen[j]);
                seen[i2].removeLong(nodeId);
            }
            ++i2;
        }
        ArrayList<Object> counts = new ArrayList<Object>();
        int i3 = 0;
        while ((long)i3 < distance) {
            counts.add(seen[i3].getLongCardinality());
            ++i3;
        }
        return Stream.of(new ListResult(counts));
    }

    @Procedure(value="apoc.neighbors.athop")
    @Description(value="apoc.neighbors.athop(node, rel-direction-pattern, distance) - returns distinct nodes of the given relationships in the pattern at a distance, can use '>' or '<' for all outgoing or incoming relationships")
    public Stream<NodeResult> neighborsAtHop(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        Roaring64NavigableMap[] seen = new Roaring64NavigableMap[distance.intValue()];
        int i = 0;
        while ((long)i < distance) {
            seen[i] = new Roaring64NavigableMap();
            ++i;
        }
        long nodeId = node.getId();
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                seen[0].add(new long[]{r.getOtherNodeId(nodeId)});
            }
        }
        int i2 = 1;
        while ((long)i2 < distance) {
            Iterator iterator = seen[i2 - 1].iterator();
            while (iterator.hasNext()) {
                node = this.tx.getNodeById(((Long)iterator.next()).longValue());
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        seen[i2].add(new long[]{r.getOtherNodeId(node.getId())});
                    }
                }
            }
            for (int j = 0; j < i2; ++j) {
                seen[i2].andNot(seen[j]);
                seen[i2].removeLong(nodeId);
            }
            ++i2;
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(seen[distance.intValue() - 1].iterator(), 4), false).map(y -> new NodeResult(this.tx.getNodeById(y.longValue())));
    }

    @Procedure(value="apoc.neighbors.athop.count")
    @Description(value="apoc.neighbors.athop.count(node, rel-direction-pattern, distance) - returns distinct nodes of the given relationships in the pattern at a distance, can use '>' or '<' for all outgoing or incoming relationships")
    public Stream<LongResult> neighborsAtHopCount(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        Roaring64NavigableMap[] seen = new Roaring64NavigableMap[distance.intValue()];
        int i = 0;
        while ((long)i < distance) {
            seen[i] = new Roaring64NavigableMap();
            ++i;
        }
        long nodeId = node.getId();
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                seen[0].add(new long[]{r.getOtherNodeId(nodeId)});
            }
        }
        int i2 = 1;
        while ((long)i2 < distance) {
            Iterator iterator = seen[i2 - 1].iterator();
            while (iterator.hasNext()) {
                node = this.tx.getNodeById(((Long)iterator.next()).longValue());
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        seen[i2].add(new long[]{r.getOtherNodeId(node.getId())});
                    }
                }
            }
            for (int j = 0; j < i2; ++j) {
                seen[i2].andNot(seen[j]);
                seen[i2].removeLong(nodeId);
            }
            ++i2;
        }
        return Stream.of(new LongResult(seen[distance.intValue() - 1].getLongCardinality()));
    }
}

