/*
 * Decompiled with CFR 0.152.
 */
package apoc.periodic;

import apoc.periodic.BatchMode;
import apoc.util.Util;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.internal.helpers.collection.Pair;

public class PeriodicUtils {
    private PeriodicUtils() {
    }

    public static Pair<String, Boolean> prepareInnerStatement(String cypherAction, BatchMode batchMode, List<String> columns, String iteratorVariableName) {
        String names = columns.stream().map(Util::quote).collect(Collectors.joining("|"));
        boolean withCheck = PeriodicUtils.regNoCaseMultiLine("[{$](" + names + ")\\}?\\s+AS\\s+").matcher(cypherAction).find();
        if (withCheck) {
            return Pair.of((Object)cypherAction, (Object)false);
        }
        switch (batchMode) {
            case SINGLE: {
                return Pair.of((Object)(Util.withMapping(columns.stream(), c -> Util.param(c) + " AS " + Util.quote(c)) + cypherAction), (Object)false);
            }
            case BATCH: {
                if (PeriodicUtils.regNoCaseMultiLine("UNWIND\\s+[{$]" + iteratorVariableName + "\\}?\\s+AS\\s+").matcher(cypherAction).find()) {
                    return Pair.of((Object)cypherAction, (Object)true);
                }
                String with = Util.withMapping(columns.stream(), c -> Util.quote(iteratorVariableName) + "." + Util.quote(c) + " AS " + Util.quote(c));
                return Pair.of((Object)("UNWIND " + Util.param(iteratorVariableName) + " AS " + Util.quote(iteratorVariableName) + with + " " + cypherAction), (Object)true);
            }
            case BATCH_SINGLE: {
                return Pair.of((Object)cypherAction, (Object)true);
            }
        }
        throw new IllegalArgumentException("Unrecognised batch mode: [" + batchMode + "]");
    }

    public static Pattern regNoCaseMultiLine(String pattern) {
        return Pattern.compile(pattern, 42);
    }
}

