/*
 * Decompiled with CFR 0.152.
 */
package apoc.text;

import apoc.text.SorensenDiceCoefficient;
import apoc.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.HammingDistance;
import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Strings {
    private static final HammingDistance hammingDistance = new HammingDistance();
    private static final JaroWinklerDistance jaroWinklerDistance = new JaroWinklerDistance();
    private static final LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
    @Context
    public Transaction tx;
    private static Pattern cleanPattern = Pattern.compile("[^\\p{L}\\p{N}]+");
    private static Pattern specialCharPattern = Pattern.compile("\\p{IsM}+");
    private static String[][] UMLAUT_REPLACEMENTS = new String[][]{{new String("\u00c4"), "Ae"}, {new String("\u00dc"), "Ue"}, {new String("\u00d6"), "Oe"}, {new String("\u00e4"), "ae"}, {new String("\u00fc"), "ue"}, {new String("\u00f6"), "oe"}, {new String("\u00df"), "ss"}};
    private static final String lower = "abcdefghijklmnopqrstuvwxyz";
    private static final String upper = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String numeric = "0123456789";

    @UserFunction
    @Description(value="apoc.text.indexOf(text, lookup, from=0, to=-1==len) - find the first occurence of the lookup string in the text, from inclusive, to exclusive, -1 if not found, null if text is null.")
    public Long indexOf(@Name(value="text") String text, @Name(value="lookup") String lookup, @Name(value="from", defaultValue="0") long from, @Name(value="to", defaultValue="-1") long to) {
        if (text == null) {
            return null;
        }
        if (lookup == null) {
            return -1L;
        }
        if (to == -1L || to > (long)text.length()) {
            return text.indexOf(lookup, (int)from);
        }
        if (to <= from) {
            return -1L;
        }
        return text.substring(0, (int)to).indexOf(lookup, (int)from);
    }

    @UserFunction
    @Description(value="apoc.text.indexesOf(text, lookup, from=0, to=-1==len) - finds all occurences of the lookup string in the text, return list, from inclusive, to exclusive, empty list if not found, null if text is null.")
    public List<Long> indexesOf(@Name(value="text") String text, @Name(value="lookup") String lookup, @Name(value="from", defaultValue="0") long from, @Name(value="to", defaultValue="-1") long to) {
        if (text == null) {
            return null;
        }
        if (lookup == null) {
            return Collections.emptyList();
        }
        if (to == -1L) {
            to = text.length();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        int idx = (int)from - 1;
        while ((idx = text.indexOf(lookup, idx + 1)) != -1 && (long)idx < to) {
            result.add(Long.valueOf(idx));
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.text.replace(text, regex, replacement) - replace each substring of the given string that matches the given regular expression with the given replacement.")
    public String replace(@Name(value="text") String text, @Name(value="regex") String regex, @Name(value="replacement") String replacement) {
        return this.regreplace(text, regex, replacement);
    }

    @UserFunction
    @Description(value="apoc.text.byteCount(text,[charset]) - return size of text in bytes")
    public long byteCount(@Name(value="text") String text, @Name(value="charset", defaultValue="UTF-8") String charset) throws UnsupportedEncodingException {
        return text.getBytes(charset).length;
    }

    @UserFunction
    @Description(value="apoc.text.bytes(text,[charset]) - return bytes of the text")
    public List<Long> bytes(@Name(value="text") String text, @Name(value="charset", defaultValue="UTF-8") String charset) throws UnsupportedEncodingException {
        return Util.convertFromBytesToList(text.getBytes(charset));
    }

    @UserFunction
    @Description(value="apoc.text.regreplace(text, regex, replacement) - replace each substring of the given string that matches the given regular expression with the given replacement.")
    public String regreplace(@Name(value="text") String text, @Name(value="regex") String regex, @Name(value="replacement") String replacement) {
        if (text == null || regex == null || replacement == null) {
            return null;
        }
        return text.replaceAll(regex, replacement);
    }

    @UserFunction
    @Description(value="apoc.text.split(text, regex, limit) - splits the given text around matches of the given regex.")
    public List<String> split(@Name(value="text") String text, @Name(value="regex") String regex, @Name(value="limit", defaultValue="0") Long limit) {
        if (text == null || regex == null || limit == null) {
            return null;
        }
        String[] resultArray = text.split(regex, limit.intValue());
        return new ArrayList<String>(Arrays.asList(resultArray));
    }

    @UserFunction
    @Description(value="apoc.text.regexGroups(text, regex) - return all matching groups of the regex on the given text.")
    public List<List<String>> regexGroups(@Name(value="text") String text, @Name(value="regex") String regex) {
        if (text == null || regex == null) {
            return Collections.EMPTY_LIST;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        while (matcher.find()) {
            ArrayList<String> matchResult = new ArrayList<String>();
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                matchResult.add(matcher.group(i));
            }
            result.add(matchResult);
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.text.join(['text1','text2',...], delimiter) - join the given strings with the given delimiter.")
    public String join(@Name(value="texts") List<String> texts, @Name(value="delimiter") String delimiter) {
        if (texts == null || delimiter == null) {
            return null;
        }
        return String.join((CharSequence)delimiter, texts);
    }

    @UserFunction
    @Description(value="apoc.text.clean(text) - strip the given string of everything except alpha numeric characters and convert it to lower case.")
    public String clean(@Name(value="text") String text) {
        return text == null ? null : Strings.removeNonWordCharacters(text);
    }

    @UserFunction
    @Description(value="apoc.text.compareCleaned(text1, text2) - compare the given strings stripped of everything except alpha numeric characters converted to lower case.")
    public boolean compareCleaned(@Name(value="text1") String text1, @Name(value="text2") String text2) {
        if (text1 == null || text2 == null) {
            return false;
        }
        return Strings.removeNonWordCharacters(text1).equals(Strings.removeNonWordCharacters(text2));
    }

    @UserFunction
    @Description(value="apoc.text.distance(text1, text2) - compare the given strings with the Levenshtein distance algorithm.")
    public Long distance(@Name(value="text1") String text1, @Name(value="text2") String text2) {
        return this.levenshteinDistance(text1, text2);
    }

    @UserFunction
    @Description(value="apoc.text.levenshteinDistance(text1, text2) - compare the given strings with the Levenshtein distance algorithm.")
    public Long levenshteinDistance(@Name(value="text1") String text1, @Name(value="text2") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        return (long)levenshteinDistance.apply((CharSequence)text1, (CharSequence)text2);
    }

    @UserFunction
    @Description(value="apoc.text.levenshteinSimilarity(text1, text2) - calculate the similarity (a value within 0 and 1) between two texts.")
    public Double levenshteinSimilarity(@Name(value="text1") String text1, @Name(value="text2") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        int longerLength = Math.max(text1.length(), text2.length());
        if (longerLength == 0) {
            return 1.0;
        }
        long editDistance = this.distance(text1, text2);
        return (double)((long)longerLength - editDistance) / (double)longerLength;
    }

    @UserFunction
    @Description(value="apoc.text.hammingDistance(text1, text2) - compare the given strings with the Hamming distance algorithm.")
    public Long hammingDistance(@Name(value="text1") String text1, @Name(value="text2") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        return (long)hammingDistance.apply((CharSequence)text1, (CharSequence)text2);
    }

    @UserFunction
    @Description(value="apoc.text.jaroWinklerDistance(text1, text2) - compare the given strings with the Jaro-Winkler distance algorithm.")
    public Double jaroWinklerDistance(@Name(value="text1") String text1, @Name(value="text2") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        return jaroWinklerDistance.apply((CharSequence)text1, (CharSequence)text2);
    }

    @UserFunction
    @Description(value="apoc.text.sorensenDiceSimilarityWithLanguage(text1, text2, languageTag) - compare the given strings with the S\u00f8rensen\u2013Dice coefficient formula, with the provided IETF language tag")
    public Double sorensenDiceSimilarity(@Name(value="text1") String text1, @Name(value="text2") String text2, @Name(value="languageTag", defaultValue="en") String languageTag) {
        if (text1 == null || text2 == null || languageTag == null) {
            return null;
        }
        return SorensenDiceCoefficient.compute(text1, text2, languageTag);
    }

    @UserFunction
    @Description(value="apoc.text.fuzzyMatch(text1, text2) - check if 2 words can be matched in a fuzzy way. Depending on the length of the String it will allow more characters that needs to be edited to match the second String.")
    public Boolean fuzzyMatch(@Name(value="text1") String text1, @Name(value="text2") String text2) {
        if (text1 == null || text2 == null) {
            return null;
        }
        int termLength = text1.length();
        int maxDistanceAllowed = termLength < 3 ? 0 : (termLength < 5 ? 1 : 2);
        Long distance = this.distance(text1, text2);
        return distance <= (long)maxDistanceAllowed;
    }

    @UserFunction
    @Description(value="apoc.text.urlencode(text) - return the urlencoded text")
    public String urlencode(@Name(value="text") String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("urlencoding failed", e);
        }
    }

    @UserFunction
    @Description(value="apoc.text.urldecode(text) - return the urldecoded text")
    public String urldecode(@Name(value="text") String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("urldecoding failed", e);
        }
    }

    private static String removeNonWordCharacters(String s) {
        String result = s;
        for (int i = 0; i < UMLAUT_REPLACEMENTS.length; ++i) {
            result = result.replace(UMLAUT_REPLACEMENTS[i][0], UMLAUT_REPLACEMENTS[i][1]);
        }
        result = Normalizer.normalize(result, Normalizer.Form.NFD);
        String tmp2 = specialCharPattern.matcher(result).replaceAll("");
        return cleanPattern.matcher(tmp2).replaceAll("").toLowerCase();
    }

    @UserFunction
    @Description(value="apoc.text.lpad(text,count,delim) YIELD value - left pad the string to the given width")
    public String lpad(@Name(value="text") String text, @Name(value="count") long count, @Name(value="delim", defaultValue=" ") String delim) {
        int len = text.length();
        if ((long)len >= count) {
            return text;
        }
        StringBuilder sb = new StringBuilder((int)count);
        char[] chars = new char[(int)count - len];
        Arrays.fill(chars, delim.charAt(0));
        sb.append(chars);
        sb.append(text);
        return sb.toString();
    }

    @UserFunction
    @Description(value="apoc.text.rpad(text,count,delim) YIELD value - right pad the string to the given width")
    public String rpad(@Name(value="text") String text, @Name(value="count") long count, @Name(value="delim", defaultValue=" ") String delim) {
        int len = text.length();
        if ((long)len >= count) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        char[] chars = new char[(int)count - len];
        Arrays.fill(chars, delim.charAt(0));
        sb.append(chars);
        return sb.toString();
    }

    @UserFunction
    @Description(value="apoc.text.format(text,[params],language) - sprintf format the string with the params given")
    public String format(@Name(value="text") String text, @Name(value="params") List<Object> params, @Name(value="language", defaultValue="en") String lang) {
        if (text == null) {
            return null;
        }
        if (params == null) {
            return text;
        }
        return String.format(new Locale(lang), text, params.toArray());
    }

    @UserFunction
    @Description(value="apoc.text.slug(text, delim) - slug the text with the given delimiter")
    public String slug(@Name(value="text") String text, @Name(value="delim", defaultValue="-") String delim) {
        if (text == null) {
            return null;
        }
        if (delim == null) {
            return null;
        }
        return text.trim().replaceAll("[^\\p{L}0-9_]+", delim);
    }

    @UserFunction
    @Description(value="apoc.text.random(length, valid) YIELD value - generate a random string")
    public String random(@Name(value="length") long length, @Name(value="valid", defaultValue="A-Za-z0-9") String valid) {
        valid = valid.replaceAll("A-Z", upper).replaceAll("a-z", lower).replaceAll("0-9", numeric);
        StringBuilder output = new StringBuilder(Math.toIntExact(length));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        while ((long)output.length() < length) {
            output.append(valid.charAt(rand.nextInt(valid.length())));
        }
        return output.toString();
    }

    @UserFunction
    @Description(value="apoc.text.capitalize(text) YIELD value - capitalise the first letter of the word")
    public String capitalize(@Name(value="text") String text) {
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }

    @UserFunction
    @Description(value="apoc.text.capitalizeAll(text) YIELD value - capitalise the first letter of every word in the text")
    public String capitalizeAll(@Name(value="text") String text) {
        String[] parts = text.split(" ");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            output.append(StringUtils.capitalize((String)part) + " ");
        }
        return output.toString().trim();
    }

    @UserFunction
    @Description(value="apoc.text.decapitalize(text) YIELD value - decapitalize the first letter of the word")
    public String decapitalize(@Name(value="text") String text) {
        return StringUtils.uncapitalize((String)text);
    }

    @UserFunction
    @Description(value="apoc.text.decapitalizeAll(text) YIELD value - decapitalize the first letter of all words")
    public String decapitalizeAll(@Name(value="text") String text) {
        String[] parts = text.split(" ");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            output.append(StringUtils.uncapitalize((String)part) + " ");
        }
        return output.toString().trim();
    }

    @UserFunction
    @Description(value="apoc.text.swapCase(text) YIELD value - Swap the case of a string")
    public String swapCase(@Name(value="text") String text) {
        return StringUtils.swapCase((String)text);
    }

    @UserFunction
    @Description(value="apoc.text.camelCase(text) YIELD value - Convert a string to camelCase")
    public String camelCase(@Name(value="text") String text) {
        text = text.replaceAll("[^\\p{L}0-9]|_", " ");
        String[] parts = text.split("(\\s+)");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            part = part.toLowerCase();
            output.append(StringUtils.capitalize((String)part));
        }
        return output.substring(0, 1).toLowerCase() + output.substring(1);
    }

    @UserFunction
    @Description(value="apoc.text.upperCamelCase(text) YIELD value - Convert a string to camelCase")
    public String upperCamelCase(@Name(value="text") String text) {
        String output = this.camelCase(text);
        return output.substring(0, 1).toUpperCase() + output.substring(1);
    }

    @UserFunction
    @Description(value="apoc.text.snakeCase(text) YIELD value - Convert a string to snake-case")
    public String snakeCase(@Name(value="text") String text) {
        if (text.matches("^([\\p{Lu}0-9_]+)$")) {
            text = text.toLowerCase().replace("_", " ");
        }
        String[] parts = text.split("(?=[^\\p{Ll}0-9])");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            if ((part = part.trim()).length() <= 0) continue;
            if (output.length() > 0) {
                output.append("-");
            }
            output.append(part.toLowerCase().trim().replace("(^[\\p{Ll}0-9]+)", "-"));
        }
        return output.toString().toLowerCase().replaceAll("--", "-");
    }

    @UserFunction
    @Description(value="apoc.text.toUpperCase(text) YIELD value - Convert a string to UPPER_CASE")
    public String toUpperCase(@Name(value="text") String text) {
        String[] parts = text.split("(?=[^a-z0-9]+)");
        StringBuilder output = new StringBuilder();
        for (String part : parts) {
            if ((part = part.trim().toUpperCase().replaceAll("[^A-Z0-9]+", "")).length() <= 0) continue;
            if (output.length() > 0) {
                output.append("_");
            }
            output.append(part);
        }
        return output.toString();
    }

    @UserFunction
    @Description(value="apoc.text.base64Encode(text) YIELD value - Encode a string with Base64")
    public String base64Encode(@Name(value="text") String text) {
        byte[] encoded = Base64.getEncoder().encode(text.getBytes());
        return new String(encoded);
    }

    @UserFunction
    @Description(value="apoc.text.base64Decode(text) YIELD value - Decode Base64 encoded string")
    public String base64Decode(@Name(value="text") String text) {
        byte[] decoded = Base64.getDecoder().decode(text.getBytes());
        return new String(decoded);
    }

    @UserFunction
    @Description(value="apoc.text.base64UrlEncode(text) YIELD value - Encode a url with Base64")
    public String base64UrlEncode(@Name(value="url") String url) {
        byte[] encoded = Base64.getUrlEncoder().encode(url.getBytes());
        return new String(encoded);
    }

    @UserFunction
    @Description(value="apoc.text.base64UrlDecode(url) YIELD value - Decode Base64 encoded url")
    public String base64UrlDecode(@Name(value="url") String url) {
        byte[] decoded = Base64.getUrlDecoder().decode(url.getBytes());
        return new String(decoded);
    }

    @UserFunction
    @Description(value="apoc.text.charAt(text, index) - the decimal value of the character at the given index")
    public Long charAt(@Name(value="text") String text, @Name(value="index") Long index) {
        if (index == null || text == null || text.isEmpty() || index < 0L || index >= (long)text.length()) {
            return null;
        }
        return text.charAt(index.intValue());
    }

    @UserFunction
    @Description(value="apoc.text.code(codepoint) - Returns the unicode character of the given codepoint")
    public String code(@Name(value="codepoint") Long codepoint) {
        if (codepoint == null || codepoint < 0L || codepoint > 65535L) {
            return null;
        }
        return String.valueOf((char)codepoint.intValue());
    }

    @UserFunction
    @Description(value="apoc.text.hexValue(value) - the hex value string of the given number")
    public String hexValue(@Name(value="value") Long value) {
        if (value == null) {
            return null;
        }
        return value > 0xFFFFFFFFL ? String.format("%016X", value) : (value > 65535L ? String.format("%08X", value.intValue()) : String.format("%04X", value.intValue()));
    }

    @UserFunction
    @Description(value="apoc.text.hexCharAt(text, index) - the hex value string of the character at the given index")
    public String hexCharAt(@Name(value="text") String text, @Name(value="index") Long index) {
        return this.hexValue(this.charAt(text, index));
    }

    private boolean isPrimitive(Object value) {
        return value == null || value instanceof String || value instanceof Number || value instanceof Boolean;
    }

    private String cypherName(Map<String, Object> config, String key, Supplier<String> s, Function<String, String> quoter) {
        Object name = config.get(key);
        if (name != null) {
            return quoter.apply(name.toString());
        }
        return s.get();
    }

    @UserFunction
    @Description(value="apoc.text.toCypher(value, {skipKeys,keepKeys,skipValues,keepValues,skipNull,node,relationship,start,end}) | tries it's best to convert the value to a cypher-property-string")
    public String toCypher(@Name(value="value") Object value, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (config.containsKey("keepValues") && !((Collection)config.get("keepValues")).stream().noneMatch(v -> (v.getClass().isInstance(value) || this.isPrimitive(value) && this.isPrimitive(v)) && !value.equals(v))) {
            return null;
        }
        if (config.containsKey("skipValues") && ((Collection)config.get("skipValues")).contains(value)) {
            return null;
        }
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof String) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof Iterable) {
            return "[" + StreamSupport.stream(((Iterable)value).spliterator(), false).map(v -> this.toCypher(v, config)).filter(Objects::nonNull).collect(Collectors.joining(",")) + "]";
        }
        if (value.getClass().isArray()) {
            return "[" + Arrays.stream((Object[])value).map(v -> this.toCypher(v, config)).filter(Objects::nonNull).collect(Collectors.joining(",")) + "]";
        }
        if (value instanceof Node) {
            Node node = Util.rebind(this.tx, (Node)value);
            Object labels2 = StreamSupport.stream(node.getLabels().spliterator(), false).map(l -> Util.quote(l.name())).collect(Collectors.joining(":"));
            if (!((String)labels2).isEmpty()) {
                labels2 = ":" + (String)labels2;
            }
            String var = this.cypherName(config, "node", () -> "", Util::quote);
            return "(" + var + (String)labels2 + " " + this.toCypher(node.getAllProperties(), config) + ")";
        }
        if (value instanceof Relationship) {
            Relationship rel = Util.rebind(this.tx, (Relationship)value);
            String type = ":" + Util.quote(rel.getType().name());
            String start = this.cypherName(config, "start", () -> this.toCypher(rel.getStartNode(), config), s -> "(" + Util.quote(s) + ")");
            String relationship = this.cypherName(config, "relationship", () -> "", Util::quote);
            String end = this.cypherName(config, "end", () -> this.toCypher(rel.getEndNode(), config), s -> "(" + Util.quote(s) + ")");
            return start + "-[" + relationship + type + " " + this.toCypher(rel.getAllProperties(), config) + "]->" + end;
        }
        if (value instanceof Map) {
            Map values = (Map)value;
            if (config.containsKey("keepKeys")) {
                values.keySet().retainAll((List)config.get("keepKeys"));
            }
            if (config.containsKey("skipKeys")) {
                values.keySet().removeAll((List)config.get("skipKeys"));
            }
            return "{" + values.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()), (Object)this.toCypher(e.getValue(), config))).filter(p -> p.other() != null).sorted(Comparator.comparing(Pair::first)).map(p -> Util.quote((String)p.first()) + ":" + (String)p.other()).collect(Collectors.joining(",")) + "}";
        }
        return null;
    }

    @UserFunction
    @Description(value="apoc.text.repeat(item, count) - string multiplication")
    public String repeat(@Name(value="item") String item, @Name(value="count") long count) {
        StringBuilder result = new StringBuilder((int)count * item.length());
        int i = 0;
        while ((long)i < count) {
            result.append(item);
            ++i;
        }
        return result.toString();
    }
}

