/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.FileUtils;
import apoc.util.Util;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class ApocUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static URLStreamHandlerFactory s3StreamHandlerFactory = (URLStreamHandlerFactory)Util.createInstanceOrNull("apoc.util.s3.S3UrlStreamHandlerFactory");
    private static URLStreamHandlerFactory gsStreamHandlerFactory = (URLStreamHandlerFactory)Util.createInstanceOrNull("apoc.util.google.cloud.GCStorageURLStreamHandlerFactory");
    private static URLStreamHandlerFactory hdfsStreamHandlerFactory = (URLStreamHandlerFactory)Util.createInstanceOrNull("org.apache.hadoop.fs.FsUrlStreamHandlerFactory");

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (FileUtils.S3_ENABLED && "s3".equalsIgnoreCase(protocol)) {
            return s3StreamHandlerFactory.createURLStreamHandler(protocol);
        }
        if (FileUtils.HDFS_ENABLED && "hdfs".equalsIgnoreCase(protocol)) {
            return hdfsStreamHandlerFactory.createURLStreamHandler(protocol);
        }
        if (FileUtils.GCS_ENABLED && "gs".equalsIgnoreCase(protocol)) {
            return gsStreamHandlerFactory.createURLStreamHandler(protocol);
        }
        return null;
    }
}

