/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.exceptions.KernelException;
import org.neo4j.kernel.api.procedure.GlobalProcedures;

class HarnessRegisteredProcs {
    private final List<Class<?>> procs = new ArrayList();
    private final List<Class<?>> functions = new ArrayList();
    private final List<Class<?>> aggregationFunctions = new ArrayList();

    HarnessRegisteredProcs() {
    }

    void addProcedure(Class<?> procedureClass) {
        this.procs.add(procedureClass);
    }

    void addFunction(Class<?> functionClass) {
        this.functions.add(functionClass);
    }

    void addAggregationFunction(Class<?> functionClass) {
        this.aggregationFunctions.add(functionClass);
    }

    void applyTo(GlobalProcedures globalProcedures) throws KernelException {
        for (Class<?> cls : this.procs) {
            globalProcedures.registerProcedure(cls);
        }
        for (Class<?> cls : this.functions) {
            globalProcedures.registerFunction(cls);
        }
        for (Class<?> cls : this.aggregationFunctions) {
            globalProcedures.registerAggregationFunction(cls);
        }
    }
}

