/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;

public class ExtractTool {
    private static void writeWarcHeaders(WritableByteChannel out, WarcRecord record) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(record.version().toString()).append("\r\n");
        record.headers().appendTo(sb);
        sb.append("\r\n");
        out.write(ByteBuffer.wrap(sb.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private static void writeHttpHeaders(WritableByteChannel out, WarcRecord record) throws IOException {
        if (record instanceof WarcResponse) {
            HttpResponse response = ((WarcResponse)record).http();
            out.write(ByteBuffer.wrap(response.serializeHeader()));
        } else if (record instanceof WarcRequest) {
            HttpRequest request = ((WarcRequest)record).http();
            out.write(ByteBuffer.wrap(request.serializeHeader()));
        }
    }

    private static void writePayload(WritableByteChannel out, WarcRecord record) throws IOException {
        MessageBody payload;
        List<Object> contentEncodings = Collections.emptyList();
        if (record instanceof WarcResponse) {
            HttpResponse response = ((WarcResponse)record).http();
            payload = response.body();
            contentEncodings = response.headers().all("Content-Encoding");
        } else if (record instanceof WarcRequest) {
            HttpRequest request = ((WarcRequest)record).http();
            payload = request.body();
            contentEncodings = request.headers().all("Content-Encoding");
        } else {
            payload = record.body();
        }
        if (contentEncodings.isEmpty()) {
            ExtractTool.writeBody(out, payload);
        } else if (contentEncodings.size() > 1) {
            System.err.println("Multiple Content-Encodings not supported: " + contentEncodings);
        } else if (((String)contentEncodings.get(0)).equalsIgnoreCase("identity") || ((String)contentEncodings.get(0)).equalsIgnoreCase("none")) {
            ExtractTool.writeBody(out, payload);
        } else if (((String)contentEncodings.get(0)).equalsIgnoreCase("gzip") || ((String)contentEncodings.get(0)).equalsIgnoreCase("x-gzip")) {
            ExtractTool.writeBody(out, IOUtils.gunzipChannel(payload));
        } else if (((String)contentEncodings.get(0)).equalsIgnoreCase("deflate")) {
            ExtractTool.writeBody(out, IOUtils.inflateChannel(payload));
        } else {
            System.err.println("Content-Encoding not supported: " + (String)contentEncodings.get(0));
        }
    }

    private static void writeBody(WritableByteChannel out, ReadableByteChannel body) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        while (body.read(buffer) > -1) {
            buffer.flip();
            out.write(buffer);
            buffer.compact();
        }
    }

    private static void usage(int exitValue) {
        System.err.println("");
        System.err.println("ExtractTool [-h] [--payload | --headers] filename offset");
        System.err.println("");
        System.err.println("Options:");
        System.err.println("");
        System.err.println(" --headers\toutput only record (and HTTP) headers");
        System.err.println(" --payload\toutput only record payload, if necessary");
        System.err.println("          \tdecode transfer and/or content encoding");
        System.exit(exitValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws IOException {
        ExtractAction action = ExtractAction.RECORD;
        Path warcFile = null;
        long offset = -1L;
        String[] stringArray = args;
        int n = stringArray.length;
        block36: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "-h": 
                case "--help": {
                    ExtractTool.usage(0);
                }
                case "--headers": {
                    action = ExtractAction.HEADERS;
                    continue block36;
                }
                case "--payload": {
                    action = ExtractAction.PAYLOAD;
                    continue block36;
                }
                default: {
                    if (warcFile == null) {
                        warcFile = Paths.get(arg, new String[0]);
                        if (warcFile.toFile().canRead()) continue block36;
                        System.err.println("Cannot read WARC file: " + warcFile);
                        ExtractTool.usage(1);
                        continue block36;
                    }
                    if (offset == -1L) {
                        try {
                            offset = Long.parseLong(arg);
                        }
                        catch (NumberFormatException e) {
                            System.err.println(e.getMessage());
                            ExtractTool.usage(1);
                        }
                        continue block36;
                    }
                    System.err.println("Unknown argument: " + arg);
                    ExtractTool.usage(1);
                }
            }
        }
        if (warcFile == null || offset == -1L) {
            ExtractTool.usage(1);
        }
        try (FileChannel channel = FileChannel.open(warcFile, new OpenOption[0]);
             WarcReader reader = new WarcReader(channel.position(offset));){
            Optional<WarcRecord> record = reader.next();
            if (!record.isPresent()) {
                System.err.println("No record found at position " + offset);
                System.exit(1);
            }
            WritableByteChannel out = Channels.newChannel(System.out);
            switch (action) {
                case RECORD: {
                    ExtractTool.writeWarcHeaders(out, record.get());
                    ExtractTool.writeBody(out, record.get().body());
                    return;
                }
                case HEADERS: {
                    ExtractTool.writeWarcHeaders(out, record.get());
                    ExtractTool.writeHttpHeaders(out, record.get());
                    return;
                }
                case PAYLOAD: {
                    ExtractTool.writePayload(out, record.get());
                    return;
                }
            }
            return;
        }
    }

    private static enum ExtractAction {
        RECORD,
        HEADERS,
        PAYLOAD;

    }
}

