/*
 * Decompiled with CFR 0.152.
 */
package ninja.migrations;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import ninja.lifecycle.Start;
import ninja.migrations.MigrationEngine;
import ninja.utils.NinjaProperties;

@Singleton
public class MigrationInitializer {
    private final Provider<MigrationEngine> migrationEngineProvider;
    private final NinjaProperties ninjaProperties;

    @Inject
    public MigrationInitializer(NinjaProperties ninjaProperties, Provider<MigrationEngine> migrationEngineProvider) {
        this.ninjaProperties = ninjaProperties;
        this.migrationEngineProvider = migrationEngineProvider;
    }

    @Start(order=9)
    public void start() {
        Boolean runMigrations = this.ninjaProperties.getBoolean("ninja.migration.run");
        if (runMigrations != null && runMigrations.booleanValue()) {
            ((MigrationEngine)this.migrationEngineProvider.get()).migrate();
        }
    }
}

