/*
 * Decompiled with CFR 0.152.
 */
package ninja.migrations.flyway;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import ninja.migrations.MigrationEngine;
import ninja.utils.NinjaProperties;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;

@Singleton
public class MigrationEngineFlyway
implements MigrationEngine {
    private final NinjaProperties ninjaProperties;
    private final Provider<FluentConfiguration> fluentConfigurationProvider;

    @Inject
    public MigrationEngineFlyway(NinjaProperties ninjaProperties, Provider<FluentConfiguration> fluentConfigurationProvider) {
        this.ninjaProperties = ninjaProperties;
        this.fluentConfigurationProvider = fluentConfigurationProvider;
    }

    @Override
    public void migrate() {
        String connectionUrl = this.ninjaProperties.getOrDie("db.connection.url");
        String connectionUsername = this.ninjaProperties.getOrDie("db.connection.username");
        String connectionPassword = this.ninjaProperties.getOrDie("db.connection.password");
        String locations = this.ninjaProperties.get("ninja.migration.locations");
        String schemas = this.ninjaProperties.get("ninja.migration.schemas");
        FluentConfiguration fluentConfiguration = (FluentConfiguration)this.fluentConfigurationProvider.get();
        if (schemas != null) {
            fluentConfiguration.schemas(new String[]{schemas});
        }
        if (locations != null) {
            fluentConfiguration.locations(new String[]{locations});
        }
        Flyway flyway = fluentConfiguration.dataSource(connectionUrl, connectionUsername, connectionPassword).load();
        if (this.ninjaProperties.getBooleanWithDefault("ninja.migration.drop", Boolean.valueOf(this.ninjaProperties.isTest())).booleanValue()) {
            flyway.clean();
        }
        flyway.migrate();
    }
}

