/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.inject.Injector;
import java.net.URI;
import ninja.utils.NinjaTestBrowser;
import ninja.utils.NinjaTestServer;
import org.junit.After;
import org.junit.Before;

public class NinjaTest {
    private NinjaTestServer ninjaTestServer;
    protected NinjaTestBrowser ninjaTestBrowser;

    @Before
    public final void startupServerAndBrowser() {
        this.ninjaTestServer = NinjaTestServer.builder().build();
        this.ninjaTestBrowser = new NinjaTestBrowser();
    }

    protected Injector getInjector() {
        return this.ninjaTestServer.getInjector();
    }

    protected <T> T getInstance(Class<T> type) {
        return (T)this.ninjaTestServer.getInjector().getInstance(type);
    }

    protected String to(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path was null");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must start with '/'");
        }
        return this.ninjaTestServer.getBaseUrl() + path;
    }

    public String getServerAddress() {
        return this.ninjaTestServer.getServerAddress();
    }

    public URI getServerAddressAsUri() {
        return this.ninjaTestServer.getServerAddressAsUri();
    }

    @After
    public final void shutdownServerAndBrowser() {
        if (this.ninjaTestServer != null) {
            this.ninjaTestServer.shutdown();
        }
        if (this.ninjaTestBrowser != null) {
            this.ninjaTestBrowser.shutdown();
        }
    }
}

