/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import ninja.standalone.Standalone;
import ninja.standalone.StandaloneHelper;
import ninja.utils.NinjaMode;

public class NinjaTestServer
implements Closeable {
    private final Standalone<Standalone> standalone;

    public static Builder builder() {
        return new Builder();
    }

    private NinjaTestServer(NinjaMode ninjaMode, Class<? extends Standalone> standaloneClass, int port, Optional<Module> overrideModuleOpt, Optional<Map<String, String>> overridePropertiesOpt) {
        this.standalone = StandaloneHelper.create(standaloneClass);
        try {
            this.standalone.port(port).ninjaMode(ninjaMode);
            if (overrideModuleOpt.isPresent()) {
                this.standalone.overrideModule(overrideModuleOpt.get());
            }
            if (overridePropertiesOpt.isPresent()) {
                this.standalone.overrideProperties(overridePropertiesOpt.get());
            }
            this.standalone.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public NinjaTestServer ninjaMode(NinjaMode ninjaMode) {
        this.standalone.ninjaMode(ninjaMode);
        return this;
    }

    @Deprecated
    public NinjaMode getNinjaMode() {
        return this.standalone.getNinjaMode();
    }

    public Injector getInjector() {
        return this.standalone.getInjector();
    }

    public String getServerUrl() {
        return (String)this.standalone.getServerUrls().get(0);
    }

    public String getBaseUrl() {
        return (String)this.standalone.getBaseUrls().get(0);
    }

    @Deprecated
    public String getServerAddress() {
        return (String)this.standalone.getServerUrls().get(0) + "/";
    }

    @Deprecated
    public URI getServerAddressAsUri() {
        try {
            return new URI(this.getServerAddress());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void shutdown() {
        this.standalone.shutdown();
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public static class Builder {
        private Optional<NinjaMode> ninjaModeOpt = Optional.empty();
        private Optional<Integer> portOpt = Optional.empty();
        private Optional<Class<? extends Standalone>> standaloneClassOpt = Optional.empty();
        private Optional<Module> overrideModuleOpt = Optional.empty();
        private Optional<Map<String, String>> overrideProperties = Optional.empty();

        private Builder() {
        }

        public Builder ninjaMode(NinjaMode ninjaMode) {
            Preconditions.checkNotNull((Object)ninjaMode);
            this.ninjaModeOpt = Optional.of(ninjaMode);
            return this;
        }

        public Builder port(Integer port) {
            Preconditions.checkNotNull((Object)port);
            this.portOpt = Optional.of(port);
            return this;
        }

        public Builder standaloneClass(Class<? extends Standalone> standaloneClass) {
            Preconditions.checkNotNull(standaloneClass);
            this.standaloneClassOpt = Optional.of(standaloneClass);
            return this;
        }

        public Builder overrideModule(Module overrideModule) {
            Preconditions.checkNotNull((Object)overrideModule);
            this.overrideModuleOpt = Optional.of(overrideModule);
            return this;
        }

        public Builder overrideProperties(Map<String, String> overrideProperties) {
            Preconditions.checkNotNull(overrideProperties);
            this.overrideProperties = Optional.of(overrideProperties);
            return this;
        }

        public NinjaTestServer build() {
            Class standaloneClass = this.standaloneClassOpt.orElseGet(() -> StandaloneHelper.resolveStandaloneClass());
            Integer port = this.portOpt.orElseGet(() -> StandaloneHelper.findAvailablePort((int)1000, (int)10000));
            NinjaMode ninjaMode = this.ninjaModeOpt.orElseGet(() -> NinjaMode.test);
            return new NinjaTestServer(ninjaMode, standaloneClass, port, this.overrideModuleOpt, this.overrideProperties);
        }
    }
}

