/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBKDF2KeyImpl;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

public final class PBKDF2HmacSHA1Factory
extends SecretKeyFactorySpi {
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        PBEKeySpec ks = (PBEKeySpec)keySpec;
        return new PBKDF2KeyImpl(ks, "HmacSHA1");
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpecCl) throws InvalidKeySpecException {
        if (key instanceof PBEKey) {
            if (keySpecCl != null && PBEKeySpec.class.isAssignableFrom(keySpecCl)) {
                PBEKey pKey = (PBEKey)key;
                return new PBEKeySpec(pKey.getPassword(), pKey.getSalt(), pKey.getIterationCount(), pKey.getEncoded().length * 8);
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key != null && key.getAlgorithm().equalsIgnoreCase("PBKDF2WithHmacSHA1") && key.getFormat().equalsIgnoreCase("RAW")) {
            if (key instanceof PBKDF2KeyImpl) {
                return key;
            }
            if (key instanceof PBEKey) {
                PBEKey pKey = (PBEKey)key;
                try {
                    PBEKeySpec spec = new PBEKeySpec(pKey.getPassword(), pKey.getSalt(), pKey.getIterationCount(), pKey.getEncoded().length * 8);
                    return new PBKDF2KeyImpl(spec, "HmacSHA1");
                }
                catch (InvalidKeySpecException re) {
                    InvalidKeyException ike = new InvalidKeyException("Invalid key component(s)");
                    ike.initCause(re);
                    throw ike;
                }
            }
        }
        throw new InvalidKeyException("Invalid key format/algorithm");
    }
}

