/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public final class AclEntry {
    private final AclEntryType type;
    private final UserPrincipal who;
    private final Set<AclEntryPermission> perms;
    private final Set<AclEntryFlag> flags;
    private volatile int hash;

    private AclEntry(AclEntryType type, UserPrincipal who, Set<AclEntryPermission> perms, Set<AclEntryFlag> flags) {
        this.type = type;
        this.who = who;
        this.perms = perms;
        this.flags = flags;
    }

    public static Builder newBuilder() {
        Set perms = Collections.emptySet();
        Set flags = Collections.emptySet();
        return new Builder(null, null, perms, flags);
    }

    public static Builder newBuilder(AclEntry entry) {
        return new Builder(entry.type, entry.who, entry.perms, entry.flags);
    }

    public AclEntryType type() {
        return this.type;
    }

    public UserPrincipal principal() {
        return this.who;
    }

    public Set<AclEntryPermission> permissions() {
        return new HashSet<AclEntryPermission>(this.perms);
    }

    public Set<AclEntryFlag> flags() {
        return new HashSet<AclEntryFlag>(this.flags);
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (ob == null || !(ob instanceof AclEntry)) {
            return false;
        }
        AclEntry other = (AclEntry)ob;
        if (this.type != other.type) {
            return false;
        }
        if (!this.who.equals(other.who)) {
            return false;
        }
        if (!this.perms.equals(other.perms)) {
            return false;
        }
        return this.flags.equals(other.flags);
    }

    private static int hash(int h, Object o) {
        return h * 127 + o.hashCode();
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = this.type.hashCode();
        h = AclEntry.hash(h, this.who);
        h = AclEntry.hash(h, this.perms);
        this.hash = h = AclEntry.hash(h, this.flags);
        return this.hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.who.getName());
        sb.append(':');
        for (AclEntryPermission perm : this.perms) {
            sb.append(perm.name());
            sb.append('/');
        }
        sb.setLength(sb.length() - 1);
        sb.append(':');
        if (!this.flags.isEmpty()) {
            for (AclEntryFlag flag : this.flags) {
                sb.append(flag.name());
                sb.append('/');
            }
            sb.setLength(sb.length() - 1);
            sb.append(':');
        }
        sb.append(this.type.name());
        return sb.toString();
    }

    public static final class Builder {
        private AclEntryType type;
        private UserPrincipal who;
        private Set<AclEntryPermission> perms;
        private Set<AclEntryFlag> flags;

        private Builder(AclEntryType type, UserPrincipal who, Set<AclEntryPermission> perms, Set<AclEntryFlag> flags) {
            assert (perms != null && flags != null);
            this.type = type;
            this.who = who;
            this.perms = perms;
            this.flags = flags;
        }

        public AclEntry build() {
            if (this.type == null) {
                throw new IllegalStateException("Missing type component");
            }
            if (this.who == null) {
                throw new IllegalStateException("Missing who component");
            }
            return new AclEntry(this.type, this.who, this.perms, this.flags);
        }

        public Builder setType(AclEntryType type) {
            if (type == null) {
                throw new NullPointerException();
            }
            this.type = type;
            return this;
        }

        public Builder setPrincipal(UserPrincipal who) {
            if (who == null) {
                throw new NullPointerException();
            }
            this.who = who;
            return this;
        }

        private static void checkSet(Set<?> set, Class<?> type) {
            for (Object e : set) {
                if (e == null) {
                    throw new NullPointerException();
                }
                type.cast(e);
            }
        }

        public Builder setPermissions(Set<AclEntryPermission> perms) {
            if (perms.isEmpty()) {
                perms = Collections.emptySet();
            } else {
                perms = EnumSet.copyOf(perms);
                Builder.checkSet(perms, AclEntryPermission.class);
            }
            this.perms = perms;
            return this;
        }

        public Builder setPermissions(AclEntryPermission ... perms) {
            EnumSet<AclEntryPermission> set = EnumSet.noneOf(AclEntryPermission.class);
            for (AclEntryPermission p : perms) {
                if (p == null) {
                    throw new NullPointerException();
                }
                set.add(p);
            }
            this.perms = set;
            return this;
        }

        public Builder setFlags(Set<AclEntryFlag> flags) {
            if (flags.isEmpty()) {
                flags = Collections.emptySet();
            } else {
                flags = EnumSet.copyOf(flags);
                Builder.checkSet(flags, AclEntryFlag.class);
            }
            this.flags = flags;
            return this;
        }

        public Builder setFlags(AclEntryFlag ... flags) {
            EnumSet<AclEntryFlag> set = EnumSet.noneOf(AclEntryFlag.class);
            for (AclEntryFlag f : flags) {
                if (f == null) {
                    throw new NullPointerException();
                }
                set.add(f);
            }
            this.flags = set;
            return this;
        }
    }
}

