/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import sun.misc.Unsafe;

public class Random
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private final AtomicLong seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    static final String BadBound = "bound must be positive";
    static final String BadRange = "bound must be greater than origin";
    static final String BadSize = "size must be non-negative";
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("seed", Long.TYPE), new ObjectStreamField("nextNextGaussian", Double.TYPE), new ObjectStreamField("haveNextNextGaussian", Boolean.TYPE)};
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long seedOffset;

    public Random() {
        this(Random.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    public Random(long seed) {
        if (this.getClass() == Random.class) {
            this.seed = new AtomicLong(Random.initialScramble(seed));
        } else {
            this.seed = new AtomicLong();
            this.setSeed(seed);
        }
    }

    private static long initialScramble(long seed) {
        return (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public synchronized void setSeed(long seed) {
        this.seed.set(Random.initialScramble(seed));
        this.haveNextNextGaussian = false;
    }

    protected int next(int bits) {
        long nextseed;
        long oldseed;
        AtomicLong seed = this.seed;
        while (!seed.compareAndSet(oldseed = seed.get(), nextseed = oldseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(nextseed >>> 48 - bits);
    }

    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            int rnd = this.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    final long internalNextLong(long origin, long bound) {
        long r = this.nextLong();
        if (origin < bound) {
            long n = bound - origin;
            long m = n - 1L;
            if ((n & m) == 0L) {
                r = (r & m) + origin;
            } else if (n > 0L) {
                long u = r >>> 1;
                while (u + m - (r = u % n) < 0L) {
                    u = this.nextLong() >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = this.nextLong();
                }
            }
        }
        return r;
    }

    final int internalNextInt(int origin, int bound) {
        if (origin < bound) {
            int r;
            int n = bound - origin;
            if (n > 0) {
                return this.nextInt(n) + origin;
            }
            while ((r = this.nextInt()) < origin || r >= bound) {
            }
            return r;
        }
        return this.nextInt();
    }

    final double internalNextDouble(double origin, double bound) {
        double r = this.nextDouble();
        if (origin < bound && (r = r * (bound - origin) + origin) >= bound) {
            r = Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
        }
        return r;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int r = this.next(31);
        int m = bound - 1;
        if ((bound & m) == 0) {
            r = (int)((long)bound * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % bound) + m < 0) {
                u = this.next(31);
            }
        }
        return r;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public IntStream ints(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, streamSize, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints() {
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    public LongStream longs(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, streamSize, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs() {
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    public DoubleStream doubles(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, streamSize, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles() {
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (!(randomNumberOrigin < randomNumberBound)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        if (!(randomNumberOrigin < randomNumberBound)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        long seedVal = fields.get("seed", -1L);
        if (seedVal < 0L) {
            throw new StreamCorruptedException("Random: invalid seed");
        }
        this.resetSeed(seedVal);
        this.nextNextGaussian = fields.get("nextNextGaussian", 0.0);
        this.haveNextNextGaussian = fields.get("haveNextNextGaussian", false);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("seed", this.seed.get());
        fields.put("nextNextGaussian", this.nextNextGaussian);
        fields.put("haveNextNextGaussian", this.haveNextNextGaussian);
        s.writeFields();
    }

    private void resetSeed(long seedVal) {
        unsafe.putObjectVolatile(this, seedOffset, new AtomicLong(seedVal));
    }

    static {
        try {
            seedOffset = unsafe.objectFieldOffset(Random.class.getDeclaredField("seed"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        final Random rng;
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(Random rng, long index, long fence, double origin, double bound) {
            this.rng = rng;
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long i = this.index;
            long m = i + this.fence >>> 1;
            if (m <= i) {
                randomDoublesSpliterator = null;
            } else {
                this.index = m;
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(this.rng, i, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(this.rng.internalNextDouble(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                Random r = this.rng;
                double o = this.origin;
                double b = this.bound;
                do {
                    consumer.accept(r.internalNextDouble(o, b));
                } while (++i < f);
            }
        }
    }

    static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        final Random rng;
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(Random rng, long index, long fence, long origin, long bound) {
            this.rng = rng;
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long i = this.index;
            long m = i + this.fence >>> 1;
            if (m <= i) {
                randomLongsSpliterator = null;
            } else {
                this.index = m;
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(this.rng, i, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(LongConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(this.rng.internalNextLong(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                Random r = this.rng;
                long o = this.origin;
                long b = this.bound;
                do {
                    consumer.accept(r.internalNextLong(o, b));
                } while (++i < f);
            }
        }
    }

    static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        final Random rng;
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(Random rng, long index, long fence, int origin, int bound) {
            this.rng = rng;
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long i = this.index;
            long m = i + this.fence >>> 1;
            if (m <= i) {
                randomIntsSpliterator = null;
            } else {
                this.index = m;
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(this.rng, i, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(IntConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(this.rng.internalNextInt(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                Random r = this.rng;
                int o = this.origin;
                int b = this.bound;
                do {
                    consumer.accept(r.internalNextInt(o, b));
                } while (++i < f);
            }
        }
    }
}

