/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.DefaultLookup;

public class SynthOptionPaneUI
extends BasicOptionPaneUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent x) {
        return new SynthOptionPaneUI();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.optionPane);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.optionPane.addPropertyChangeListener(this);
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.minimumSize = (Dimension)this.style.get(context, "OptionPane.minimumSize");
            if (this.minimumSize == null) {
                this.minimumSize = new Dimension(262, 90);
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.optionPane, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.optionPane.removePropertyChangeListener(this);
    }

    @Override
    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container separator = this.createSeparator();
        if (separator != null) {
            this.optionPane.add(separator);
            SynthContext context = this.getContext(this.optionPane, 1);
            this.optionPane.add(Box.createVerticalStrut(context.getStyle().getInt(context, "OptionPane.separatorPadding", 6)));
            context.dispose();
        }
        this.optionPane.add(this.createButtonArea());
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintOptionPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintOptionPaneBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JOptionPane)e.getSource());
        }
    }

    @Override
    protected boolean getSizeButtonsToSameWidth() {
        return DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.sameSizeButtons", true);
    }

    @Override
    protected Container createMessageArea() {
        JPanel top = new JPanel();
        top.setName("OptionPane.messageArea");
        top.setLayout(new BorderLayout());
        JPanel body = new JPanel(new GridBagLayout());
        JPanel realBody = new JPanel(new BorderLayout());
        body.setName("OptionPane.body");
        realBody.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            JPanel sep = new JPanel();
            sep.setName("OptionPane.separator");
            sep.setPreferredSize(new Dimension(15, 1));
            realBody.add((Component)sep, "Before");
        }
        realBody.add((Component)body, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        SynthContext context = this.getContext(this.optionPane, 1);
        cons.anchor = context.getStyle().getInt(context, "OptionPane.messageAnchor", 10);
        context.dispose();
        cons.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(body, cons, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        top.add((Component)realBody, "Center");
        this.addIcon(top);
        return top;
    }

    @Override
    protected Container createSeparator() {
        JSeparator separator = new JSeparator(0);
        separator.setName("OptionPane.separator");
        return separator;
    }
}

