/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class XPathType {
    private final String expression;
    private final Filter filter;
    private Map<String, String> nsMap;

    public XPathType(String expression, Filter filter) {
        if (expression == null) {
            throw new NullPointerException("expression cannot be null");
        }
        if (filter == null) {
            throw new NullPointerException("filter cannot be null");
        }
        this.expression = expression;
        this.filter = filter;
        this.nsMap = Collections.emptyMap();
    }

    public XPathType(String expression, Filter filter, Map namespaceMap) {
        this(expression, filter);
        if (namespaceMap == null) {
            throw new NullPointerException("namespaceMap cannot be null");
        }
        HashMap copy = new HashMap(namespaceMap);
        for (Map.Entry me : copy.entrySet()) {
            if (me.getKey() instanceof String && me.getValue() instanceof String) continue;
            throw new ClassCastException("not a String");
        }
        HashMap temp = copy;
        this.nsMap = Collections.unmodifiableMap(temp);
    }

    public String getExpression() {
        return this.expression;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Map getNamespaceMap() {
        return this.nsMap;
    }

    public static class Filter {
        private final String operation;
        public static final Filter INTERSECT = new Filter("intersect");
        public static final Filter SUBTRACT = new Filter("subtract");
        public static final Filter UNION = new Filter("union");

        private Filter(String operation) {
            this.operation = operation;
        }

        public String toString() {
            return this.operation;
        }
    }
}

