/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

final class WListPeer
extends WComponentPeer
implements ListPeer {
    private FontMetrics fm;

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public int[] getSelectedIndexes() {
        List l = (List)this.target;
        int len = l.countItems();
        int[] sel = new int[len];
        int nsel = 0;
        for (int i = 0; i < len; ++i) {
            if (!this.isSelected(i)) continue;
            sel[nsel++] = i;
        }
        int[] selected = new int[nsel];
        System.arraycopy(sel, 0, selected, 0, nsel);
        return selected;
    }

    @Override
    public void add(String item, int index) {
        this.addItem(item, index);
    }

    @Override
    public void removeAll() {
        this.clear();
    }

    @Override
    public void setMultipleMode(boolean b) {
        this.setMultipleSelections(b);
    }

    @Override
    public Dimension getPreferredSize(int rows) {
        return this.preferredSize(rows);
    }

    @Override
    public Dimension getMinimumSize(int rows) {
        return this.minimumSize(rows);
    }

    public void addItem(String item, int index) {
        this.addItems(new String[]{item}, index, this.fm.stringWidth(item));
    }

    native void addItems(String[] var1, int var2, int var3);

    @Override
    public native void delItems(int var1, int var2);

    public void clear() {
        List l = (List)this.target;
        this.delItems(0, l.countItems());
    }

    @Override
    public native void select(int var1);

    @Override
    public native void deselect(int var1);

    @Override
    public native void makeVisible(int var1);

    public native void setMultipleSelections(boolean var1);

    public native int getMaxWidth();

    public Dimension preferredSize(int v) {
        if (this.fm == null) {
            List li = (List)this.target;
            this.fm = this.getFontMetrics(li.getFont());
        }
        Dimension d = this.minimumSize(v);
        d.width = Math.max(d.width, this.getMaxWidth() + 20);
        return d;
    }

    public Dimension minimumSize(int v) {
        return new Dimension(20 + this.fm.stringWidth("0123456789abcde"), this.fm.getHeight() * v + 4);
    }

    WListPeer(List target) {
        super(target);
    }

    @Override
    native void create(WComponentPeer var1);

    @Override
    void initialize() {
        int nitems;
        List li = (List)this.target;
        this.fm = this.getFontMetrics(li.getFont());
        Font f = li.getFont();
        if (f != null) {
            this.setFont(f);
        }
        if ((nitems = li.countItems()) > 0) {
            String[] items = new String[nitems];
            int maxWidth = 0;
            int width = 0;
            for (int i = 0; i < nitems; ++i) {
                items[i] = li.getItem(i);
                width = this.fm.stringWidth(items[i]);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            this.addItems(items, 0, maxWidth);
        }
        this.setMultipleSelections(li.allowsMultipleSelections());
        int[] sel = li.getSelectedIndexes();
        for (int i = 0; i < sel.length; ++i) {
            this.select(sel[i]);
        }
        int index = li.getVisibleIndex();
        if (index < 0 && sel.length > 0) {
            index = sel[0];
        }
        if (index >= 0) {
            this.makeVisible(index);
        }
        super.initialize();
    }

    @Override
    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    private native void updateMaxItemWidth();

    native boolean isSelected(int var1);

    @Override
    synchronized void _setFont(Font f) {
        super._setFont(f);
        this.fm = this.getFontMetrics(((List)this.target).getFont());
        this.updateMaxItemWidth();
    }

    void handleAction(final int index, final long when, final int modifiers) {
        final List l = (List)this.target;
        WToolkit.executeOnEventHandlerThread(l, new Runnable(){

            @Override
            public void run() {
                l.select(index);
                WListPeer.this.postEvent(new ActionEvent(WListPeer.this.target, 1001, l.getItem(index), when, modifiers));
            }
        });
    }

    void handleListChanged(final int index) {
        final List l = (List)this.target;
        WToolkit.executeOnEventHandlerThread(l, new Runnable(){

            @Override
            public void run() {
                WListPeer.this.postEvent(new ItemEvent(l, 701, index, WListPeer.this.isSelected(index) ? 1 : 2));
            }
        });
    }
}

