/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Arrays;
import sun.misc.FloatingDecimal;

public class FormattedFloatingDecimal {
    private int decExponentRounded;
    private char[] mantissa;
    private char[] exponent;
    private static final ThreadLocal<Object> threadLocalCharBuffer = new ThreadLocal<Object>(){

        @Override
        protected Object initialValue() {
            return new char[20];
        }
    };

    public static FormattedFloatingDecimal valueOf(double d, int precision, Form form) {
        FloatingDecimal.BinaryToASCIIConverter fdConverter = FloatingDecimal.getBinaryToASCIIConverter(d, form == Form.COMPATIBLE);
        return new FormattedFloatingDecimal(precision, form, fdConverter);
    }

    private static char[] getBuffer() {
        return (char[])threadLocalCharBuffer.get();
    }

    private FormattedFloatingDecimal(int precision, Form form, FloatingDecimal.BinaryToASCIIConverter fdConverter) {
        if (fdConverter.isExceptional()) {
            this.mantissa = fdConverter.toJavaFormatString().toCharArray();
            this.exponent = null;
            return;
        }
        char[] digits = FormattedFloatingDecimal.getBuffer();
        int nDigits = fdConverter.getDigits(digits);
        int decExp = fdConverter.getDecimalExponent();
        boolean isNegative = fdConverter.isNegative();
        switch (form) {
            case COMPATIBLE: {
                int exp;
                this.decExponentRounded = exp = decExp;
                this.fillCompatible(precision, digits, nDigits, exp, isNegative);
                break;
            }
            case DECIMAL_FLOAT: {
                int exp = FormattedFloatingDecimal.applyPrecision(decExp, digits, nDigits, decExp + precision);
                this.fillDecimal(precision, digits, nDigits, exp, isNegative);
                this.decExponentRounded = exp;
                break;
            }
            case SCIENTIFIC: {
                int exp = FormattedFloatingDecimal.applyPrecision(decExp, digits, nDigits, precision + 1);
                this.fillScientific(precision, digits, nDigits, exp, isNegative);
                this.decExponentRounded = exp;
                break;
            }
            case GENERAL: {
                int exp = FormattedFloatingDecimal.applyPrecision(decExp, digits, nDigits, precision);
                if (exp - 1 < -4 || exp - 1 >= precision) {
                    this.fillScientific(--precision, digits, nDigits, exp, isNegative);
                } else {
                    this.fillDecimal(precision -= exp, digits, nDigits, exp, isNegative);
                }
                this.decExponentRounded = exp;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public int getExponentRounded() {
        return this.decExponentRounded - 1;
    }

    public char[] getMantissa() {
        return this.mantissa;
    }

    public char[] getExponent() {
        return this.exponent;
    }

    private static int applyPrecision(int decExp, char[] digits, int nDigits, int prec) {
        if (prec >= nDigits || prec < 0) {
            return decExp;
        }
        if (prec == 0) {
            if (digits[0] >= '5') {
                digits[0] = 49;
                Arrays.fill(digits, 1, nDigits, '0');
                return decExp + 1;
            }
            Arrays.fill(digits, 0, nDigits, '0');
            return decExp;
        }
        char q = digits[prec];
        if (q >= '5') {
            int i = prec;
            if ((q = digits[--i]) == '9') {
                while (q == '9' && i > 0) {
                    q = digits[--i];
                }
                if (q == '9') {
                    digits[0] = 49;
                    Arrays.fill(digits, 1, nDigits, '0');
                    return decExp + 1;
                }
            }
            digits[i] = (char)(q + '\u0001');
            Arrays.fill(digits, i + 1, nDigits, '0');
        } else {
            Arrays.fill(digits, prec, nDigits, '0');
        }
        return decExp;
    }

    private void fillCompatible(int precision, char[] digits, int nDigits, int exp, boolean isNegative) {
        int startIndex;
        int n = startIndex = isNegative ? 1 : 0;
        if (exp > 0 && exp < 8) {
            if (nDigits < exp) {
                int extraZeros = exp - nDigits;
                this.mantissa = FormattedFloatingDecimal.create(isNegative, nDigits + extraZeros + 2);
                System.arraycopy(digits, 0, this.mantissa, startIndex, nDigits);
                Arrays.fill(this.mantissa, startIndex + nDigits, startIndex + nDigits + extraZeros, '0');
                this.mantissa[startIndex + nDigits + extraZeros] = 46;
                this.mantissa[startIndex + nDigits + extraZeros + 1] = 48;
            } else if (exp < nDigits) {
                int t = Math.min(nDigits - exp, precision);
                this.mantissa = FormattedFloatingDecimal.create(isNegative, exp + 1 + t);
                System.arraycopy(digits, 0, this.mantissa, startIndex, exp);
                this.mantissa[startIndex + exp] = 46;
                System.arraycopy(digits, exp, this.mantissa, startIndex + exp + 1, t);
            } else {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, nDigits + 2);
                System.arraycopy(digits, 0, this.mantissa, startIndex, nDigits);
                this.mantissa[startIndex + nDigits] = 46;
                this.mantissa[startIndex + nDigits + 1] = 48;
            }
        } else if (exp <= 0 && exp > -3) {
            int zeros = Math.max(0, Math.min(-exp, precision));
            int t = Math.max(0, Math.min(nDigits, precision + exp));
            if (zeros > 0) {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, zeros + 2 + t);
                this.mantissa[startIndex] = 48;
                this.mantissa[startIndex + 1] = 46;
                Arrays.fill(this.mantissa, startIndex + 2, startIndex + 2 + zeros, '0');
                if (t > 0) {
                    System.arraycopy(digits, 0, this.mantissa, startIndex + 2 + zeros, t);
                }
            } else if (t > 0) {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, zeros + 2 + t);
                this.mantissa[startIndex] = 48;
                this.mantissa[startIndex + 1] = 46;
                System.arraycopy(digits, 0, this.mantissa, startIndex + 2, t);
            } else {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, 1);
                this.mantissa[startIndex] = 48;
            }
        } else {
            int expStartIntex;
            int e;
            boolean isNegExp;
            if (nDigits > 1) {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, nDigits + 1);
                this.mantissa[startIndex] = digits[0];
                this.mantissa[startIndex + 1] = 46;
                System.arraycopy(digits, 1, this.mantissa, startIndex + 2, nDigits - 1);
            } else {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, 3);
                this.mantissa[startIndex] = digits[0];
                this.mantissa[startIndex + 1] = 46;
                this.mantissa[startIndex + 2] = 48;
            }
            boolean bl = isNegExp = exp <= 0;
            if (isNegExp) {
                e = -exp + 1;
                expStartIntex = 1;
            } else {
                e = exp - 1;
                expStartIntex = 0;
            }
            if (e <= 9) {
                this.exponent = FormattedFloatingDecimal.create(isNegExp, 1);
                this.exponent[expStartIntex] = (char)(e + 48);
            } else if (e <= 99) {
                this.exponent = FormattedFloatingDecimal.create(isNegExp, 2);
                this.exponent[expStartIntex] = (char)(e / 10 + 48);
                this.exponent[expStartIntex + 1] = (char)(e % 10 + 48);
            } else {
                this.exponent = FormattedFloatingDecimal.create(isNegExp, 3);
                this.exponent[expStartIntex] = (char)(e / 100 + 48);
                this.exponent[expStartIntex + 1] = (char)((e %= 100) / 10 + 48);
                this.exponent[expStartIntex + 2] = (char)(e % 10 + 48);
            }
        }
    }

    private static char[] create(boolean isNegative, int size) {
        if (isNegative) {
            char[] r = new char[size + 1];
            r[0] = 45;
            return r;
        }
        return new char[size];
    }

    private void fillDecimal(int precision, char[] digits, int nDigits, int exp, boolean isNegative) {
        int startIndex;
        int n = startIndex = isNegative ? 1 : 0;
        if (exp > 0) {
            if (nDigits < exp) {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, exp);
                System.arraycopy(digits, 0, this.mantissa, startIndex, nDigits);
                Arrays.fill(this.mantissa, startIndex + nDigits, startIndex + exp, '0');
            } else {
                int t = Math.min(nDigits - exp, precision);
                this.mantissa = FormattedFloatingDecimal.create(isNegative, exp + (t > 0 ? t + 1 : 0));
                System.arraycopy(digits, 0, this.mantissa, startIndex, exp);
                if (t > 0) {
                    this.mantissa[startIndex + exp] = 46;
                    System.arraycopy(digits, exp, this.mantissa, startIndex + exp + 1, t);
                }
            }
        } else if (exp <= 0) {
            int zeros = Math.max(0, Math.min(-exp, precision));
            int t = Math.max(0, Math.min(nDigits, precision + exp));
            if (zeros > 0) {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, zeros + 2 + t);
                this.mantissa[startIndex] = 48;
                this.mantissa[startIndex + 1] = 46;
                Arrays.fill(this.mantissa, startIndex + 2, startIndex + 2 + zeros, '0');
                if (t > 0) {
                    System.arraycopy(digits, 0, this.mantissa, startIndex + 2 + zeros, t);
                }
            } else if (t > 0) {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, zeros + 2 + t);
                this.mantissa[startIndex] = 48;
                this.mantissa[startIndex + 1] = 46;
                System.arraycopy(digits, 0, this.mantissa, startIndex + 2, t);
            } else {
                this.mantissa = FormattedFloatingDecimal.create(isNegative, 1);
                this.mantissa[startIndex] = 48;
            }
        }
    }

    private void fillScientific(int precision, char[] digits, int nDigits, int exp, boolean isNegative) {
        int e;
        char expSign;
        int startIndex = isNegative ? 1 : 0;
        int t = Math.max(0, Math.min(nDigits - 1, precision));
        if (t > 0) {
            this.mantissa = FormattedFloatingDecimal.create(isNegative, t + 2);
            this.mantissa[startIndex] = digits[0];
            this.mantissa[startIndex + 1] = 46;
            System.arraycopy(digits, 1, this.mantissa, startIndex + 2, t);
        } else {
            this.mantissa = FormattedFloatingDecimal.create(isNegative, 1);
            this.mantissa[startIndex] = digits[0];
        }
        if (exp <= 0) {
            expSign = '-';
            e = -exp + 1;
        } else {
            expSign = '+';
            e = exp - 1;
        }
        if (e <= 9) {
            this.exponent = new char[]{expSign, '0', (char)(e + 48)};
        } else if (e <= 99) {
            this.exponent = new char[]{expSign, (char)(e / 10 + 48), (char)(e % 10 + 48)};
        } else {
            char hiExpChar = (char)(e / 100 + 48);
            this.exponent = new char[]{expSign, hiExpChar, (char)((e %= 100) / 10 + 48), (char)(e % 10 + 48)};
        }
    }

    public static enum Form {
        SCIENTIFIC,
        COMPATIBLE,
        DECIMAL_FLOAT,
        GENERAL;

    }
}

