/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.HashMap;
import org.ietf.jgss.Oid;
import sun.security.action.PutAllAction;
import sun.security.jgss.wrapper.GSSLibStub;

public final class SunNativeProvider
extends Provider {
    private static final long serialVersionUID = -238911724858694204L;
    private static final String NAME = "SunNativeGSS";
    private static final String INFO = "Sun Native GSS provider";
    private static final String MF_CLASS = "sun.security.jgss.wrapper.NativeGSSFactory";
    private static final String LIB_PROP = "sun.security.jgss.lib";
    private static final String DEBUG_PROP = "sun.security.nativegss.debug";
    private static HashMap<String, String> MECH_MAP;
    static final Provider INSTANCE;
    static boolean DEBUG;

    static void debug(String message) {
        if (DEBUG) {
            if (message == null) {
                throw new NullPointerException();
            }
            System.out.println("SunNativeGSS: " + message);
        }
    }

    public SunNativeProvider() {
        super(NAME, 1.8, INFO);
        if (MECH_MAP != null) {
            AccessController.doPrivileged(new PutAllAction(this, MECH_MAP));
        }
    }

    static {
        INSTANCE = new SunNativeProvider();
        MECH_MAP = AccessController.doPrivileged(new PrivilegedAction<HashMap<String, String>>(){

            @Override
            public HashMap<String, String> run() {
                DEBUG = Boolean.parseBoolean(System.getProperty(SunNativeProvider.DEBUG_PROP));
                try {
                    System.loadLibrary("j2gss");
                }
                catch (Error err) {
                    SunNativeProvider.debug("No j2gss library found!");
                    if (DEBUG) {
                        err.printStackTrace();
                    }
                    return null;
                }
                String[] gssLibs = new String[]{};
                String defaultLib = System.getProperty(SunNativeProvider.LIB_PROP);
                if (defaultLib == null || defaultLib.trim().equals("")) {
                    String osname = System.getProperty("os.name");
                    if (osname.startsWith("SunOS")) {
                        gssLibs = new String[]{"libgss.so"};
                    } else if (osname.startsWith("Linux")) {
                        gssLibs = new String[]{"libgssapi.so", "libgssapi_krb5.so", "libgssapi_krb5.so.2"};
                    } else if (osname.contains("OS X")) {
                        gssLibs = new String[]{"libgssapi_krb5.dylib", "/usr/lib/sasl2/libgssapiv2.2.so"};
                    }
                } else {
                    gssLibs = new String[]{defaultLib};
                }
                for (String libName : gssLibs) {
                    if (!GSSLibStub.init(libName, DEBUG)) continue;
                    SunNativeProvider.debug("Loaded GSS library: " + libName);
                    Oid[] mechs = GSSLibStub.indicateMechs();
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int i = 0; i < mechs.length; ++i) {
                        SunNativeProvider.debug("Native MF for " + mechs[i]);
                        map.put("GssApiMechanism." + mechs[i], SunNativeProvider.MF_CLASS);
                    }
                    return map;
                }
                return null;
            }
        });
    }
}

