/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import sun.security.provider.certpath.PKIX;
import sun.security.util.AnchorCertificates;
import sun.security.util.CertConstraintParameters;
import sun.security.util.Debug;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public final class AlgorithmChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final AlgorithmConstraints constraints;
    private final PublicKey trustedPubKey;
    private PublicKey prevPubKey;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final Set<CryptoPrimitive> KU_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE, CryptoPrimitive.KEY_ENCAPSULATION, CryptoPrimitive.PUBLIC_KEY_ENCRYPTION, CryptoPrimitive.KEY_AGREEMENT));
    private static final DisabledAlgorithmConstraints certPathDefaultConstraints = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");
    private static final boolean publicCALimits = certPathDefaultConstraints.checkProperty("jdkCA");
    private boolean trustedMatch = false;

    public AlgorithmChecker(TrustAnchor anchor) {
        this(anchor, certPathDefaultConstraints);
    }

    public AlgorithmChecker(AlgorithmConstraints constraints) {
        this.prevPubKey = null;
        this.trustedPubKey = null;
        this.constraints = constraints;
    }

    public AlgorithmChecker(TrustAnchor anchor, AlgorithmConstraints constraints) {
        if (anchor == null) {
            throw new IllegalArgumentException("The trust anchor cannot be null");
        }
        if (anchor.getTrustedCert() != null) {
            this.trustedPubKey = anchor.getTrustedCert().getPublicKey();
            this.trustedMatch = AlgorithmChecker.checkFingerprint(anchor.getTrustedCert());
            if (this.trustedMatch && debug != null) {
                debug.println("trustedMatch = true");
            }
        } else {
            this.trustedPubKey = anchor.getCAPublicKey();
        }
        this.prevPubKey = this.trustedPubKey;
        this.constraints = constraints;
    }

    private static boolean checkFingerprint(X509Certificate cert) {
        if (!publicCALimits) {
            return false;
        }
        if (debug != null) {
            debug.println("AlgorithmChecker.contains: " + cert.getSigAlgName());
        }
        return AnchorCertificates.contains(cert);
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (!forward) {
            this.prevPubKey = this.trustedPubKey != null ? this.trustedPubKey : null;
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        AlgorithmId algorithmId;
        X509CertImpl x509Cert;
        if (!(cert instanceof X509Certificate) || this.constraints == null) {
            return;
        }
        boolean[] keyUsage = ((X509Certificate)cert).getKeyUsage();
        if (keyUsage != null && keyUsage.length < 9) {
            throw new CertPathValidatorException("incorrect KeyUsage extension", null, null, -1, PKIXReason.INVALID_KEY_USAGE);
        }
        Set<CryptoPrimitive> primitives = KU_PRIMITIVE_SET;
        if (keyUsage != null) {
            primitives = EnumSet.noneOf(CryptoPrimitive.class);
            if (keyUsage[0] || keyUsage[1] || keyUsage[5] || keyUsage[6]) {
                primitives.add(CryptoPrimitive.SIGNATURE);
            }
            if (keyUsage[2]) {
                primitives.add(CryptoPrimitive.KEY_ENCAPSULATION);
            }
            if (keyUsage[3]) {
                primitives.add(CryptoPrimitive.PUBLIC_KEY_ENCRYPTION);
            }
            if (keyUsage[4]) {
                primitives.add(CryptoPrimitive.KEY_AGREEMENT);
            }
            if (primitives.isEmpty()) {
                throw new CertPathValidatorException("incorrect KeyUsage extension bits", null, null, -1, PKIXReason.INVALID_KEY_USAGE);
            }
        }
        PublicKey currPubKey = cert.getPublicKey();
        if (this.constraints instanceof DisabledAlgorithmConstraints) {
            ((DisabledAlgorithmConstraints)this.constraints).permits(primitives, new CertConstraintParameters((X509Certificate)cert, this.trustedMatch));
            if (this.prevPubKey == null) {
                this.prevPubKey = currPubKey;
                return;
            }
        }
        try {
            x509Cert = X509CertImpl.toImpl((X509Certificate)cert);
            algorithmId = (AlgorithmId)x509Cert.get("x509.algorithm");
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException(ce);
        }
        AlgorithmParameters currSigAlgParams = algorithmId.getParameters();
        String currSigAlg = x509Cert.getSigAlgName();
        if (!(this.constraints instanceof DisabledAlgorithmConstraints)) {
            if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, currSigAlg, currSigAlgParams)) {
                throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + currSigAlg, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
            if (!this.constraints.permits(primitives, currPubKey)) {
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize: " + KeyUtil.getKeySize(currPubKey), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
        if (this.prevPubKey != null) {
            if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, currSigAlg, this.prevPubKey, currSigAlgParams)) {
                throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + currSigAlg, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
            if (PKIX.isDSAPublicKeyWithoutParams(currPubKey)) {
                if (!(this.prevPubKey instanceof DSAPublicKey)) {
                    throw new CertPathValidatorException("Input key is not of a appropriate type for inheriting parameters");
                }
                DSAParams params = ((DSAPublicKey)this.prevPubKey).getParams();
                if (params == null) {
                    throw new CertPathValidatorException("Key parameters missing from public key.");
                }
                try {
                    BigInteger y = ((DSAPublicKey)currPubKey).getY();
                    KeyFactory kf = KeyFactory.getInstance("DSA");
                    DSAPublicKeySpec ks = new DSAPublicKeySpec(y, params.getP(), params.getQ(), params.getG());
                    currPubKey = kf.generatePublic(ks);
                }
                catch (GeneralSecurityException e) {
                    throw new CertPathValidatorException("Unable to generate key with inherited parameters: " + e.getMessage(), e);
                }
            }
        }
        this.prevPubKey = currPubKey;
    }

    void trySetTrustAnchor(TrustAnchor anchor) {
        if (this.prevPubKey == null) {
            if (anchor == null) {
                throw new IllegalArgumentException("The trust anchor cannot be null");
            }
            if (anchor.getTrustedCert() != null) {
                this.prevPubKey = anchor.getTrustedCert().getPublicKey();
                this.trustedMatch = AlgorithmChecker.checkFingerprint(anchor.getTrustedCert());
                if (this.trustedMatch && debug != null) {
                    debug.println("trustedMatch = true");
                }
            } else {
                this.prevPubKey = anchor.getCAPublicKey();
            }
        }
    }

    static void check(PublicKey key, X509CRL crl) throws CertPathValidatorException {
        X509CRLImpl x509CRLImpl = null;
        try {
            x509CRLImpl = X509CRLImpl.toImpl(crl);
        }
        catch (CRLException ce) {
            throw new CertPathValidatorException(ce);
        }
        AlgorithmId algorithmId = x509CRLImpl.getSigAlgId();
        AlgorithmChecker.check(key, algorithmId);
    }

    static void check(PublicKey key, AlgorithmId algorithmId) throws CertPathValidatorException {
        AlgorithmParameters sigAlgParams;
        String sigAlgName = algorithmId.getName();
        if (!certPathDefaultConstraints.permits(SIGNATURE_PRIMITIVE_SET, sigAlgName, key, sigAlgParams = algorithmId.getParameters())) {
            throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + sigAlgName + " is disabled", null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
    }
}

