/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;
import sun.text.SupplementaryCharacterData;
import sun.util.locale.provider.RuleBasedBreakIterator;

class BreakDictionary {
    private static int supportedVersion = 1;
    private CompactByteArray columnMap = null;
    private SupplementaryCharacterData supplementaryCharColumnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    BreakDictionary(String dictionaryName) throws IOException, MissingResourceException {
        this.readDictionaryFile(dictionaryName);
    }

    private void readDictionaryFile(final String dictionaryName) throws IOException, MissingResourceException {
        BufferedInputStream in;
        try {
            in = AccessController.doPrivileged(new PrivilegedExceptionAction<BufferedInputStream>(){

                @Override
                public BufferedInputStream run() throws Exception {
                    return new BufferedInputStream(this.getClass().getResourceAsStream("/sun/text/resources/" + dictionaryName));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new InternalError(e.toString(), e);
        }
        byte[] buf = new byte[8];
        if (in.read(buf) != 8) {
            throw new MissingResourceException("Wrong data length", dictionaryName, "");
        }
        int version = RuleBasedBreakIterator.getInt(buf, 0);
        if (version != supportedVersion) {
            throw new MissingResourceException("Dictionary version(" + version + ") is unsupported", dictionaryName, "");
        }
        int len = RuleBasedBreakIterator.getInt(buf, 4);
        if (in.read(buf = new byte[len]) != len) {
            throw new MissingResourceException("Wrong data length", dictionaryName, "");
        }
        in.close();
        int offset = 0;
        int l = RuleBasedBreakIterator.getInt(buf, offset);
        offset += 4;
        short[] temp = new short[l];
        int i = 0;
        while (i < l) {
            temp[i] = RuleBasedBreakIterator.getShort(buf, offset);
            ++i;
            offset += 2;
        }
        l = RuleBasedBreakIterator.getInt(buf, offset);
        offset += 4;
        byte[] temp2 = new byte[l];
        int i2 = 0;
        while (i2 < l) {
            temp2[i2] = buf[offset];
            ++i2;
            ++offset;
        }
        this.columnMap = new CompactByteArray(temp, temp2);
        this.numCols = RuleBasedBreakIterator.getInt(buf, offset);
        this.numColGroups = RuleBasedBreakIterator.getInt(buf, offset += 4);
        l = RuleBasedBreakIterator.getInt(buf, offset += 4);
        offset += 4;
        this.rowIndex = new short[l];
        i2 = 0;
        while (i2 < l) {
            this.rowIndex[i2] = RuleBasedBreakIterator.getShort(buf, offset);
            ++i2;
            offset += 2;
        }
        l = RuleBasedBreakIterator.getInt(buf, offset);
        offset += 4;
        this.rowIndexFlagsIndex = new short[l];
        i2 = 0;
        while (i2 < l) {
            this.rowIndexFlagsIndex[i2] = RuleBasedBreakIterator.getShort(buf, offset);
            ++i2;
            offset += 2;
        }
        l = RuleBasedBreakIterator.getInt(buf, offset);
        offset += 4;
        this.rowIndexFlags = new int[l];
        i2 = 0;
        while (i2 < l) {
            this.rowIndexFlags[i2] = RuleBasedBreakIterator.getInt(buf, offset);
            ++i2;
            offset += 4;
        }
        l = RuleBasedBreakIterator.getInt(buf, offset);
        offset += 4;
        this.rowIndexShifts = new byte[l];
        i2 = 0;
        while (i2 < l) {
            this.rowIndexShifts[i2] = buf[offset];
            ++i2;
            ++offset;
        }
        l = RuleBasedBreakIterator.getInt(buf, offset);
        offset += 4;
        this.table = new short[l];
        i2 = 0;
        while (i2 < l) {
            this.table[i2] = RuleBasedBreakIterator.getShort(buf, offset);
            ++i2;
            offset += 2;
        }
        l = RuleBasedBreakIterator.getInt(buf, offset);
        offset += 4;
        int[] temp3 = new int[l];
        int i3 = 0;
        while (i3 < l) {
            temp3[i3] = RuleBasedBreakIterator.getInt(buf, offset);
            ++i3;
            offset += 4;
        }
        this.supplementaryCharColumnMap = new SupplementaryCharacterData(temp3);
    }

    public final short getNextStateFromCharacter(int row, int ch) {
        int col = ch < 65536 ? (int)this.columnMap.elementAt((char)ch) : this.supplementaryCharColumnMap.getValue(ch);
        return this.getNextState(row, col);
    }

    public final short getNextState(int row, int col) {
        if (this.cellIsPopulated(row, col)) {
            return this.internalAt(this.rowIndex[row], col + this.rowIndexShifts[row]);
        }
        return 0;
    }

    private boolean cellIsPopulated(int row, int col) {
        if (this.rowIndexFlagsIndex[row] < 0) {
            return col == -this.rowIndexFlagsIndex[row];
        }
        int flags = this.rowIndexFlags[this.rowIndexFlagsIndex[row] + (col >> 5)];
        return (flags & 1 << (col & 0x1F)) != 0;
    }

    private short internalAt(int row, int col) {
        return this.table[row * this.numCols + col];
    }
}

