/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.it;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_it extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Ora dell'Africa centrale",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Ora standard di Mosca",
               "MST",
               "Ora legale di Mosca",
               "MST",
               "Ora di Mosca",
               "MT",
            };
        final String[] Japan = new String[] {
               "Ora Standard Giappone",
               "JST",
               "Ora Legale Giappone",
               "JDT",
               "Ora Giappone",
               "JT",
            };
        final String[] Argentina = new String[] {
               "Ora standard dell'Argentina",
               "AST",
               "Ora legale dell'Argentina",
               "AST",
               "Ora dell'Argentina",
               "AT",
            };
        final String[] Hovd = new String[] {
               "Ora standard di Hovd",
               "HST",
               "Ora legale di Hovd",
               "HST",
               "Ora di Hovd",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Ora standard di Magadan",
               "MST",
               "Ora legale di Magadan",
               "MST",
               "Ora di Magadan",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standard dell'Australia centroccidentale",
               "ACWST",
               "Ora legale dell'Australia centroccidentale",
               "ACWDT",
               "Ora dell'Australia centroccidentale",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Ora Standard Europa Centrale",
               "CET",
               "Ora Legale Europa Centrale",
               "CEST",
               "Ora Europa Centrale",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Ora standard di Sakhalin",
               "SST",
               "Ora legale di Sakhalin",
               "SST",
               "Ora di Sakhalin",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "Ora di Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "Ora standard orientale USA",
               "EST",
               "Ora legale orientale USA",
               "EDT",
               "Ora orientale USA",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standard delle isole Aleutine, Hawaii",
               "HAST",
               "Ora legale delle isole Aleutine, Hawaii",
               "HADT",
               "Ora delle isole Aleutine, Hawaii",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Ora standard dell'Australia centrale",
               "ACST",
               "Ora legale dell'Australia centrale",
               "ACDT",
               "Ora dell'Australia centrale",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standard di Lord Howe",
               "LHST",
               "Ora legale di Lord Howe",
               "LHDT",
               "Ora di Lord Howe",
               "LHT",
            };
        final String[] Yakutsk = new String[] {
               "Ora standard di Yakutsk",
               "YST",
               "Ora legale di Yakutsk",
               "YST",
               "Ora di Yakutsk",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "Ora standard della costa del Pacifico USA",
               "PST",
               "Ora legale della costa del Pacifico USA",
               "PDT",
               "Ora del Pacifico USA",
               "PT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora dell'Africa orientale",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Europe_Western = new String[] {
               "Ora Standard Europa occidentale",
               "WET",
               "Ora Legale Europa occidentale",
               "WEST",
               "Ora Europa occidentale",
               "WET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora Standard Europa Orientale",
               "EET",
               "Ora Legale Europa Orientale",
               "EEST",
               "Ora Europa Orientale",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Ora standard di Terranova",
               "NST",
               "Ora legale di Terranova",
               "NDT",
               "Ora di Terranova",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "Ora standard dell'Argentina occidentale",
               "WAST",
               "Ora legale dell'Argentina occidentale",
               "WAST",
               "Ora dell'Argentina occidentale",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Ora standard dell'Atlantico",
               "AST",
               "Ora legale dell'Atlantico",
               "ADT",
               "Ora dell'Atlantico",
               "AT",
            };
        final String[] Africa_Western = new String[] {
               "Ora standard dell'Africa occidentale",
               "WAST",
               "Ora legale dell'Africa occidentale",
               "WAST",
               "Ora dell'Africa occidentale",
               "WAT",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standard di Ekaterinburg",
               "YST",
               "Ora legale di Ekaterinburg",
               "YST",
               "Ora di Ekaterinburg",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "Ora standard di Volgograd",
               "VST",
               "Ora legale di Volgograd",
               "VST",
               "Ora di Volgograd",
               "VT",
            };
        final String[] Israel = new String[] {
               "Ora Standard Israele",
               "IST",
               "Ora Legale Israele",
               "IDT",
               "Ora Israele",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora dell'Indonesia centrale",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora standard Sudafrica",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora dell'Indonesia orientale",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Omsk = new String[] {
               "Ora standard di Omsk",
               "OST",
               "Ora legale di Omsk",
               "OST",
               "Ora di Omsk",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "Ora standard dell'Australia occidentale",
               "AWST",
               "Ora legale dell'Australia occidentale",
               "AWDT",
               "Ora dell'Australia occidentale",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora dell'Indonesia occidentale",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "Ora standard di Ulan Bator",
               "UBST",
               "Ora legale di Ulan Bator",
               "UBST",
               "Ora di Ulan Bator",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Ora standard centrale USA",
               "CST",
               "Ora legale centrale USA",
               "CDT",
               "Ora centrale USA",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standard dell'Australia orientale",
               "AEST",
               "Ora legale dell'Australia orientale",
               "AEDT",
               "Ora dell'Australia orientale",
               "EAT",
            };
        final String[] America_Mountain = new String[] {
               "Ora standard sulle Montagne Rocciose USA",
               "MST",
               "Ora legale delle Montagne Rocciose USA",
               "MDT",
               "Ora sulle Montagne Rocciose USA",
               "MT",
            };
        final String[] Alaska = new String[] {
               "Ora standard Alaska",
               "AKST",
               "Ora legale Alaska",
               "AKDT",
               "Ora dell'Alaska",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standard di Novosibirsk",
               "NST",
               "Ora legale di Novosibirsk",
               "NST",
               "Ora di Novosibirsk",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "Ora standard di Vladivostok",
               "VST",
               "Ora legale di Vladivostok",
               "VST",
               "Ora di Vladivostok",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "Ora standard di Irkutsk",
               "IST",
               "Ora legale di Irkutsk",
               "IST",
               "Ora di Irkutsk",
               "IT",
            };
        final String[] Noronha = new String[] {
               "Ora standard di Fernando de Noronha",
               "FNST",
               "Ora legale di Fernando de Noronha",
               "FNST",
               "Ora di Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Ora standard di Choibalsan",
               "CST",
               "Ora legale di Choibalsan",
               "CST",
               "Ora di Choibalsan",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Ora standard di Brasilia",
               "BST",
               "Ora legale di Brasilia",
               "BST",
               "Ora di Brasilia",
               "BT",
            };
        final String[] China = new String[] {
               "Ora standard di Cina",
               "CST",
               "Ora legale di Cina",
               "CDT",
               "Ora di Cina",
               "CT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standard di Krasnoyarsk",
               "KST",
               "Ora legale di Krasnoyarsk",
               "KST",
               "Ora di Krasnoyarsk",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora del Kazakistan occidentale",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Amazon = new String[] {
               "Ora standard dell'Amazzonia",
               "AST",
               "Ora legale dell'Amazzonia",
               "AST",
               "Ora dell'Amazzonia",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora del Kazakistan orientale",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "America/Cuiaba", Amazon },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Libreville", Africa_Western },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/El_Aaiun", Europe_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Windhoek", Africa_Western },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "America/Manaus", Amazon },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "America/Resolute", America_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Europe/Stockholm", Europe_Central },
            { "America/Tortola", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Asia/Yakutsk", Yakutsk },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Africa/Ceuta", Europe_Central },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Yakutat", Alaska },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
