/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.km;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_km extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AD", "\u17a2\u17b6\u1793\u178a\u17bc\u179a\u17c9\u17b6" },
            { "AE", "\u17a2\u17c1\u1798\u17b8\u179a\u17c9\u17c2\u1791\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u179a\u17bd\u1798" },
            { "AF", "\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1782\u17b6\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "AL", "\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8" },
            { "AM", "\u17a2\u17b6\u179a\u1798\u17c1\u1793\u17b8" },
            { "AO", "\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17c4\u17a1\u17b6" },
            { "AR", "\u17a2\u17b6\u17a0\u17d2\u179f\u1784\u17cb\u1791\u17b8\u1793" },
            { "AT", "\u17a2\u17bc\u1791\u17d2\u179a\u17b8\u179f" },
            { "AU", "\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u179b\u17b8" },
            { "AZ", "\u17a2\u17b6\u17a0\u17ca\u17d2\u179f\u17c2\u179a\u1794\u17c2\u17a0\u17d2\u179f\u1784\u17cb" },
            { "BA", "\u1794\u17bc\u179f\u17d2\u1793\u17c9\u17b8" },
            { "BB", "\u1794\u17b6\u179a\u1794\u17b6\u178a\u17bc\u179f" },
            { "BD", "\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c1\u179f\u17d2\u17a0" },
            { "BE", "\u1794\u17c2\u179b\u17a0\u17d2\u179f\u17c9\u17b7\u1780" },
            { "BF", "\u1794\u17ca\u17bc\u179a\u1782\u17b8\u178e\u17b6\u17a0\u17d2\u179c\u17b6\u179f\u17bc" },
            { "BG", "\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1782\u17b6\u179a\u17b8" },
            { "BH", "\u1794\u17b6\u179a\u17c9\u17c2\u1793" },
            { "BI", "\u1794\u17ca\u17bc\u179a\u17bb\u1793\u178c\u17b8" },
            { "BJ", "\u1794\u17c1\u178e\u17b6\u17c6\u1784" },
            { "BN", "\u1794\u17ca\u17d2\u179a\u17bb\u1799\u178e\u17c1" },
            { "BO", "\u1794\u17bc\u179b\u17b8\u179c\u17b8" },
            { "BR", "\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b" },
            { "BS", "\u1794\u17b6\u17a0\u17b6\u1798\u17c9\u17b6" },
            { "BT", "\u1794\u17ca\u17bc\u178f\u17b6\u1793" },
            { "BW", "\u1794\u17bb\u178f\u179f\u17d2\u179c\u17b6\u178e\u17b6" },
            { "BY", "\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f\u17d2\u179f" },
            { "BZ", "\u1794\u17c1\u179b\u17b8\u17a0\u17d2\u179f" },
            { "CA", "\u1780\u17b6\u178e\u17b6\u178a\u17b6" },
            { "CF", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "CG", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4" },
            { "CH", "\u179f\u17d2\u179c\u17b8\u179f" },
            { "CI", "\u1780\u17bc\u178a\u178c\u17b8\u179c\u17d0\u179a" },
            { "CL", "\u1788\u17b8\u179b\u17b8" },
            { "CM", "\u1780\u17b6\u1798\u17c1\u179a\u17bc\u1793" },
            { "CN", "\u1785\u17b7\u1793" },
            { "CO", "\u1780\u17bc\u17a1\u17bb\u17c6\u1794\u17ca\u17b8" },
            { "CR", "\u1780\u17bc\u179f\u17d2\u178f\u17b6\u179a\u17b8\u1780\u17b6" },
            { "CU", "\u1782\u17bb\u1799\u1794\u17b6" },
            { "CV", "\u1780\u17b6\u1794\u179c\u17c2\u179a" },
            { "CY", "\u179f\u17c9\u17b8\u1796\u179a\u17cd" },
            { "CZ", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1786\u17c1\u1780" },
            { "DE", "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb" },
            { "DJ", "\u17a0\u17d2\u179f\u17c9\u17b8\u1794\u17bc\u1791\u17b8" },
            { "DK", "\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780" },
            { "DM", "\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780\u17b6" },
            { "DO", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780\u17c2\u1793" },
            { "DZ", "\u17a2\u17b6\u179b\u17cb\u17a0\u17d2\u179f\u17c1\u179a\u17b8" },
            { "EC", "\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u178c\u17d0\u179a" },
            { "EE", "\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8" },
            { "EG", "\u17a2\u17c1\u17a0\u17d2\u179f\u17c9\u17b8\u1794" },
            { "EH", "\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "ER", "\u17a2\u17c1\u179a\u17b8\u1791\u17d2\u179a\u17b6" },
            { "ES", "\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789" },
            { "ET", "\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8" },
            { "FI", "\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb" },
            { "FJ", "\u17a0\u17d2\u179c\u17c9\u17b8\u17a0\u17d2\u179f\u17c9\u17b8" },
            { "FM", "\u1798\u17b7\u1780\u17d2\u179a\u17bc\u1793\u17c1\u179f\u17ca\u17b8" },
            { "FR", "\u1794\u17b6\u179a\u17b6\u17c6\u1784" },
            { "GA", "\u17a0\u17d2\u1782\u17b6\u1794\u17bb\u1784" },
            { "GE", "\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17c9\u17b8" },
            { "GH", "\u17a0\u17d2\u1780\u17b6\u178e\u17b6" },
            { "GM", "\u17a0\u17d2\u1782\u17b6\u17c6\u1794\u17ca\u17b8" },
            { "GN", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "GQ", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a" },
            { "GR", "\u1780\u17d2\u179a\u17b7\u1785" },
            { "GT", "\u17a0\u17d2\u1782\u17b6\u178f\u17c1\u1798\u17c9\u17b6\u17a1\u17b6" },
            { "GW", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u1794\u17ca\u17b8\u179f\u17bc" },
            { "GY", "\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u178e\u17b6" },
            { "HK", "\u17a0\u17bb\u1784\u1780\u17bb\u1784" },
            { "HN", "\u17a0\u17bb\u1784\u178c\u17bd\u179a\u17c9\u17b6\u179f\u17cb" },
            { "HR", "\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u179f\u17ca\u17b8" },
            { "HT", "\u17a0\u17c3\u1791\u17b8" },
            { "HU", "\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8" },
            { "ID", "\u17a5\u178e\u17d2\u178c\u17bc\u1793\u17c1\u179f\u17ca\u17b8" },
            { "IE", "\u17a2\u17c0\u179a\u17a1\u1784\u17cb" },
            { "IL", "\u17a2\u17ca\u17b8\u179f\u17d2\u179a\u17b6\u17a2\u17c2\u179b" },
            { "IN", "\u17a5\u178e\u17d2\u178c\u17b6" },
            { "IQ", "\u17a2\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17cb" },
            { "IR", "\u17a2\u17ca\u17b8\u179a\u17c9\u1784\u17cb" },
            { "IS", "\u17a2\u17c9\u17b8\u179f\u17d2\u179b\u1784\u17cb" },
            { "IT", "\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8" },
            { "JM", "\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6\u17a2\u17c9\u17b7\u1782" },
            { "JO", "\u17a0\u17ca\u17d2\u179f\u1780\u178a\u17b6\u1793\u17b8" },
            { "JP", "\u1787\u1794\u17c9\u17bb\u1793" },
            { "KE", "\u1780\u17c1\u1793\u1799\u17c9\u17b6" },
            { "KG", "\u1782\u17c0\u179a\u17a0\u17d2\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "KH", "\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6" },
            { "KI", "\u1782\u17b7\u179a\u17b7\u1794\u17b6\u1791\u17b8" },
            { "KM", "\u1780\u17bb\u17c6\u1798\u17c9\u17bc\u179a\u17c9\u17bc\u179f" },
            { "KP", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1794\u17d2\u179a\u1787\u17b6\u1792\u17b7\u1794\u178f\u17c1\u1799\u17d2\u1799\u1794\u17d2\u179a\u1787\u17b6\u1798\u17b6\u1793\u17b7\u178f\u1780\u17bc\u179a\u17c9\u17c1" },
            { "KR", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1780\u17bc\u179a\u17c9\u17c1" },
            { "KW", "\u1782\u17bb\u1799\u179c\u17c9\u17c2\u178f" },
            { "KZ", "\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u178f\u17b6\u1784\u17cb\u17cb" },
            { "LA", "\u17a1\u17b6\u179c" },
            { "LB", "\u179b\u17b8\u1794\u1784\u17cb" },
            { "LI", "\u179b\u17b7\u1785\u1791\u17c1\u1793\u179f\u17d2\u178f\u17c2\u1793" },
            { "LK", "\u179f\u17d2\u179a\u17b8\u179b\u1784\u17d2\u1780\u17b6" },
            { "LR", "\u179b\u17b8\u1794\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "LS", "\u179b\u17be\u179f\u17bc\u178f\u17bc" },
            { "LT", "\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8" },
            { "LU", "\u179b\u17bb\u1785\u17a0\u17d2\u179f\u17c6\u1794\u17bd\u179a" },
            { "LV", "\u17a1\u17b6\u178f\u179c\u17b8\u1799\u17c9\u17b6" },
            { "LY", "\u179b\u17b8\u1794\u17ca\u17b8" },
            { "MA", "\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780" },
            { "MC", "\u1798\u17c9\u17bc\u178e\u17b6\u1780\u17bc" },
            { "MD", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8" },
            { "MG", "\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1780\u17b6\u179f\u17d2\u1780\u17b6\u179a" },
            { "MK", "\u1798\u17c9\u17b6\u179f\u17c1\u178a\u1793" },
            { "ML", "\u1798\u17c9\u17b6\u179b\u17b8" },
            { "MM", "\u1798\u17b8\u1799\u17c9\u17b6\u1793\u17cb\u1798\u17c9\u17b6" },
            { "MN", "\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8" },
            { "MR", "\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8" },
            { "MT", "\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6" },
            { "MU", "\u1798\u17c9\u17bc\u179a\u17b8\u1791\u17bb\u179f" },
            { "MX", "\u1798\u17c9\u17b7\u1785\u179f\u17b7\u1780" },
            { "MY", "\u1798\u17c9\u17b6\u179b\u17c1\u179f\u17c9\u17b8" },
            { "MZ", "\u1798\u17c9\u17bc\u17a0\u17d2\u179f\u17b6\u17c6\u1794\u17ca\u17b7\u1780" },
            { "NA", "\u178e\u17b6\u1798\u17b8\u1794\u17ca\u17b8" },
            { "NE", "\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a" },
            { "NG", "\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "NI", "\u1793\u17b8\u1780\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17d0\u179a" },
            { "NL", "\u17a0\u17bc\u179b\u17d2\u179b\u1784\u17cb" },
            { "NO", "\u1793\u17d0\u179a\u179c\u17c2\u179f" },
            { "NP", "\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb" },
            { "NZ", "\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u179f\u17c1\u17a1\u1784\u17cb" },
            { "OM", "\u17a2\u17bc\u1798\u17c9\u1784\u17cb" },
            { "PA", "\u1794\u17c9\u17b6\u178e\u17b6\u1798\u17c9\u17b6" },
            { "PE", "\u1794\u17c9\u17c1\u179a\u17bc" },
            { "PG", "\u1794\u17c9\u17b6\u1796\u17bc\u17a2\u17b6\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "PH", "\u17a0\u17d2\u179c\u17c9\u17b8\u179b\u17b8\u1796\u17b8\u1793" },
            { "PK", "\u1794\u17c9\u17b6\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "PL", "\u1794\u17c9\u17bc\u179b\u17bc\u1789" },
            { "PR", "\u1796\u17d0\u179a\u178f\u17bc\u179a\u17b8\u1780\u17bc" },
            { "PS", "\u1794\u17c9\u17b6\u179b\u17c1\u179f\u17d2\u1791\u17b8\u1793" },
            { "PT", "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb" },
            { "PY", "\u1794\u17c9\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799" },
            { "QA", "\u1780\u17b6\u178f\u17b6\u179a" },
            { "RO", "\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8" },
            { "RU", "\u179a\u17bc\u179f\u17d2\u179f\u17ca\u17b8" },
            { "RW", "\u179a\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6" },
            { "SA", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u179f\u17b6\u17a2\u17ca\u17bc\u178c\u17b8\u178f" },
            { "SC", "\u179f\u17b8\u179f\u17c2\u179b" },
            { "SD", "\u179f\u17ca\u17bc\u178a\u1784\u17cb" },
            { "SE", "\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178a" },
            { "SG", "\u179f\u17b7\u1784\u17d2\u17a0\u1794\u17bb\u179a\u17b8" },
            { "SI", "\u179f\u17d2\u179b\u17bc\u179c\u17c1\u1793\u17b8" },
            { "SK", "\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8" },
            { "SL", "\u179f\u17c1\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793" },
            { "SN", "\u179f\u17c1\u1793\u17c1\u17a0\u17d2\u1780\u17b6\u179b\u17cb" },
            { "SO", "\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8" },
            { "SR", "\u179f\u17bc\u179a\u17b8\u178e\u17b6\u1798" },
            { "SV", "\u17a2\u17c2\u179b\u179f\u17b6\u179b\u17cb\u179c\u17c9\u17b6\u178c\u17d0\u179a" },
            { "SY", "\u179f\u17ca\u17b8\u179a\u17b8" },
            { "SZ", "\u179f\u17bc\u17a0\u17d2\u179f\u17c9\u17b8\u17a1\u1784\u17cb" },
            { "TD", "\u1786\u17b6\u178a" },
            { "TG", "\u178f\u17bc\u17a0\u17d2\u1782\u17bc" },
            { "TH", "\u1790\u17c3" },
            { "TJ", "\u178f\u17b6\u178a\u17a0\u17d2\u179f\u17c9\u17b8\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "TL", "\u1791\u17b8\u1798\u17d0\u179a\u1781\u17b6\u1784\u1780\u17be\u178f" },
            { "TM", "\u1791\u17bd\u1782\u1798\u17c1\u1793\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "TN", "\u1791\u17bb\u1799\u1793\u17c1\u179f\u17ca\u17b8" },
            { "TO", "\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6" },
            { "TR", "\u1791\u17bd\u179a\u1782\u17b8" },
            { "TT", "\u1791\u17d2\u179a\u17b8\u1793\u17b8\u178a\u17b6\u178a\u1793\u17b9\u1784\u178f\u17bc\u1794\u17b6\u17a0\u17d2\u1782\u17c4" },
            { "TW", "\u178f\u17c3\u179c\u17c9\u17b6\u1793\u17cb" },
            { "TZ", "\u178f\u1784\u17cb\u17a0\u17d2\u179f\u17b6\u1793\u17b8" },
            { "UA", "\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793" },
            { "UG", "\u17a2\u17ca\u17bc\u17a0\u17d2\u1780\u1784\u17cb\u178a\u17b6" },
            { "US", "\u179f\u17a0\u179a\u178a\u17d2\u178b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "UY", "\u17a2\u17ca\u17bb\u1799\u179a\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u1799" },
            { "UZ", "\u17a2\u17ca\u17bc\u17a0\u17d2\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "VA", "\u179c\u17c9\u17b6\u1791\u17b8\u1780\u1784\u17cb" },
            { "VE", "\u179c\u17c1\u1793\u17c1\u17a0\u17d2\u179f\u17ca\u17bb\u1799\u17a1\u17b6" },
            { "VN", "\u179c\u17c0\u178f\u178e\u17b6\u1798" },
            { "WS", "\u179f\u17b6\u1798\u17bc\u17a2\u17b6" },
            { "YE", "\u1799\u17c1\u1798\u17c2\u1793" },
            { "ZA", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "ZM", "\u17a0\u17d2\u179f\u17b6\u17c6\u1794\u17ca\u17b8" },
            { "ZW", "\u17a0\u17d2\u179f\u17ca\u17b8\u1798\u1794\u17b6\u1794\u179c\u17c9\u17c1" },
            { "aa", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17b6\u179a" },
            { "ae", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179c\u17c2\u179f\u17d2\u178f\u1784\u17cb" },
            { "af", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b8\u1780\u17b6\u17a2\u17b6\u1793" },
            { "an", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17c4\u1793" },
            { "ar", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb" },
            { "ay", "\u1797\u17b6\u179f\u17b6\u17a2\u17b8\u1798\u17c9\u17b6\u179a\u17c9\u17b6" },
            { "az", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17ca\u17d2\u179f\u17c2\u179a\u1794\u17c2\u17a0\u17d2\u179f\u1784\u17cb" },
            { "be", "\u1797\u17b6\u179f\u17b6\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f\u17d2\u179f" },
            { "bg", "\u1797\u17b6\u179f\u17b6\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1780\u17b6\u179a\u17b8" },
            { "bh", "\u1797\u17b6\u179f\u17b6\u1794\u17b7\u17a0\u17b6\u179a" },
            { "bm", "\u1797\u17b6\u179f\u17b6\u1794\u17b6\u1798\u17d2\u1794\u17b6\u179a\u17b6" },
            { "bn", "\u1797\u17b6\u179f\u17b6\u1794\u17c1\u1793\u17d2\u1780\u17b6\u179b\u17b8" },
            { "bo", "\u1797\u17b6\u179f\u17b6\u1791\u17b8\u1794\u17c1" },
            { "ca", "\u1797\u17b6\u179f\u17b6\u1780\u17b6\u178f\u17b6\u17a1\u17b6\u1793" },
            { "cs", "\u1797\u17b6\u179f\u17b6\u1786\u17c1\u1780" },
            { "da", "\u1797\u17b6\u179f\u17b6\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780" },
            { "de", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb" },
            { "dz", "\u1797\u17b6\u179f\u17b6\u1794\u17ca\u17bc\u178f\u17b6\u1793" },
            { "el", "\u1797\u17b6\u179f\u17b6\u1780\u17d2\u179a\u17b7\u1785" },
            { "en", "\u1797\u17b6\u179f\u17b6\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "eo", "\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u1796\u17c1\u179a\u17c9\u17b6\u1793\u17d2\u1791\u17c4" },
            { "es", "\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789" },
            { "et", "\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8" },
            { "eu", "\u1797\u17b6\u179f\u17b6\u1794\u17b6\u179f\u17d2\u1780\u17c1" },
            { "fi", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb" },
            { "fj", "\u17a0\u17d2\u179c\u17c9\u17b8\u17a0\u17d2\u179f\u17c9\u17b8" },
            { "fr", "\u1797\u17b6\u179f\u17b6\u1794\u17b6\u179a\u17b6\u17c6\u1784" },
            { "ga", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782" },
            { "gd", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782 [gd]" },
            { "gl", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17b6\u179b\u17b8\u179f\u17c9\u17b8" },
            { "gn", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17bd\u179a\u17c9\u17b6\u1793\u17b8" },
            { "gu", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17bb\u1799\u17c9\u17b6\u179a\u17b6\u1791\u17b8" },
            { "he", "\u1797\u17b6\u179f\u17b6\u17a0\u17c1\u1794\u17d2\u179a\u17b7" },
            { "hi", "\u1797\u17b6\u179f\u17b6\u17a0\u17c9\u17b7\u1793\u178c\u17b8" },
            { "hu", "\u1797\u17b6\u179f\u17b6\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8" },
            { "hy", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u1798\u17c1\u1793\u17b8" },
            { "id", "\u1797\u17b6\u179f\u17b6\u17a5\u178e\u17d2\u178c\u17bc\u1793\u17c1\u179f\u17ca\u17b8" },
            { "is", "\u1797\u17b6\u179f\u17b6\u17a2\u17c9\u17b8\u179f\u17d2\u179b\u1784\u17cb" },
            { "it", "\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8" },
            { "ja", "\u1797\u17b6\u179f\u17b6\u1787\u1794\u17c9\u17bb\u1793" },
            { "jv", "\u1797\u17b6\u179f\u17b6\u1799\u17c9\u17b6\u179c\u17b6" },
            { "ka", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17c9\u17b8" },
            { "kk", "\u1797\u17b6\u179f\u17b6\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u178f\u1784\u17cb\u17cb" },
            { "km", "\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a" },
            { "kn", "\u1797\u17b6\u179f\u17b6\u1780\u17b7\u178e\u17b6\u178a\u17b6" },
            { "ko", "\u1797\u17b6\u179f\u17b6\u1780\u17bc\u179a\u17c9\u17c1" },
            { "ku", "\u1797\u17b6\u179f\u17b6\u1783\u17ba\u178a" },
            { "ky", "\u1797\u17b6\u179f\u17b6\u1782\u17c0\u179a\u17a0\u17d2\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "la", "\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u178f\u17c6\u17b6\u1784" },
            { "lo", "\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u179c" },
            { "lt", "\u1797\u17b6\u179f\u17b6\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8" },
            { "lv", "\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u178f\u179c\u17b8\u1799\u17c9\u17b6" },
            { "mg", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1780\u17b6\u179f\u1780\u17b6\u179a" },
            { "mi", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17c4\u179a\u17b8" },
            { "mk", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17bc\u1793\u17b8" },
            { "ml", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u17a1\u17b6\u17a1\u17b6\u1799\u17c9\u17b6\u1793" },
            { "mn", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8" },
            { "mo", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8" },
            { "mr", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179a\u17b6\u1792\u17b8" },
            { "ms", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179b\u17c1\u179f\u17c9\u17b8" },
            { "mt", "\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6" },
            { "ne", "\u1797\u17b6\u179f\u17b6\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb" },
            { "nl", "\u1797\u17b6\u179f\u17b6\u17a0\u17bb\u179b\u17d2\u179b\u1784\u17cb" },
            { "no", "\u1797\u17b6\u179f\u17b6\u1793\u17d0\u179a\u179c\u17c2\u179f" },
            { "or", "\u1797\u17b6\u179f\u17b6\u17a2\u17bc\u179a\u17b8\u1799\u17c9\u17b6" },
            { "pa", "\u1797\u17b6\u179f\u17b6\u1796\u17bc\u1793\u1799\u17c9\u17b6\u1794\u17ca\u17b8" },
            { "pl", "\u1797\u17b6\u179f\u17b6\u1794\u17c9\u17bc\u17a1\u17bc\u1789" },
            { "pt", "\u1797\u17b6\u179f\u17b6\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb" },
            { "qu", "\u1797\u17b6\u179f\u17b6\u1780\u17c1\u1791\u17d2\u1787\u17bc\u17a2\u17b6" },
            { "rn", "\u1797\u17b6\u179f\u17b6\u179a\u17bc\u1793\u17d2\u178c\u17b8" },
            { "ro", "\u1797\u17b6\u179f\u17b6\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8" },
            { "sa", "\u1797\u17b6\u179f\u17b6\u179f\u17c6\u179f\u17d2\u1780\u17d2\u179a\u17b9\u178f" },
            { "sd", "\u1797\u17b6\u179f\u17b6\u179f\u17c9\u17b8\u1793\u17d2\u178a\u17b8" },
            { "sk", "\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8" },
            { "sl", "\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1793\u17b8" },
            { "sm", "\u1797\u17b6\u179f\u17b6\u179f\u17b6\u1798\u17bc\u17a2\u17b6" },
            { "so", "\u1797\u17b6\u179f\u17b6\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8" },
            { "sq", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8" },
            { "su", "\u1797\u17b6\u17c6\u179f\u17b6\u179f\u17ca\u17bc\u178a\u1784\u17cb" },
            { "sv", "\u1797\u17b6\u179f\u17b6\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178a" },
            { "sw", "\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179c\u17b6\u17a0\u17c9\u17b8\u179b\u17b8" },
            { "ta", "\u1797\u17b6\u179f\u17b6\u178f\u17b6\u1798\u17b8\u179b" },
            { "te", "\u1797\u17b6\u179f\u17b6\u178f\u17c1\u179b\u17bc\u17a0\u17d2\u1782\u17bc" },
            { "tg", "\u1797\u17b6\u179f\u17b6\u178f\u17b6\u178a\u17a0\u17d2\u179f\u17c9\u17b8\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "th", "\u1797\u17b6\u179f\u17b6\u1790\u17c3" },
            { "tk", "\u1797\u17b6\u179f\u17b6\u1791\u17bd\u1782\u1798\u17c1\u1793\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "to", "\u1797\u17b6\u179f\u17b6\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17c4" },
            { "tr", "\u1797\u17b6\u179f\u17b6\u1791\u17bd\u179a\u1782\u17b8" },
            { "tt", "\u1797\u17b6\u179f\u17b6\u178f\u17b6\u178f\u17b6\u179a" },
            { "uk", "\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793" },
            { "ur", "\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bc\u179a\u17d2\u178c\u17bc" },
            { "uz", "\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bc\u17a0\u17d2\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "vi", "\u1797\u17b6\u179f\u17b6\u179c\u17c0\u178f\u178e\u17b6\u1798" },
            { "xh", "\u1797\u17b6\u179f\u17b6\u1783\u179f\u17b6" },
            { "yi", "\u1797\u17b6\u179f\u17b6\u1799\u17b8\u178c\u17b8\u17a0\u17d2\u179f" },
            { "yo", "\u1797\u17b6\u179f\u17b6\u1799\u179a\u17bc\u1794\u17b6" },
            { "za", "\u1797\u17b6\u179f\u17b6\u1785\u17bd\u1784" },
            { "zh", "\u1797\u17b6\u179f\u17b6\u1785\u17b7\u1793" },
            { "zu", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179f\u17c9\u17bc\u179b\u17bc" },
        };
        return data;
    }
}
