/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.nl;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_nl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Centraal-Afrikaanse tijd",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskou-standaardtijd",
               "MST",
               "Moskou-zomertijd",
               "MST",
               "Moskou-tijd",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japanse standaardtijd",
               "JST",
               "Japanse zomertijd",
               "JDT",
               "Japanse tijd",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistaanse standaardtijd",
               "PST",
               "Pakistaanse zomertijd",
               "PST",
               "Pakistaanse tijd",
               "PT",
            };
        final String[] Hovd = new String[] {
               "Hovd-standaardtijd",
               "HST",
               "Hovd-zomertijd",
               "HST",
               "Hovd-tijd",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Magadan-standaardtijd",
               "MST",
               "Magadan-zomertijd",
               "MST",
               "Magadan-tijd",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Midden-Australische westelijke standaardtijd",
               "ACWST",
               "Midden-Australische westelijke zomertijd",
               "ACWDT",
               "Midden-Australische westelijke tijd",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Midden-Europese standaardtijd",
               "CET",
               "Midden-Europese zomertijd",
               "CEST",
               "Midden-Europese tijd",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sachalin-standaardtijd",
               "SST",
               "Sachalin-zomertijd",
               "SST",
               "Sakhalin-tijd",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "Paraguayaanse standaardtijd",
               "PST",
               "Paraguayaanse zomertijd",
               "PST",
               "Paraguayaanse tijd",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "Maleisische tijd",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern-standaardtijd",
               "EST",
               "Eastern-zomertijd",
               "EDT",
               "Eastern-tijd",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-standaardtijd",
               "LHST",
               "Lord Howe-zomertijd",
               "LHDT",
               "Lord Howe-tijd",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Nieuw-Zeelandse standaardtijd",
               "NZST",
               "Nieuw-Zeelandse zomertijd",
               "NZDT",
               "Nieuw-Zeelandse tijd",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indische Oceaan-tijd",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakoetsk-standaardtijd",
               "YST",
               "Jakoetsk-zomertijd",
               "YST",
               "Jakoetsk-tijd",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "Mauritiaanse tijd",
               "MST",
               "Mauritius Summer Time",
               "MST",
               "Mauritius Time",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "Oost-Afrikaanse tijd",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Oost-Timorese tijd",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "Solomoneilandse tijd",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Kosrae = new String[] {
               "Kosraese tijd",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalleilandse tijd",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "Oost-Europese standaardtijd",
               "EET",
               "Oost-Europese zomertijd",
               "EEST",
               "Oost-Europese tijd",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland-standaardtijd",
               "NST",
               "Newfoundland-zomertijd",
               "NDT",
               "Newfoundland-tijd",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afghaanse tijd",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkong-standaardtijd",
               "HKST",
               "Hongkong-zomertijd",
               "HKST",
               "Hongkong-tijd",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "West-Argentijnse standaardtijd",
               "WAST",
               "West-Argentijnse zomertijd",
               "WAST",
               "West-Argentijnse tijd",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Atlantic-standaardtijd",
               "AST",
               "Atlantic-zomertijd",
               "ADT",
               "Atlantic-tijd",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Pohnpeise tijd",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Bolivia = new String[] {
               "Boliviaanse tijd",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre en Miquelon-standaardtijd",
               "PMST",
               "Pierre en Miquelon-zomertijd",
               "PMDT",
               "Pierre en Miquelon-tijd",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indochinese tijd",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinenburg-standaardtijd",
               "YST",
               "Jekaterinenburg-zomertijd",
               "YST",
               "Jekaterinenburg-tijd",
               "YT",
            };
        final String[] Maldives = new String[] {
               "Maldivische tijd",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "Tahitiaanse tijd",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "Isra\u00eblische standaardtijd",
               "IST",
               "Isra\u00eblische zomertijd",
               "IDT",
               "Isra\u00eblische tijd",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centraal-Indonesische tijd",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "Wallis en Futunase tijd",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Zuid-Afrikaanse tijd",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa-tijd",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Line_Islands = new String[] {
               "Line-eilandse tijd",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Uzbekistan = new String[] {
               "Oezbeekse standaardtijd",
               "UST",
               "Oezbeekse zomertijd",
               "UST",
               "Oezbeekse tijd",
               "UT",
            };
        final String[] Omsk = new String[] {
               "Omsk-standaardtijd",
               "OST",
               "Omsk-zomertijd",
               "OST",
               "Omsk-tijd",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "Seychelse tijd",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "Uruguayaanse standaardtijd",
               "UST",
               "Uruguayaanse zomertijd",
               "UST",
               "Uruguayaanse tijd",
               "UT",
            };
        final String[] Nepal = new String[] {
               "Nepalese tijd",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-standaardtijd",
               "UBST",
               "Ulaanbaatar-zomertijd",
               "UBST",
               "Ulaanbaatar-tijd",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Central-standaardtijd",
               "CST",
               "Central-zomertijd",
               "CDT",
               "Central-tijd",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuukse tijd",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "Niuese tijd",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Wake = new String[] {
               "Wake-eilandse tijd",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "Falklandeilandse standaardtijd",
               "FIST",
               "Falklandeilandse zomertijd",
               "FIST",
               "Falklandeilandse tijd",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatuaanse standaardtijd",
               "VST",
               "Vanuatuaanse zomertijd",
               "VST",
               "Vanuatuaanse tijd",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk-standaardtijd",
               "NST",
               "Novosibirsk-zomertijd",
               "NST",
               "Novosibirsk-tijd",
               "NT",
            };
        final String[] Singapore = new String[] {
               "Singaporese standaardtijd",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Azores = new String[] {
               "Azoren-standaardtijd",
               "AST",
               "Azoren-zomertijd",
               "AST",
               "Azoren-tijd",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "Bhutaanse tijd",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "Surinaamse tijd",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Nauru = new String[] {
               "Nauruaanse tijd",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-standaardtijd",
               "KST",
               "Krasnojarsk-zomertijd",
               "KST",
               "Krasnojarsk-tijd",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "West-Kazachse tijd",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "Myanmarese tijd",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "Christmaseilandse tijd",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazone-standaardtijd",
               "AST",
               "Amazone-zomertijd",
               "AST",
               "Amazone-tijd",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oost-Kazachse tijd",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "Fijische standaardtijd",
               "FST",
               "Fijische zomertijd",
               "FST",
               "Fijische tijd",
               "FT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionse tijd",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "Cocoseilandse tijd",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "Chatham-standaardtijd",
               "CST",
               "Chatham-zomertijd",
               "CDT",
               "Chatham-tijd",
               "CT",
            };
        final String[] Vostok = new String[] {
               "Vostok-tijd",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Argentijnse standaardtijd",
               "AST",
               "Argentijnse zomertijd",
               "AST",
               "Argentijnse tijd",
               "AT",
            };
        final String[] Gambier = new String[] {
               "Gambiereilandse tijd",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaluaanse tijd",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "Galapagoseilandse tijd",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-tijd",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "Venezolaanse tijd",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleoetische standaardtijd",
               "HAST",
               "Hawaii-Aleoetische zomertijd",
               "HADT",
               "Hawaii-Aleoetische tijd",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Midden-Australische standaardtijd",
               "ACST",
               "Midden-Australische zomertijd",
               "ACDT",
               "Midden-Australische tijd",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Pacific-standaardtijd",
               "PST",
               "Pacific-zomertijd",
               "PDT",
               "Pacific-tijd",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixeilandse tijd",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmeense standaardtijd",
               "TST",
               "Turkmeense zomertijd",
               "TST",
               "Turkmeense tijd",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "West-Europese standaardtijd",
               "WET",
               "West-Europese zomertijd",
               "WEST",
               "West-Europese tijd",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kaapverdische standaardtijd",
               "CVST",
               "Kaapverdische zomertijd",
               "CVST",
               "Kaapverdische tijd",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolkeilandse tijd",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Guyana = new String[] {
               "Guyaanse tijd",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnse tijd",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera-tijd",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Samoa = new String[] {
               "Samoaanse standaardtijd",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "Belause tijd",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbeidzjaanse standaardtijd",
               "AST",
               "Azerbeidzjaanse zomertijd",
               "AST",
               "Azerbeidzjaanse tijd",
               "AT",
            };
        final String[] Mawson = new String[] {
               "Mawson-tijd",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis-tijd",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "Cubaanse standaardtijd",
               "CST",
               "Cubaanse zomertijd",
               "CDT",
               "Cubaanse tijd",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "West-Afrikaanse standaardtijd",
               "WAST",
               "West-Afrikaanse zomertijd",
               "WAST",
               "West-Afrikaanse tijd",
               "WAT",
            };
        final String[] Philippines = new String[] {
               "Filipijnse standaardtijd",
               "PST",
               "Filipijnse zomertijd",
               "PST",
               "Filipijnse tijd",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Franse zuidelijke en Antarctische tijd",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "Zuid-Georgische tijd",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "Nieuw-Caledonische standaardtijd",
               "NCST",
               "Nieuw-Caledonische zomertijd",
               "NCST",
               "Nieuw-Caledonische tijd",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "Wolgograd-standaardtijd",
               "VST",
               "Wolgograd-zomertijd",
               "VST",
               "Wolgograd-tijd",
               "VT",
            };
        final String[] Brunei = new String[] {
               "Bruneise tijd",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "Iraanse standaardtijd",
               "IST",
               "Iraanse zomertijd",
               "IDT",
               "Iraanse tijd",
               "IT",
            };
        final String[] Easter = new String[] {
               "Paaseilandse standaardtijd",
               "EIST",
               "Paaseilandse zomertijd",
               "EIST",
               "Paaseilandse tijd",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d'Urville-tijd",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tajikistan = new String[] {
               "Tadzjiekse tijd",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tonga = new String[] {
               "Tongaanse standaardtijd",
               "TST",
               "Tongaanse zomertijd",
               "TST",
               "Tongaanse tijd",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "Bengalese tijd",
               "BST",
               "Bangladesh Summer Time",
               "BST",
               "Bangladesh Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Peruaanse standaardtijd",
               "PST",
               "Peruaanse zomertijd",
               "PST",
               "Peruaanse tijd",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "West-Groenlandse standaardtijd",
               "WGST",
               "West-Groenlandse zomertijd",
               "WGST",
               "West-Groenlandse tijd",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ecuadoriaanse tijd",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "Oost-Groenlandse standaardtijd",
               "EGST",
               "Oost-Groenlandse zomertijd",
               "EGST",
               "Oost-Groenlandse tijd",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Golf-standaardtijd",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oost-Indonesische tijd",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Koreaanse standaardtijd",
               "KST",
               "Koreaanse zomertijd",
               "KDT",
               "Koreaanse tijd",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "West-Australische standaardtijd",
               "AWST",
               "West-Australische zomertijd",
               "AWDT",
               "West-Australische tijd",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizische tijd",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "West-Indonesische tijd",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Oost-Australische standaardtijd",
               "AEST",
               "Oost-Australische zomertijd",
               "AEDT",
               "Oost-Australische tijd",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "Frans-Guyaanse tijd",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "Colombiaanse standaardtijd",
               "CST",
               "Colombiaanse zomertijd",
               "CST",
               "Colombiaanse tijd",
               "CT",
            };
        final String[] Chile = new String[] {
               "Chileense standaardtijd",
               "CST",
               "Chileense zomertijd",
               "CST",
               "Chileense tijd",
               "CT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberteilandse tijd",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "Mountain-standaardtijd",
               "MST",
               "Mountain-zomertijd",
               "MDT",
               "Mountain-tijd",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesaseilandse tijd",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Arabische standaardtijd",
               "AST",
               "Arabische zomertijd",
               "ADT",
               "Arabische tijd",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska-standaardtijd",
               "AKST",
               "Alaska-zomertijd",
               "AKDT",
               "Alaska-tijd",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok-standaardtijd",
               "VST",
               "Vladivostok-zomertijd",
               "VST",
               "Vladivostok-tijd",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-tijd",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "Irkoetsk-standaardtijd",
               "IST",
               "Irkoetsk-zomertijd",
               "IST",
               "Irkoetsk-tijd",
               "IT",
            };
        final String[] Georgia = new String[] {
               "Georgische standaardtijd",
               "GST",
               "Georgische zomertijd",
               "GST",
               "Georgische tijd",
               "GT",
            };
        final String[] Tokelau = new String[] {
               "Tokelause tijd",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papoea-Nieuw-Guinea-tijd",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-standaardtijd",
               "FNST",
               "Fernando de Noronha-zomertijd",
               "FNST",
               "Fernando de Noronha-tijd",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan-standaardtijd",
               "CST",
               "Choibalsan-zomertijd",
               "CST",
               "Choibalsan-tijd",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Braziliaanse standaardtijd",
               "BST",
               "Braziliaanse zomertijd",
               "BST",
               "Brasilia-tijd",
               "BT",
            };
        final String[] China = new String[] {
               "Chinese standaardtijd",
               "CST",
               "Chinese zomertijd",
               "CDT",
               "Chinese tijd",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armeense standaardtijd",
               "AST",
               "Armeense zomertijd",
               "AST",
               "Armeense tijd",
               "AT",
            };
        final String[] India = new String[] {
               "Indiaase standaardtijd",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cookeilandse standaardtijd",
               "CIST",
               "Cookeilandse halve zomertijd",
               "CIHST",
               "Cookeilandse tijd",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
