/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.onebusaway.csv_entities.CSVListener;
import org.onebusaway.csv_entities.DelimitedTextParser;

public class CSVLibrary {
    private final DelimitedTextParser _parser = new DelimitedTextParser(',');

    public static String escapeValue(String value) {
        if (value.indexOf(44) != -1 || value.indexOf(34) != -1) {
            String string = String.valueOf(String.valueOf(value.replaceAll("\"", "\"\"")));
            value = new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
        }
        return value;
    }

    public static String getArrayAsCSV(double[] args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (double v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = false;
            }
            csv.append(v);
        }
        return csv.toString();
    }

    public static <T> String getArrayAsCSV(T[] args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (T v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public static <T> String getIterableAsCSV(Iterable<T> args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (T v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public static String getAsCSV(Object ... args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (Object v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public void setTrimInitialWhitespace(boolean trimInitialWhitespace) {
        this._parser.setTrimInitialWhitespace(trimInitialWhitespace);
    }

    public final void parse(InputStream is, CSVListener handler) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.parse(reader, handler);
    }

    public final void parse(File input, CSVListener handler) throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(input));
        this.parse(r, handler);
    }

    public void parse(BufferedReader r, CSVListener handler) throws IOException, Exception {
        String line = null;
        int lineNumber = 1;
        while ((line = r.readLine()) != null) {
            List<String> values = this.parse(line);
            try {
                handler.handleLine(values);
            }
            catch (Exception ex) {
                int n = lineNumber;
                throw new Exception(new StringBuilder(52).append("error handling csv record for lineNumber=").append(n).toString(), ex);
            }
            ++lineNumber;
        }
        r.close();
    }

    public final List<String> parse(String line) {
        return this._parser.parse(line);
    }
}

