/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.IndividualCsvEntityWriter;
import org.onebusaway.csv_entities.OutputStrategy;
import org.onebusaway.csv_entities.exceptions.CsvEntityIOException;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;

class FileOutputStrategy
implements OutputStrategy {
    private final File _outputDirectory;
    private Map<Class<?>, IndividualCsvEntityWriter> _writersByType = new HashMap();

    public FileOutputStrategy(File outputDirectory) {
        this._outputDirectory = outputDirectory;
    }

    @Override
    public IndividualCsvEntityWriter getEntityWriter(EntitySchemaFactory entitySchemaFactory, CsvEntityContext context, Class<?> entityType) {
        IndividualCsvEntityWriter entityWriter = this._writersByType.get(entityType);
        if (entityWriter == null) {
            EntitySchema schema = entitySchemaFactory.getSchema(entityType);
            File outputFile = new File(this._outputDirectory, schema.getFilename());
            if (!this._outputDirectory.exists()) {
                this._outputDirectory.mkdirs();
            }
            PrintWriter writer = this.openOutput(outputFile, entityType);
            entityWriter = new IndividualCsvEntityWriter(context, schema, writer);
            this._writersByType.put(entityType, entityWriter);
        }
        return entityWriter;
    }

    @Override
    public void flush() {
        for (IndividualCsvEntityWriter writer : this._writersByType.values()) {
            writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (IndividualCsvEntityWriter writer : this._writersByType.values()) {
            writer.close();
        }
    }

    private PrintWriter openOutput(File outputFile, Class<?> entityType) {
        try {
            return new PrintWriter(outputFile, "UTF-8");
        }
        catch (IOException ex) {
            throw new CsvEntityIOException(entityType, outputFile.getAbsolutePath(), 0, ex);
        }
    }
}

