/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.onebusaway.csv_entities.exceptions.NoCsvFieldsAnnotationException;
import org.onebusaway.csv_entities.schema.AbstractEntitySchemaFactoryImpl;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.csv_entities.schema.beans.CsvEntityMappingBean;
import org.onebusaway.csv_entities.schema.beans.CsvFieldMappingBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDrivenEntitySchemaFactory
extends AbstractEntitySchemaFactoryImpl {
    private static final String FILE_URL_PREFIX = "file:";
    private static final String URL_PROTOCOL_FILE = "file";
    private static final String URL_PROTOCOL_JAR = "jar";
    private static final String URL_PROTOCOL_ZIP = "zip";
    private static final String URL_PROTOCOL_WSJAR = "wsjar";
    private static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    private static final String JAR_URL_SEPARATOR = "!/";
    private final Logger _log = LoggerFactory.getLogger(AnnotationDrivenEntitySchemaFactory.class);
    private List<String> _packagesToScan = new ArrayList<String>();
    private List<Class<?>> _classesToScan = new ArrayList();

    public void addPackageToScan(String packageToScan) {
        this._packagesToScan.add(packageToScan);
    }

    public void addEntityClass(Class<?> classToScan) {
        this._classesToScan.add(classToScan);
    }

    @Override
    protected void processBeanDefinitions() {
        for (Class<?> entityClass : this._classesToScan) {
            CsvEntityMappingBean bean = this.getEntityMappingBeanForEntityClass(entityClass);
            this.registerBeanDefinition(bean);
        }
        try {
            this.scanPackages();
        }
        catch (IOException ex) {
            this._log.warn("error scanning classpath for classes", (Throwable)ex);
        }
    }

    private void go(String cName) {
        try {
            Class<?> entityClass = Class.forName(cName);
            CsvFields csvFields = entityClass.getAnnotation(CsvFields.class);
            if (csvFields != null) {
                CsvEntityMappingBean mappingBean = this.getEntityMappingBeanForEntityClass(entityClass);
                this.registerBeanDefinition(mappingBean);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private CsvEntityMappingBean getEntityMappingBeanForEntityClass(Class<?> entityClass) {
        CsvFields csvFields = entityClass.getAnnotation(CsvFields.class);
        if (csvFields == null) {
            throw new NoCsvFieldsAnnotationException(entityClass);
        }
        CsvEntityMappingBean bean = new CsvEntityMappingBean(entityClass);
        this.applyCsvFieldsAnnotationToBean(entityClass, bean);
        for (Field field : entityClass.getDeclaredFields()) {
            if ((field.getModifiers() & 0x18) != 0) continue;
            CsvFieldMappingBean fieldBean = new CsvFieldMappingBean(field);
            this.applyCsvFieldAnnotationToBean(field, fieldBean);
            bean.addField(fieldBean);
        }
        return bean;
    }

    private void scanPackages() throws IOException {
        ClassLoader cl = AnnotationDrivenEntitySchemaFactory.class.getClassLoader();
        for (String packageToScan : this._packagesToScan) {
            if (packageToScan == null) continue;
            String pkg = packageToScan.replace('.', '/');
            Enumeration<URL> en = cl.getResources(pkg);
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                if (AnnotationDrivenEntitySchemaFactory.isJarURL(url)) {
                    URL jarURL = AnnotationDrivenEntitySchemaFactory.extractJarFileURL(url);
                    File jarPath = AnnotationDrivenEntitySchemaFactory.getFile(jarURL);
                    JarFile jar = new JarFile(jarPath);
                    Enumeration<JarEntry> en2 = jar.entries();
                    while (en2.hasMoreElements()) {
                        JarEntry entry = en2.nextElement();
                        String name = entry.getName();
                        if (!name.startsWith(pkg) || !name.endsWith(".class")) continue;
                        String cName = name.replace(".class", "").replace('/', '.');
                        this.go(cName);
                    }
                    continue;
                }
                String path = URLDecoder.decode(url.getPath(), "UTF-8");
                String root = new File(path.replace(pkg, "")).getAbsolutePath();
                if (!root.endsWith(File.separator)) {
                    String string = String.valueOf(root);
                    String string2 = String.valueOf(File.separator);
                    root = string2.length() != 0 ? string.concat(string2) : new String(string);
                }
                this.scanFile(root, new File(path));
            }
        }
    }

    private void scanFile(String root, File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File fChild : files) {
                    this.scanFile(root, fChild);
                }
            }
        } else if (f.getName().endsWith(".class")) {
            String cName = f.getAbsolutePath().replace(root, "").replace(".class", "").replace('/', '.');
            this.go(cName);
        }
    }

    private static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().indexOf(JAR_URL_SEPARATOR) != -1;
    }

    private static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    String string = String.valueOf(jarFile);
                    jarFile = string.length() != 0 ? "/".concat(string) : new String("/");
                }
                String string = String.valueOf(FILE_URL_PREFIX);
                String string2 = String.valueOf(jarFile);
                return new URL(string2.length() != 0 ? string.concat(string2) : new String(string));
            }
        }
        return jarUrl;
    }

    private static File getFile(URL resourceUrl) throws FileNotFoundException {
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            String string = String.valueOf(String.valueOf("url cannot be resolved to absolute file path because it does not reside in the file system: "));
            String string2 = String.valueOf(String.valueOf(resourceUrl));
            throw new FileNotFoundException(new StringBuilder(0 + string.length() + string2.length()).append(string).append(string2).toString());
        }
        try {
            return new File(AnnotationDrivenEntitySchemaFactory.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    private static URI toURI(URL url) throws URISyntaxException {
        return AnnotationDrivenEntitySchemaFactory.toURI(url.toString());
    }

    private static URI toURI(String location) throws URISyntaxException {
        return new URI(location.replaceAll(" ", "%20"));
    }
}

