/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.auth;

import io.swagger.v3.parser.core.models.AuthorizationValue;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthParser.class);

    public static List<AuthorizationValue> parse(String urlEncodedAuthStr) {
        ArrayList<AuthorizationValue> auths = new ArrayList<AuthorizationValue>();
        if (StringUtils.isNotEmpty((CharSequence)urlEncodedAuthStr)) {
            String[] parts;
            for (String part : parts = urlEncodedAuthStr.split(",")) {
                String[] kvPair = part.split(":");
                if (kvPair.length != 2) continue;
                try {
                    auths.add(new AuthorizationValue(URLDecoder.decode(kvPair[0], "UTF-8"), URLDecoder.decode(kvPair[1], "UTF-8"), "header"));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        }
        return auths;
    }

    public static String reconstruct(List<AuthorizationValue> authorizationValueList) {
        if (authorizationValueList != null) {
            StringBuilder b = new StringBuilder();
            for (AuthorizationValue v : authorizationValueList) {
                try {
                    if (b.toString().length() > 0) {
                        b.append(",");
                    }
                    b.append(URLEncoder.encode(v.getKeyName(), "UTF-8")).append(":").append(URLEncoder.encode(v.getValue(), "UTF-8"));
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            return b.toString();
        }
        return null;
    }
}

